/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.qualifier;

import com.aerospike.client.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.IQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;

public abstract class BaseQualifierBuilder<T extends BaseQualifierBuilder<?>>
implements IQualifierBuilder {
    protected final Map<QualifierKey, Object> map = new HashMap<QualifierKey, Object>();

    public boolean getIgnoreCase() {
        return (Boolean)this.map.getOrDefault((Object)QualifierKey.IGNORE_CASE, false);
    }

    public FilterOperation getFilterOperation() {
        return (FilterOperation)((Object)this.map.get((Object)QualifierKey.FILTER_OPERATION));
    }

    public T setFilterOperation(FilterOperation operationType) {
        this.map.put(QualifierKey.FILTER_OPERATION, (Object)operationType);
        return (T)this;
    }

    public T setValue(Object value) {
        this.map.put(QualifierKey.VALUE, Value.get((Object)value));
        return (T)this;
    }

    public T setSecondValue(Object secondValue) {
        this.map.put(QualifierKey.SECOND_VALUE, Value.get((Object)secondValue));
        return (T)this;
    }

    public String getPath() {
        return (String)this.map.get((Object)QualifierKey.PATH);
    }

    public Value getValue() {
        return (Value)this.map.get((Object)QualifierKey.VALUE);
    }

    public Value getSecondValue() {
        return (Value)this.map.get((Object)QualifierKey.SECOND_VALUE);
    }

    @Override
    public Qualifier build() {
        this.validate();
        return new Qualifier(this.process(this));
    }

    @Override
    public Map<QualifierKey, Object> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    protected void validate() {
    }

    protected IQualifierBuilder process(BaseQualifierBuilder<T> builder) {
        return this;
    }
}

