/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.qualifier;

import org.springframework.data.aerospike.query.qualifier.BaseQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;
import org.springframework.util.Assert;

class ConjunctionQualifierBuilder
extends BaseQualifierBuilder<ConjunctionQualifierBuilder> {
    ConjunctionQualifierBuilder() {
    }

    ConjunctionQualifierBuilder setQualifiers(Qualifier ... qualifiers) {
        this.map.put(QualifierKey.QUALIFIERS, qualifiers);
        return this;
    }

    Qualifier[] getQualifiers() {
        return (Qualifier[])this.map.get((Object)QualifierKey.QUALIFIERS);
    }

    @Override
    protected void validate() {
        Assert.notNull((Object)this.getQualifiers(), (String)"Qualifiers must not be null");
        Assert.notEmpty((Object[])this.getQualifiers(), (String)"Qualifiers must not be empty");
        Assert.isTrue((this.getQualifiers().length > 1 ? 1 : 0) != 0, (String)"There must be at least 2 qualifiers");
    }
}

