/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.qualifier;

import com.aerospike.client.cdt.CTX;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.data.aerospike.index.AerospikeContextDslResolverUtils;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.BaseQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.IQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;
import org.springframework.data.aerospike.repository.query.QueryQualifierBuilder;
import org.springframework.util.StringUtils;

public class QualifierBuilder
extends BaseQualifierBuilder<QualifierBuilder> {
    QualifierBuilder() {
    }

    public QualifierBuilder setIgnoreCase(boolean ignoreCase) {
        this.map.put(QualifierKey.IGNORE_CASE, ignoreCase);
        return this;
    }

    public QualifierBuilder setPath(String path) {
        this.map.put(QualifierKey.PATH, path);
        return this;
    }

    @Override
    protected void validate() {
        if (!StringUtils.hasText((String)this.getPath())) {
            throw new IllegalArgumentException("Expecting path parameter to be provided");
        }
        if (this.getFilterOperation() == null) {
            throw new IllegalArgumentException("Expecting operation type parameter to be provided");
        }
        if (this.getValue() == null && this.getFilterOperation() != FilterOperation.IS_NULL && this.getFilterOperation() != FilterOperation.IS_NOT_NULL) {
            throw new IllegalArgumentException("Expecting value parameter to be provided");
        }
        List<FilterOperation> betweenList = List.of(FilterOperation.BETWEEN, FilterOperation.MAP_VAL_BETWEEN_BY_KEY, FilterOperation.MAP_VAL_BETWEEN, FilterOperation.MAP_KEYS_BETWEEN, FilterOperation.COLLECTION_VAL_BETWEEN);
        if (betweenList.contains((Object)this.getFilterOperation()) && (this.getValue() == null || this.getSecondValue() == null || this.getValue().getObject() == null || this.getSecondValue().getObject() == null)) {
            throw new IllegalArgumentException(this.getFilterOperation() + ": expecting both value and secondValue to be provided");
        }
    }

    @Override
    protected IQualifierBuilder process(BaseQualifierBuilder<QualifierBuilder> externalQb) {
        return this.getInnerQb(externalQb);
    }

    private QueryQualifierBuilder getInnerQb(BaseQualifierBuilder<QualifierBuilder> externalBuilder) {
        QueryQualifierBuilder innerQb;
        try {
            innerQb = this.getInnerQualifierBuilderInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize QueryQualifierBuilder", e.getCause());
        }
        this.setInnerQbOrFail(innerQb, externalBuilder.getPath());
        innerQb.setInnerQbFilterOperation(externalBuilder.getFilterOperation());
        innerQb.setValue(externalBuilder.getValue());
        if (externalBuilder.getSecondValue() != null) {
            innerQb.setSecondValue(externalBuilder.getSecondValue());
        }
        if (externalBuilder.getIgnoreCase()) {
            innerQb.setIgnoreCase(true);
        }
        return innerQb;
    }

    protected QueryQualifierBuilder getInnerQualifierBuilderInstance() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> qbClass = Class.forName("org.springframework.data.aerospike.repository.query.QueryQualifierBuilder");
        Constructor<?> ctor = qbClass.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        return (QueryQualifierBuilder)ctor.newInstance(new Object[0]);
    }

    private void setInnerQbOrFail(QueryQualifierBuilder innerQb, String path) {
        CTX[] ctxArr = this.resolveCtxPath(path);
        if (ctxArr.length >= 1) {
            if (!AerospikeContextDslResolverUtils.isCtxMapKey(ctxArr[0])) {
                throw new IllegalArgumentException(String.format("Cannot resolve the given path '%s', expecting the first element as a simple String", path));
            }
            innerQb.setBinName(ctxArr[0].value.toString());
            if (ctxArr.length == 1) {
                return;
            }
            CTX lastElement = ctxArr[ctxArr.length - 1];
            if (AerospikeContextDslResolverUtils.isCtxMapValue(lastElement)) {
                throw new UnsupportedOperationException(String.format("Unsupported path '%s', expecting the last element not to be a Map value", path));
            }
            innerQb.setKey(lastElement.value);
            if (ctxArr.length > 2) {
                innerQb.setCtxArray(Arrays.copyOfRange(ctxArr, 1, ctxArr.length - 1));
                CTX secondElement = ctxArr[1];
                innerQb.setBinType(AerospikeContextDslResolverUtils.getCtxType(secondElement));
            } else {
                innerQb.setBinType(AerospikeContextDslResolverUtils.getCtxType(lastElement));
            }
        } else {
            throw new IllegalArgumentException(String.format("Cannot resolve the given path '%s'", path));
        }
    }

    private CTX[] resolveCtxPath(String path) {
        if (path == null) {
            return null;
        }
        return (CTX[])Arrays.stream(path.split("\\.")).filter(Predicate.not(String::isEmpty)).map(AerospikeContextDslResolverUtils::toCtx).filter(Objects::nonNull).toArray(CTX[]::new);
    }
}

