/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.index.AerospikeContextDslResolverUtils;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.QueryQualifierBuilder;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AerospikeQueryCreatorUtils {
    protected static Qualifier setQualifier(QueryQualifierBuilder qb, String binName, FilterOperation op, Part part, List<String> dotPath, ServerVersionSupport versionSupport) {
        qb.setBinName(binName).setInnerQbFilterOperation(op).setIgnoreCase(AerospikeQueryCreatorUtils.ignoreCaseToBoolean(part));
        if (dotPath != null && !qb.hasDotPath()) {
            qb.setDotPath(dotPath);
            String[] dotPathArr = AerospikeQueryCreatorUtils.getDotPathArray(dotPath);
            if (dotPathArr != null && dotPathArr.length > 2) {
                List<String> ctxList = AerospikeQueryCreatorUtils.convertToStringListExclStartAndEnd(dotPathArr);
                qb.setCtxArray(AerospikeQueryCreatorUtils.resolveCtxList(ctxList));
            }
        }
        qb.setServerVersionSupport(versionSupport);
        return qb.build();
    }

    public static CTX[] resolveCtxList(List<String> ctxList) {
        return (CTX[])ctxList.stream().filter(Predicate.not(String::isEmpty)).map(AerospikeContextDslResolverUtils::toCtx).filter(Objects::nonNull).toArray(CTX[]::new);
    }

    public static String[] getDotPathArray(List<String> dotPathList) {
        if (dotPathList != null && !dotPathList.isEmpty()) {
            Stream valueStream = dotPathList.size() == 1 || dotPathList.get(1) == null ? Stream.empty() : Stream.of(dotPathList.get(1));
            return (String[])Stream.concat(Arrays.stream(dotPathList.get(0).split("\\.")), valueStream).toArray(String[]::new);
        }
        return null;
    }

    protected static List<String> convertToStringListExclStartAndEnd(@NonNull String[] array) {
        return Arrays.stream(array).skip(1L).limit((long)array.length - 2L).collect(Collectors.toList());
    }

    public static List<String> convertToStringListExclStart(@NonNull String[] array) {
        return Arrays.stream(array).skip(1L).limit((long)array.length - 1L).collect(Collectors.toList());
    }

    protected static Object convertNullParameter(Object value) {
        return value == CriteriaDefinition.AerospikeNullQueryCriterion.NULL_PARAM ? Value.getAsNull() : value;
    }

    protected static boolean ignoreCaseToBoolean(Part part) {
        return switch (part.shouldIgnoreCase()) {
            case Part.IgnoreCaseType.WHEN_POSSIBLE -> {
                if (part.getProperty().getType() == String.class) {
                    yield true;
                }
                yield false;
            }
            case Part.IgnoreCaseType.ALWAYS -> true;
            default -> false;
        };
    }

    protected static PropertyPath getNestedPropertyPath(PropertyPath propertyPath) {
        PropertyPath result = null;
        for (PropertyPath current = propertyPath; current != null; current = current.next()) {
            result = current;
        }
        return result;
    }

    protected static Class<?> getCollectionElementsClass(PropertyPath property) {
        if (property.getTypeInformation().getComponentType() == null) {
            return null;
        }
        return property.getTypeInformation().getComponentType().getType();
    }

    protected static Qualifier qualifierAndConcatenated(ServerVersionSupport versionSupport, List<Object> params, QueryQualifierBuilder qb, Part part, String fieldName, FilterOperation op, List<String> dotPath) {
        return AerospikeQueryCreatorUtils.qualifierAndConcatenated(versionSupport, params, qb, part, fieldName, op, dotPath, false);
    }

    protected static Qualifier qualifierAndConcatenated(ServerVersionSupport versionSupport, List<Object> params, QueryQualifierBuilder qb, Part part, String fieldName, FilterOperation op, List<String> dotPath, boolean containingMapKeyValuePairs) {
        int i;
        Qualifier[] qualifiers;
        if (containingMapKeyValuePairs) {
            qualifiers = new Qualifier[params.size() / 2];
            i = 0;
            int j = 0;
            while (i < params.size()) {
                AerospikeQueryCreatorUtils.setQbValuesForMapByKey(qb, params.get(i), params.get(i + 1));
                qualifiers[j] = AerospikeQueryCreatorUtils.setQualifier(qb, fieldName, op, part, dotPath, versionSupport);
                i += 2;
                ++j;
            }
        }
        qualifiers = new Qualifier[params.size()];
        for (i = 0; i < params.size(); ++i) {
            AerospikeQueryCreatorUtils.setQbValuesForMapByKey(qb, params.get(i), params.get(i));
            qualifiers[i] = AerospikeQueryCreatorUtils.setQualifier(qb, fieldName, op, part, dotPath, versionSupport);
        }
        return Qualifier.and(qualifiers);
    }

    protected static String getFieldName(String segmentName, AerospikePersistentProperty property) {
        Field annotation = (Field)property.findAnnotation(Field.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value())) {
            return annotation.value();
        }
        if (!StringUtils.hasText((String)segmentName)) {
            throw new IllegalStateException("Segment name is null or empty");
        }
        return segmentName;
    }

    protected static void setQbValuesForMapByKey(QueryQualifierBuilder qb, Object key, Object value) {
        qb.setKey(Value.get((Object)value));
        qb.setValue(key);
    }

    protected static Object convertIfNecessary(Object obj, MappingAerospikeConverter converter) {
        if (AerospikeQueryCreatorUtils.typeDoesNotRequireConversion(obj)) {
            return obj;
        }
        TypeInformation valueType = TypeInformation.of(obj.getClass());
        return converter.toWritableValue(obj, valueType);
    }

    private static boolean typeDoesNotRequireConversion(Object obj) {
        return obj == null || obj instanceof CriteriaDefinition.AerospikeQueryCriterion || obj instanceof CriteriaDefinition.AerospikeNullQueryCriterion;
    }

    protected static Value getValueOfQueryParameter(Object queryParameter) {
        return Value.get((Object)AerospikeQueryCreatorUtils.convertNullParameter(queryParameter));
    }

    protected static void setQualifierBuilderKey(QueryQualifierBuilder qb, Object key) {
        qb.setKey(AerospikeQueryCreatorUtils.getValueOfQueryParameter(key));
    }

    protected static void setQualifierBuilderSecondKey(QueryQualifierBuilder qb, Object key) {
        qb.setNestedKey(AerospikeQueryCreatorUtils.getValueOfQueryParameter(key));
    }

    protected static void setQualifierBuilderValue(QueryQualifierBuilder qb, Object value) {
        qb.setValue(AerospikeQueryCreatorUtils.getValueOfQueryParameter(value));
    }

    protected static void setQualifierBuilderSecondValue(QueryQualifierBuilder qb, Object value) {
        qb.setSecondValue(AerospikeQueryCreatorUtils.getValueOfQueryParameter(value));
    }

    protected static FilterOperation getCorrespondingMapValueFilterOperationOrFail(FilterOperation op) {
        try {
            return FilterOperation.valueOf("MAP_VAL_" + op + "_BY_KEY");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find corresponding MAP_VAL_..._BY_KEY FilterOperation for '" + op + "'");
        }
    }

    protected static boolean isPojo(Class<?> clazz) {
        TypeInformation type = TypeInformation.of(clazz);
        return !Utils.isSimpleValueType(clazz) && !type.isCollectionLike();
    }

    protected static void validateTypes(MappingAerospikeConverter converter, PropertyPath propertyPath, FilterOperation op, List<Object> queryParameters) {
        String queryPartDescription = String.join((CharSequence)" ", propertyPath.toString(), op.toString());
        AerospikeQueryCreatorUtils.validateTypes(converter, propertyPath, queryParameters, op, queryPartDescription);
    }

    protected static void validateTypes(MappingAerospikeConverter converter, PropertyPath propertyPath, List<Object> queryParameters, FilterOperation op, String queryPartDescription) {
        AerospikeQueryCreatorUtils.validateTypes(converter, propertyPath.getTypeInformation().getType(), queryParameters, op, queryPartDescription, new String[0]);
    }

    protected static void validateTypes(MappingAerospikeConverter converter, Class<?> propertyType, List<Object> queryParameters, FilterOperation op, String queryPartDescription, String ... alternativeTypes) {
        if (AerospikeQueryCreatorUtils.propertyTypeAndFirstParamAssignableToNumber(propertyType, queryParameters)) {
            propertyType = Number.class;
        }
        Class<?> clazz = propertyType;
        Stream params = queryParameters.stream();
        if ((op == FilterOperation.IN || op == FilterOperation.NOT_IN) && queryParameters.size() == 1 && queryParameters.get(0) instanceof Collection) {
            params = ((Collection)queryParameters.get(0)).stream();
        }
        if (!StringUtils.hasText((String)converter.getAerospikeDataSettings().getClassKey())) {
            return;
        }
        if (!params.allMatch(param -> AerospikeQueryCreatorUtils.isAssignableValueOrConverted(clazz, param, converter))) {
            String validTypes = propertyType.getSimpleName();
            if (alternativeTypes.length > 0) {
                validTypes = String.format("one of the following types: %s", propertyType.getSimpleName() + ", " + String.join((CharSequence)", ", alternativeTypes));
            }
            throw new IllegalArgumentException(String.format("%s: Type mismatch, expecting %s", queryPartDescription, validTypes));
        }
    }

    private static boolean propertyTypeAndFirstParamAssignableToNumber(Class<?> propertyType, List<Object> queryParameters) {
        return !queryParameters.isEmpty() && ClassUtils.isAssignable(Number.class, propertyType) && ClassUtils.isAssignableValue(Number.class, (Object)queryParameters.get(0));
    }

    protected static void validateQueryIsNull(List<Object> queryParameters, String queryPartDescription) {
        if (!queryParameters.isEmpty()) {
            throw new IllegalArgumentException(queryPartDescription + ": expecting no arguments");
        }
    }

    protected static void validateQueryIn(List<Object> queryParameters, String queryPartDescription) {
        if (queryParameters.size() != 1) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one");
        }
    }

    protected static boolean isAssignableValueOrConverted(Class<?> propertyType, Object obj, MappingAerospikeConverter converter) {
        return ClassUtils.isAssignableValue(propertyType, (Object)obj) || converter.getCustomConversions().hasCustomReadTarget(obj.getClass(), propertyType) || AerospikeQueryCreatorUtils.isPojoMap(obj, propertyType, converter.getAerospikeDataSettings().getClassKey()) || propertyType.isEnum() && obj instanceof String;
    }

    protected static boolean isPojoMap(Object object, Class<?> propertyType, String classKey) {
        if (object instanceof TreeMap) {
            TreeMap treeMap = (TreeMap)object;
            Object className = treeMap.get(classKey);
            return className != null && className.equals(propertyType.getName());
        }
        return false;
    }
}

