/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.Collection;
import java.util.List;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.repository.query.parser.Part;

public class IdQueryCreator
implements IAerospikeQueryCreator {
    private final Part.Type partType;
    private final List<Object> queryParameters;

    public IdQueryCreator(Part part, List<Object> queryParameters) {
        this.partType = part.getType();
        this.queryParameters = queryParameters;
    }

    @Override
    public void validate() {
        if (this.partType != Part.Type.SIMPLE_PROPERTY && this.partType != Part.Type.LIKE) {
            throw new UnsupportedOperationException(String.format("Unsupported type for an id query '%s', only EQ and LIKE id queries are supported", this.partType));
        }
    }

    @Override
    public Qualifier process() {
        Object value = this.queryParameters.get(0);
        if (value instanceof Collection) {
            List ids = ((Collection)value).stream().toList();
            return this.getIdInQualifier(ids);
        }
        return this.getIdEqualsQualifier(value);
    }

    private Qualifier getIdInQualifier(List<?> ids) {
        Qualifier qualifier;
        Object firstId = ids.get(0);
        if (firstId instanceof String) {
            qualifier = Qualifier.idIn((String[])ids.toArray(String[]::new));
        } else if (firstId instanceof Long) {
            qualifier = Qualifier.idIn((Long[])ids.toArray(Long[]::new));
        } else if (firstId instanceof Integer) {
            qualifier = Qualifier.idIn((Integer[])ids.toArray(Integer[]::new));
        } else if (firstId instanceof Short) {
            qualifier = Qualifier.idIn((Short[])ids.toArray(Short[]::new));
        } else if (firstId instanceof Byte) {
            qualifier = Qualifier.idIn((Byte[])ids.toArray(Byte[]::new));
        } else if (firstId instanceof Character) {
            qualifier = Qualifier.idIn((Character[])ids.toArray(Character[]::new));
        } else if (firstId instanceof byte[]) {
            qualifier = Qualifier.idIn((byte[][])ids.toArray(x$0 -> new byte[x$0][]));
        } else {
            throw new IllegalArgumentException("Invalid ID argument type: expected String, Number or byte[]");
        }
        return qualifier;
    }

    private Qualifier getIdEqualsQualifier(Object value) {
        Qualifier qualifier;
        if (value instanceof String) {
            qualifier = Qualifier.idEquals((String)value);
        } else if (value instanceof Long) {
            qualifier = Qualifier.idEquals((Long)value);
        } else if (value instanceof Integer) {
            qualifier = Qualifier.idEquals((Integer)value);
        } else if (value instanceof Short) {
            qualifier = Qualifier.idEquals((Short)value);
        } else if (value instanceof Byte) {
            qualifier = Qualifier.idEquals((Byte)value);
        } else if (value instanceof Character) {
            qualifier = Qualifier.idEquals((Character)value);
        } else if (value instanceof byte[]) {
            qualifier = Qualifier.idEquals((byte[])value);
        } else {
            throw new IllegalArgumentException("Invalid ID argument type: expected String, Number or byte[]");
        }
        return qualifier;
    }
}

