/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.List;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.aerospike.repository.query.QueryQualifierBuilder;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;

public class PojoQueryCreator
implements IAerospikeQueryCreator {
    private final Part part;
    private final AerospikePersistentProperty property;
    private final PropertyPath propertyPath;
    private final String fieldName;
    private final List<Object> queryParameters;
    private final FilterOperation filterOperation;
    private final MappingAerospikeConverter converter;
    private final boolean isNested;
    private ServerVersionSupport versionSupport;

    public PojoQueryCreator(Part part, PropertyPath propertyPath, AerospikePersistentProperty property, String fieldName, List<Object> queryParameters, FilterOperation filterOperation, MappingAerospikeConverter converter, boolean isNested, ServerVersionSupport versionSupport) {
        this.part = part;
        this.propertyPath = propertyPath;
        this.property = property;
        this.fieldName = fieldName;
        this.queryParameters = queryParameters;
        this.filterOperation = filterOperation;
        this.converter = converter;
        this.isNested = isNested;
        this.versionSupport = versionSupport;
    }

    @Override
    public void validate() {
        String queryPartDescription = String.join((CharSequence)" ", this.propertyPath.toString(), this.filterOperation.toString());
        switch (this.filterOperation) {
            case CONTAINING: 
            case NOT_CONTAINING: {
                throw new UnsupportedOperationException("Unsupported operation, please use queries like 'findByPojoField()' directly addressing the required fields");
            }
            case EQ: 
            case NOTEQ: 
            case GT: 
            case GTEQ: 
            case LT: 
            case LTEQ: {
                this.validatePojoQueryComparison(this.queryParameters, queryPartDescription);
                break;
            }
            case BETWEEN: {
                this.validatePojoQueryBetween(this.queryParameters, queryPartDescription);
                break;
            }
            case IN: 
            case NOT_IN: {
                AerospikeQueryCreatorUtils.validateQueryIn(this.queryParameters, queryPartDescription);
                break;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                AerospikeQueryCreatorUtils.validateQueryIsNull(this.queryParameters, queryPartDescription);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation: " + queryPartDescription);
            }
        }
        AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.filterOperation, this.queryParameters);
    }

    private void validatePojoQueryComparison(List<Object> queryParameters, String queryPartDescription) {
        if (queryParameters.size() != 1) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one POJO");
        }
    }

    private void validatePojoQueryBetween(List<Object> queryParameters, String queryPartDescription) {
        if (queryParameters.size() != 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two POJOs");
        }
    }

    @Override
    public Qualifier process() {
        QueryQualifierBuilder qb = new QueryQualifierBuilder();
        FilterOperation op = this.filterOperation;
        List<String> dotPath = null;
        if (this.filterOperation == FilterOperation.BETWEEN || this.filterOperation == FilterOperation.IN || this.filterOperation == FilterOperation.NOT_IN) {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
            if (this.queryParameters.size() == 2) {
                AerospikeQueryCreatorUtils.setQualifierBuilderSecondValue(qb, this.queryParameters.get(1));
            }
            if (this.isNested) {
                AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, this.property.getFieldName());
                dotPath = List.of(this.part.getProperty().toDotPath());
                op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(this.filterOperation);
            }
            Qualifier qualifier = AerospikeQueryCreatorUtils.setQualifier(qb, this.fieldName, op, this.part, dotPath, this.versionSupport);
            return qualifier;
        }
        if (this.isNested) {
            op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(this.filterOperation);
            if (this.queryParameters.isEmpty() && (this.filterOperation == FilterOperation.IS_NOT_NULL || this.filterOperation == FilterOperation.IS_NULL)) {
                AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.property.getFieldName());
            } else {
                AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
                AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, this.property.getFieldName());
            }
            dotPath = List.of(this.part.getProperty().toDotPath());
        } else if (op != FilterOperation.BETWEEN && !this.queryParameters.isEmpty()) {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
        }
        return AerospikeQueryCreatorUtils.setQualifier(qb, this.fieldName, op, this.part, dotPath, this.versionSupport);
    }
}

