/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.server.version;

import com.aerospike.client.IAerospikeClient;
import java.lang.module.ModuleDescriptor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.util.InfoCommandUtils;

public class ServerVersionSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerVersionSupport.class);
    private static final ModuleDescriptor.Version SERVER_VERSION_6_1_0_0 = ModuleDescriptor.Version.parse("6.1.0.0");
    private static final ModuleDescriptor.Version SERVER_VERSION_6_1_0_1 = ModuleDescriptor.Version.parse("6.1.0.1");
    private static final ModuleDescriptor.Version SERVER_VERSION_6_3_0_0 = ModuleDescriptor.Version.parse("6.3.0.0");
    private static final ModuleDescriptor.Version SERVER_VERSION_7_0_0_0 = ModuleDescriptor.Version.parse("7.0.0.0");
    private static final ModuleDescriptor.Version SERVER_VERSION_8_0_0_0 = ModuleDescriptor.Version.parse("8.0.0.0");
    private final IAerospikeClient client;
    private final ScheduledExecutorService executorService;
    private volatile String serverVersion;

    public ServerVersionSupport(IAerospikeClient client) {
        this.client = client;
        this.serverVersion = this.findServerVersion();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void scheduleServerVersionRefresh(long intervalSeconds) {
        this.executorService.scheduleWithFixedDelay(() -> {
            this.serverVersion = this.findServerVersion();
        }, intervalSeconds, intervalSeconds, TimeUnit.SECONDS);
    }

    private String findServerVersion() {
        String fullVersionString = InfoCommandUtils.request(this.client, this.client.getCluster().getRandomNode(), "version");
        String versionString = fullVersionString.substring(fullVersionString.lastIndexOf(32) + 1);
        if (ModuleDescriptor.Version.parse(versionString).compareTo(SERVER_VERSION_6_1_0_0) < 0) {
            throw new UnsupportedOperationException("Minimal supported Aerospike Server version is 6.1");
        }
        log.debug("Found server version {}", (Object)versionString);
        return versionString;
    }

    public boolean isSIndexCardinalitySupported() {
        return ModuleDescriptor.Version.parse(this.getServerVersion()).compareTo(SERVER_VERSION_6_1_0_0) >= 0;
    }

    public boolean isDropCreateBehaviorUpdated() {
        return ModuleDescriptor.Version.parse(this.getServerVersion()).compareTo(SERVER_VERSION_6_1_0_1) >= 0;
    }

    public boolean isFindByCDTSupported() {
        return ModuleDescriptor.Version.parse(this.getServerVersion()).compareTo(SERVER_VERSION_6_3_0_0) >= 0;
    }

    public boolean isServerVersionGtOrEq7() {
        return ModuleDescriptor.Version.parse(this.getServerVersion()).compareTo(SERVER_VERSION_7_0_0_0) >= 0;
    }

    public boolean isTxnSupported() {
        return ModuleDescriptor.Version.parse(this.getServerVersion()).compareTo(SERVER_VERSION_8_0_0_0) >= 0;
    }

    @Generated
    public String getServerVersion() {
        return this.serverVersion;
    }
}

