/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.transaction.reactive;

import com.aerospike.client.reactor.IAerospikeReactorClient;
import lombok.Generated;
import org.springframework.data.aerospike.transaction.reactive.AerospikeReactiveTransaction;
import org.springframework.data.aerospike.transaction.reactive.AerospikeReactiveTransactionResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.reactive.AbstractReactiveTransactionManager;
import org.springframework.transaction.reactive.GenericReactiveTransaction;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class AerospikeReactiveTransactionManager
extends AbstractReactiveTransactionManager {
    private final IAerospikeReactorClient client;

    public AerospikeReactiveTransactionManager(IAerospikeReactorClient client) {
        this.client = client;
    }

    private static AerospikeReactiveTransaction toAerospikeTransaction(Object transaction) {
        Assert.isInstanceOf(AerospikeReactiveTransaction.class, (Object)transaction, () -> String.format("Expected to find instance of %s but instead found %s", AerospikeReactiveTransaction.class, transaction.getClass()));
        return (AerospikeReactiveTransaction)transaction;
    }

    private static AerospikeReactiveTransaction getTransaction(GenericReactiveTransaction status) {
        Assert.isInstanceOf(AerospikeReactiveTransaction.class, (Object)status.getTransaction(), () -> String.format("Expected to find instance of %s but instead found %s", AerospikeReactiveTransaction.class, status.getTransaction().getClass()));
        return (AerospikeReactiveTransaction)status.getTransaction();
    }

    protected boolean isExistingTransaction(Object transaction) {
        return AerospikeReactiveTransactionManager.toAerospikeTransaction(transaction).hasResourceHolder();
    }

    protected Object doGetTransaction(TransactionSynchronizationManager synchronizationManager) {
        AerospikeReactiveTransactionResourceHolder resourceHolder = (AerospikeReactiveTransactionResourceHolder)((Object)synchronizationManager.getResource((Object)this.client));
        return new AerospikeReactiveTransaction(resourceHolder);
    }

    protected Mono<Void> doBegin(TransactionSynchronizationManager synchronizationManager, Object transaction, TransactionDefinition definition) {
        return Mono.defer(() -> {
            AerospikeReactiveTransaction aerospikeTransaction = AerospikeReactiveTransactionManager.toAerospikeTransaction(transaction);
            Mono<AerospikeReactiveTransactionResourceHolder> resourceHolder = this.createResourceHolder(this.client, definition);
            return resourceHolder.doOnNext(aerospikeTransaction::setResourceHolder).onErrorMap(e -> new TransactionSystemException("Could not start transaction", e)).doOnSuccess(rHolder -> {
                rHolder.setSynchronizedWithTransaction(true);
                synchronizationManager.bindResource((Object)this.client, (Object)rHolder);
            }).onErrorMap(e -> {
                if (e instanceof TransactionSystemException) {
                    return e;
                }
                return new TransactionSystemException("Could not bind transaction resource", e);
            }).then();
        });
    }

    private Mono<AerospikeReactiveTransactionResourceHolder> createResourceHolder(IAerospikeReactorClient client, TransactionDefinition definition) {
        AerospikeReactiveTransactionResourceHolder resourceHolder = new AerospikeReactiveTransactionResourceHolder(client);
        resourceHolder.setTimeoutIfNotDefault(AerospikeReactiveTransactionResourceHolder.determineTimeout(definition));
        return Mono.just((Object)((Object)resourceHolder));
    }

    protected Mono<Void> doCommit(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) {
        return Mono.fromSupplier(() -> AerospikeReactiveTransactionManager.getTransaction(status)).flatMap(AerospikeReactiveTransaction::commitTransaction).onErrorMap(e -> new TransactionSystemException("Could not commit transaction", e)).then();
    }

    protected Mono<Void> doRollback(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) {
        return Mono.fromSupplier(() -> AerospikeReactiveTransactionManager.getTransaction(status)).flatMap(AerospikeReactiveTransaction::abortTransaction).onErrorMap(e -> new TransactionSystemException("Could not abort transaction", e)).then();
    }

    protected Mono<Object> doSuspend(TransactionSynchronizationManager synchronizationManager, Object transaction) throws TransactionException {
        return Mono.fromSupplier(() -> {
            AerospikeReactiveTransaction aerospikeTransaction = AerospikeReactiveTransactionManager.toAerospikeTransaction(transaction);
            aerospikeTransaction.setResourceHolder(null);
            return synchronizationManager.unbindResource((Object)this.client);
        }).onErrorMap(e -> new TransactionSystemException("Could not suspend transaction", e));
    }

    protected Mono<Void> doResume(TransactionSynchronizationManager synchronizationManager, @Nullable Object transaction, Object suspendedResources) {
        return Mono.fromRunnable(() -> synchronizationManager.bindResource((Object)this.client, suspendedResources)).onErrorMap(e -> new TransactionSystemException("Could not resume transaction", e)).then();
    }

    protected Mono<Void> doSetRollbackOnly(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) throws TransactionException {
        return Mono.fromRunnable(() -> {
            AerospikeReactiveTransaction transaction = AerospikeReactiveTransactionManager.toAerospikeTransaction(status);
            transaction.getRequiredResourceHolder().setRollbackOnly();
        }).onErrorMap(e -> new TransactionSystemException("Could not set transaction to rollback-only", e)).then();
    }

    protected Mono<Void> doCleanupAfterCompletion(TransactionSynchronizationManager synchronizationManager, Object transaction) {
        return Mono.fromRunnable(() -> {
            AerospikeReactiveTransaction aerospikeTransaction = AerospikeReactiveTransactionManager.toAerospikeTransaction(transaction);
            synchronizationManager.unbindResource((Object)this.client);
            aerospikeTransaction.getRequiredResourceHolder().clear();
        }).onErrorMap(e -> new TransactionSystemException("Could not clean up transaction", e)).then();
    }

    @Generated
    public IAerospikeReactorClient getClient() {
        return this.client;
    }
}

