/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.transaction.sync;

import org.springframework.data.aerospike.transaction.sync.AerospikeTransactionResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;

public class AerospikeTransaction
implements SmartTransactionObject {
    @Nullable
    private AerospikeTransactionResourceHolder resourceHolder;

    AerospikeTransaction(@Nullable AerospikeTransactionResourceHolder resourceHolder) {
        this.resourceHolder = resourceHolder;
    }

    final boolean hasResourceHolder() {
        return this.resourceHolder != null;
    }

    AerospikeTransactionResourceHolder getResourceHolderOrFail() {
        Assert.state((boolean)this.hasResourceHolder(), (String)"ResourceHolder is required to be not null");
        return this.resourceHolder;
    }

    void setResourceHolder(@Nullable AerospikeTransactionResourceHolder resourceHolder) {
        this.resourceHolder = resourceHolder;
    }

    private void failIfNoTransaction() {
        if (!this.hasResourceHolder()) {
            throw new IllegalStateException("Error: expecting transaction to exist");
        }
    }

    public void commitTransaction() {
        this.failIfNoTransaction();
        this.resourceHolder.getClient().commit(this.resourceHolder.getTransaction());
    }

    public void abortTransaction() {
        this.failIfNoTransaction();
        this.resourceHolder.getClient().abort(this.resourceHolder.getTransaction());
    }

    public boolean isRollbackOnly() {
        return this.hasResourceHolder() && this.resourceHolder.isRollbackOnly();
    }

    public void flush() {
        TransactionSynchronizationUtils.triggerFlush();
    }
}

