/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.transaction.sync;

import com.aerospike.client.IAerospikeClient;
import lombok.Generated;
import org.springframework.data.aerospike.transaction.sync.AerospikeTransaction;
import org.springframework.data.aerospike.transaction.sync.AerospikeTransactionResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class AerospikeTransactionManager
extends AbstractPlatformTransactionManager {
    private final IAerospikeClient client;

    public AerospikeTransactionManager(IAerospikeClient client) {
        this.client = client;
    }

    private static AerospikeTransaction toAerospikeTransaction(Object transaction) {
        Assert.isInstanceOf(AerospikeTransaction.class, (Object)transaction, () -> String.format("Expected to find instance of %s but instead found %s", AerospikeTransaction.class, transaction.getClass()));
        return (AerospikeTransaction)transaction;
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return AerospikeTransactionManager.toAerospikeTransaction(transaction).hasResourceHolder();
    }

    private static AerospikeTransaction getTransaction(DefaultTransactionStatus status) {
        Assert.isInstanceOf(AerospikeTransaction.class, (Object)status.getTransaction(), () -> String.format("Expected to find instance of %s but instead found %s", AerospikeTransaction.class, status.getTransaction().getClass()));
        return (AerospikeTransaction)status.getTransaction();
    }

    protected Object doGetTransaction() throws TransactionException {
        AerospikeTransactionResourceHolder resourceHolder = (AerospikeTransactionResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getClient()));
        return new AerospikeTransaction(resourceHolder);
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        AerospikeTransactionResourceHolder resourceHolder;
        AerospikeTransaction aerospikeTransaction;
        try {
            aerospikeTransaction = AerospikeTransactionManager.toAerospikeTransaction(transaction);
            resourceHolder = this.createResourceHolder(definition, this.client);
        }
        catch (Exception e) {
            throw new TransactionSystemException("Could not start transaction", (Throwable)e);
        }
        aerospikeTransaction.setResourceHolder(resourceHolder);
        resourceHolder.setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.bindResource((Object)this.client, (Object)((Object)resourceHolder));
    }

    private AerospikeTransactionResourceHolder createResourceHolder(TransactionDefinition definition, IAerospikeClient client) {
        AerospikeTransactionResourceHolder resourceHolder = new AerospikeTransactionResourceHolder(client);
        resourceHolder.setTimeoutIfNotDefault(this.determineTimeout(definition));
        return resourceHolder;
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        AerospikeTransaction transaction = AerospikeTransactionManager.getTransaction(status);
        transaction.commitTransaction();
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        AerospikeTransaction transaction = AerospikeTransactionManager.getTransaction(status);
        transaction.abortTransaction();
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        try {
            AerospikeTransaction aerospikeTransaction = AerospikeTransactionManager.toAerospikeTransaction(transaction);
            aerospikeTransaction.setResourceHolder(null);
            return TransactionSynchronizationManager.unbindResource((Object)this.client);
        }
        catch (Exception e) {
            throw new TransactionSystemException("Could not suspend transaction", (Throwable)e);
        }
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) throws TransactionException {
        try {
            TransactionSynchronizationManager.bindResource((Object)this.client, (Object)suspendedResources);
        }
        catch (Exception e) {
            throw new TransactionSystemException("Could not resume transaction", (Throwable)e);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        try {
            AerospikeTransaction transaction = AerospikeTransactionManager.getTransaction(status);
            transaction.getResourceHolderOrFail().setRollbackOnly();
        }
        catch (Exception e) {
            throw new TransactionSystemException("Could not set transaction to rollback-only", (Throwable)e);
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        AerospikeTransaction aerospikeTransaction = AerospikeTransactionManager.toAerospikeTransaction(transaction);
        TransactionSynchronizationManager.unbindResource((Object)this.client);
        aerospikeTransaction.getResourceHolderOrFail().clear();
    }

    @Generated
    public IAerospikeClient getClient() {
        return this.client;
    }
}

