/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.aerospike.mapping;

import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.mapping.model.SimpleTypeHolder;

import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;

/**
 * Simple constant holder for a {@link SimpleTypeHolder} enriched with Aerospike specific simple types.
 *
 * @author Oliver Gierke
 * @author Peter Milne
 */
public abstract class AerospikeSimpleTypes {

    public static final Set<Class<?>> AUTOGENERATED_ID_TYPES;

    static {
        AUTOGENERATED_ID_TYPES = Set.of(String.class, Integer.class, Long.class);

        AEROSPIKE_SIMPLE_TYPES =
            Set.of(boolean.class, boolean[].class, long.class, long[].class, short.class, short[].class, int.class,
                int[].class, byte.class, byte[].class, float.class, float[].class, double.class, double[].class,
                char.class, char[].class, Boolean.class, Long.class, Short.class, Integer.class, Byte.class,
                Float.class, Double.class, Character.class, String.class, Date.class, Locale.class, Class.class,
                Enum.class, Byte[].class, UUID.class, AerospikeReadData.class, AerospikeWriteData.class);
    }

    private static final Set<Class<?>> AEROSPIKE_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER = new SimpleTypeHolder(AEROSPIKE_SIMPLE_TYPES, Boolean.FALSE);

    private AerospikeSimpleTypes() {
    }
}
