/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.cache;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Output;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.digest.MurmurHash3;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.springframework.data.aerospike.cache.AerospikeCacheKey;
import org.springframework.data.aerospike.cache.AerospikeCacheKeyProcessor;

public class AerospikeCacheKeyProcessorImpl
implements AerospikeCacheKeyProcessor {
    private final Kryo kryoInstance = new Kryo();

    public AerospikeCacheKeyProcessorImpl() {
        this.configureKryo();
    }

    public void configureKryo() {
        this.getKryoInstance().setRegistrationRequired(false);
        this.getKryoInstance().setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
    }

    @Override
    public AerospikeCacheKey serializeAndHash(Object key) {
        return this.calculateHash(this.serialize(key));
    }

    @Override
    public byte[] serialize(Object key) {
        ByteBufferOutput output = new ByteBufferOutput(1024);
        this.kryoInstance.writeClassAndObject((Output)output, key);
        output.flush();
        return output.toBytes();
    }

    @Override
    public AerospikeCacheKey calculateHash(byte[] data) {
        return AerospikeCacheKey.of(Arrays.toString(MurmurHash3.hash128((byte[])data)));
    }

    @Generated
    public Kryo getKryoInstance() {
        return this.kryoInstance;
    }
}

