/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.cache;

import com.aerospike.client.IAerospikeClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.data.aerospike.cache.AerospikeCache;
import org.springframework.data.aerospike.cache.AerospikeCacheConfiguration;
import org.springframework.data.aerospike.cache.AerospikeCacheKeyProcessor;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.util.Assert;

public class AerospikeCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final IAerospikeClient aerospikeClient;
    private final AerospikeConverter aerospikeConverter;
    private final AerospikeCacheConfiguration defaultCacheConfiguration;
    private final Map<String, AerospikeCacheConfiguration> initialPerCacheConfiguration;
    private final AerospikeCacheKeyProcessor cacheKeyProcessor;

    public AerospikeCacheManager(IAerospikeClient aerospikeClient, AerospikeConverter aerospikeConverter, AerospikeCacheConfiguration defaultCacheConfiguration, AerospikeCacheKeyProcessor cacheKeyProcessor) {
        this(aerospikeClient, aerospikeConverter, defaultCacheConfiguration, new LinkedHashMap<String, AerospikeCacheConfiguration>(), cacheKeyProcessor);
    }

    public AerospikeCacheManager(IAerospikeClient aerospikeClient, AerospikeConverter aerospikeConverter, AerospikeCacheConfiguration defaultCacheConfiguration, Map<String, AerospikeCacheConfiguration> initialPerCacheConfiguration, AerospikeCacheKeyProcessor cacheKeyProcessor) {
        Assert.notNull((Object)aerospikeClient, (String)"The aerospike client must not be null");
        Assert.notNull((Object)aerospikeConverter, (String)"The aerospike converter must not be null");
        Assert.notNull((Object)defaultCacheConfiguration, (String)"The default cache configuration must not be null");
        Assert.notNull(initialPerCacheConfiguration, (String)"The initial per cache configuration must not be null");
        this.aerospikeClient = aerospikeClient;
        this.aerospikeConverter = aerospikeConverter;
        this.defaultCacheConfiguration = defaultCacheConfiguration;
        this.initialPerCacheConfiguration = initialPerCacheConfiguration;
        this.cacheKeyProcessor = cacheKeyProcessor;
    }

    protected Collection<? extends Cache> loadCaches() {
        ArrayList<AerospikeCache> caches = new ArrayList<AerospikeCache>();
        for (Map.Entry<String, AerospikeCacheConfiguration> entry : this.initialPerCacheConfiguration.entrySet()) {
            caches.add(this.createCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    protected Cache getMissingCache(String name) {
        return this.createCache(name);
    }

    protected Cache decorateCache(Cache cache) {
        if (this.isCacheAlreadyDecorated(cache)) {
            return cache;
        }
        return super.decorateCache(cache);
    }

    private AerospikeCache createCache(String name) {
        return new AerospikeCache(name, this.aerospikeClient, this.aerospikeConverter, this.defaultCacheConfiguration, this.cacheKeyProcessor);
    }

    private AerospikeCache createCache(String name, AerospikeCacheConfiguration cacheConfiguration) {
        return new AerospikeCache(name, this.aerospikeClient, this.aerospikeConverter, cacheConfiguration, this.cacheKeyProcessor);
    }

    private boolean isCacheAlreadyDecorated(Cache cache) {
        return this.isTransactionAware() && cache instanceof TransactionAwareCacheDecorator;
    }
}

