/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

import com.aerospike.client.IAerospikeClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.aerospike.config.AerospikeDataConfigurationSupport;
import org.springframework.data.aerospike.config.AerospikeSettings;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.index.AerospikePersistenceEntityIndexCreator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.QueryContextBuilder;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.cache.IndexInfoParser;
import org.springframework.data.aerospike.query.cache.IndexRefresher;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.cache.InternalIndexOperations;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;

@Configuration
public abstract class AbstractAerospikeDataConfiguration
extends AerospikeDataConfigurationSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAerospikeDataConfiguration.class);

    @Bean(name={"aerospikeTemplate"})
    public AerospikeTemplate aerospikeTemplate(IAerospikeClient aerospikeClient, MappingAerospikeConverter mappingAerospikeConverter, AerospikeMappingContext aerospikeMappingContext, AerospikeExceptionTranslator aerospikeExceptionTranslator, QueryEngine queryEngine, IndexRefresher indexRefresher, ServerVersionSupport serverVersionSupport, AerospikeSettings settings) {
        return new AerospikeTemplate(aerospikeClient, settings.getDataSettings().getNamespace(), mappingAerospikeConverter, aerospikeMappingContext, aerospikeExceptionTranslator, queryEngine, indexRefresher, serverVersionSupport);
    }

    @Bean(name={"aerospikeQueryEngine"})
    public QueryEngine queryEngine(IAerospikeClient aerospikeClient, QueryContextBuilder QueryContextBuilder2, FilterExpressionsBuilder filterExpressionsBuilder, AerospikeSettings settings) {
        QueryEngine queryEngine = new QueryEngine(aerospikeClient, QueryContextBuilder2, filterExpressionsBuilder, settings.getDataSettings());
        boolean scansEnabled = settings.getDataSettings().isScansEnabled();
        log.info("AerospikeDataSettings.scansEnabled: {}", (Object)scansEnabled);
        queryEngine.setScansEnabled(scansEnabled);
        long queryMaxRecords = settings.getDataSettings().getQueryMaxRecords();
        log.info("AerospikeDataSettings.queryMaxRecords: {}", (Object)queryMaxRecords);
        queryEngine.setQueryMaxRecords(queryMaxRecords);
        if (!settings.getDataSettings().isWriteSortedMaps()) {
            log.info("AerospikeDataSettings.writeSortedMaps is set to false, Maps and POJOs will be written as unsorted Maps (degrades performance of Map-related operations, does not allow comparing Maps)");
        }
        return queryEngine;
    }

    @Bean(name={"aerospikePersistenceEntityIndexCreator"})
    public AerospikePersistenceEntityIndexCreator aerospikePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> aerospikeMappingContext, AerospikeIndexResolver aerospikeIndexResolver, ObjectProvider<AerospikeTemplate> template, AerospikeSettings settings) {
        boolean indexesOnStartup = settings.getDataSettings().isCreateIndexesOnStartup();
        log.info("AerospikeDataSettings.indexesOnStartup: {}", (Object)indexesOnStartup);
        return new AerospikePersistenceEntityIndexCreator(aerospikeMappingContext, indexesOnStartup, aerospikeIndexResolver, template);
    }

    @Bean(name={"aerospikeIndexRefresher"})
    public IndexRefresher indexRefresher(IAerospikeClient aerospikeClient, IndexesCacheUpdater indexesCacheUpdater, ServerVersionSupport serverVersionSupport, AerospikeSettings settings) {
        IndexRefresher refresher = new IndexRefresher(aerospikeClient, aerospikeClient.getInfoPolicyDefault(), new InternalIndexOperations(new IndexInfoParser()), indexesCacheUpdater, serverVersionSupport);
        refresher.refreshIndexes();
        int refreshFrequency = settings.getDataSettings().getIndexCacheRefreshSeconds();
        this.processCacheRefreshFrequency(refreshFrequency, refresher);
        log.info("AerospikeDataSettings.indexCacheRefreshSeconds: {}", (Object)refreshFrequency);
        return refresher;
    }

    private void processCacheRefreshFrequency(int indexCacheRefreshSeconds, IndexRefresher indexRefresher) {
        if (indexCacheRefreshSeconds <= 0) {
            log.info("Periodic index cache refreshing is not scheduled, interval ({}) is <= 0", (Object)indexCacheRefreshSeconds);
        } else {
            indexRefresher.scheduleRefreshIndexes(indexCacheRefreshSeconds);
        }
    }
}

