/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.NettyEventLoops;
import com.aerospike.client.policy.ClientPolicy;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.aerospike.cache.AerospikeCacheKeyProcessor;
import org.springframework.data.aerospike.cache.AerospikeCacheKeyProcessorImpl;
import org.springframework.data.aerospike.config.AerospikeConnectionSettings;
import org.springframework.data.aerospike.config.AerospikeDataSettings;
import org.springframework.data.aerospike.config.AerospikeSettings;
import org.springframework.data.aerospike.convert.AerospikeCustomConversions;
import org.springframework.data.aerospike.convert.AerospikeCustomConverters;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.DefaultAerospikeExceptionTranslator;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikeSimpleTypes;
import org.springframework.data.aerospike.mapping.Document;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.QueryContextBuilder;
import org.springframework.data.aerospike.query.cache.IndexesCache;
import org.springframework.data.aerospike.query.cache.IndexesCacheHolder;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AerospikeDataConfigurationSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikeDataConfigurationSupport.class);
    public static final String CONFIG_PREFIX = "spring";
    public static final String CONFIG_PREFIX_DATA = "spring.data.aerospike";
    public static final String CONFIG_PREFIX_CONNECTION = "spring.aerospike";

    @Bean(name={"aerospikeQueryContextBuilder"})
    public QueryContextBuilder queryContextBuilder(IndexesCache indexesCache) {
        return new QueryContextBuilder(indexesCache);
    }

    @Bean(name={"aerospikeIndexCache"})
    public IndexesCacheHolder indexCache() {
        return new IndexesCacheHolder();
    }

    @Bean(name={"aerospikeCacheKeyProcessor"})
    public AerospikeCacheKeyProcessor cacheKeyProcessor() {
        return new AerospikeCacheKeyProcessorImpl();
    }

    @Bean(name={"mappingAerospikeConverter"})
    public MappingAerospikeConverter mappingAerospikeConverter(AerospikeMappingContext aerospikeMappingContext, AerospikeTypeAliasAccessor aerospikeTypeAliasAccessor, AerospikeCustomConversions customConversions, AerospikeSettings settings) {
        return new MappingAerospikeConverter(aerospikeMappingContext, customConversions, aerospikeTypeAliasAccessor, settings.getDataSettings());
    }

    @Bean(name={"aerospikeTypeAliasAccessor"})
    public AerospikeTypeAliasAccessor aerospikeTypeAliasAccessor(AerospikeDataSettings dataSettings) {
        return new AerospikeTypeAliasAccessor(dataSettings.getClassKey());
    }

    @Bean
    public AerospikeCustomConversions customConversions(@Autowired(required=false) AerospikeCustomConverters converters) {
        ArrayList<Object> aggregatedCustomConverters = new ArrayList<Object>(this.customConverters());
        if (converters != null) {
            aggregatedCustomConverters.addAll(converters.getCustomConverters());
        }
        return new AerospikeCustomConversions(aggregatedCustomConverters);
    }

    protected List<Object> customConverters() {
        return Collections.emptyList();
    }

    @Bean(name={"aerospikeMappingContext"})
    public AerospikeMappingContext aerospikeMappingContext(AerospikeDataSettings dataSettings) throws AerospikeException {
        AerospikeMappingContext context = new AerospikeMappingContext();
        try {
            context.setInitialEntitySet(this.getInitialEntitySet());
        }
        catch (ClassNotFoundException e) {
            throw new AerospikeException("Cannot set initialEntitySet in AerospikeMappingContext", (Throwable)e);
        }
        context.setSimpleTypeHolder(AerospikeSimpleTypes.HOLDER);
        if (dataSettings.getFieldNamingStrategy() != null) {
            try {
                context.setFieldNamingStrategy((FieldNamingStrategy)BeanUtils.instantiateClass(Class.forName(dataSettings.getFieldNamingStrategy())));
            }
            catch (BeanInstantiationException e) {
                throw new AerospikeException("Cannot set fieldNamingStrategy in AerospikeMappingContext", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new AerospikeException("Cannot use the given fieldNamingStrategy: class not found", (Throwable)e);
            }
        } else {
            context.setFieldNamingStrategy(this.fieldNamingStrategy());
        }
        return context;
    }

    @Bean(name={"aerospikeExceptionTranslator"})
    public AerospikeExceptionTranslator aerospikeExceptionTranslator() {
        return new DefaultAerospikeExceptionTranslator();
    }

    @Bean(name={"aerospikeClient"}, destroyMethod="close")
    public IAerospikeClient aerospikeClient(AerospikeSettings settings) {
        return new AerospikeClient(this.getClientPolicy(), settings.getConnectionSettings().getHostsArray());
    }

    protected int getDefaultPort() {
        return 3000;
    }

    @Bean(name={"filterExpressionsBuilder"})
    public FilterExpressionsBuilder filterExpressionsBuilder() {
        return new FilterExpressionsBuilder();
    }

    @Bean
    public EventLoops eventLoops() {
        int nThreads = Math.max(2, Runtime.getRuntime().availableProcessors() * 2);
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        Object eventLoopGroup = os.contains("nux") && Epoll.isAvailable() ? new EpollEventLoopGroup(nThreads) : (os.contains("mac") && KQueue.isAvailable() ? new KQueueEventLoopGroup(nThreads) : new NioEventLoopGroup(nThreads));
        EventPolicy eventPolicy = new EventPolicy();
        eventPolicy.maxCommandsInProcess = 40;
        eventPolicy.maxCommandsInQueue = 1024;
        return new NettyEventLoops(eventPolicy, (EventLoopGroup)eventLoopGroup);
    }

    @Bean(name={"aerospikeIndexResolver"})
    public AerospikeIndexResolver aerospikeIndexResolver() {
        return new AerospikeIndexResolver();
    }

    @Bean(name={"aerospikeServerVersionSupport"})
    public ServerVersionSupport serverVersionSupport(IAerospikeClient aerospikeClient, AerospikeSettings settings) {
        ServerVersionSupport serverVersionSupport = new ServerVersionSupport(aerospikeClient);
        int serverVersionRefreshFrequency = settings.getDataSettings().getServerVersionRefreshSeconds();
        this.processServerVersionRefreshFrequency(serverVersionRefreshFrequency, serverVersionSupport);
        return serverVersionSupport;
    }

    private void processServerVersionRefreshFrequency(int serverVersionRefreshSeconds, ServerVersionSupport serverVersionSupport) {
        if (serverVersionRefreshSeconds <= 0) {
            log.info("Periodic server version refreshing is not scheduled, interval ({}) is <= 0", (Object)serverVersionRefreshSeconds);
        } else {
            serverVersionSupport.scheduleServerVersionRefresh(serverVersionRefreshSeconds);
        }
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        String basePackage = this.getMappingBasePackage();
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)AerospikeDataConfigurationSupport.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }

    protected String getMappingBasePackage() {
        return this.getClass().getPackage().getName();
    }

    protected FieldNamingStrategy fieldNamingStrategy() {
        return PropertyNameFieldNamingStrategy.INSTANCE;
    }

    protected Collection<Host> getHosts() {
        return null;
    }

    protected String nameSpace() {
        return null;
    }

    protected void configureDataSettings(AerospikeDataSettings aerospikeDataSettings) {
    }

    protected ClientPolicy getClientPolicy() {
        boolean sendKey;
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.failIfNotConnected = true;
        clientPolicy.timeout = 10000;
        clientPolicy.readPolicyDefault.sendKey = sendKey = true;
        clientPolicy.writePolicyDefault.sendKey = sendKey;
        clientPolicy.batchPolicyDefault.sendKey = sendKey;
        clientPolicy.batchWritePolicyDefault.sendKey = sendKey;
        clientPolicy.queryPolicyDefault.sendKey = sendKey;
        clientPolicy.scanPolicyDefault.sendKey = sendKey;
        clientPolicy.eventLoops = this.eventLoops();
        return clientPolicy;
    }

    @Bean
    public AerospikeDataSettings readAerospikeDataSettings(Environment environment) {
        return new AerospikeDataSettings(environment);
    }

    @Bean
    public AerospikeConnectionSettings readAerospikeSettings(Environment environment) {
        return new AerospikeConnectionSettings(environment);
    }

    @Bean
    protected AerospikeSettings aerospikeSettings(AerospikeDataSettings dataSettings, AerospikeConnectionSettings connectionSettings) {
        this.configureDataSettings(dataSettings);
        Collection<Host> hosts = this.getHosts();
        if (hosts != null) {
            connectionSettings.setHostsArray(hosts.toArray(new Host[0]));
        } else if (StringUtils.hasText((String)connectionSettings.getHosts())) {
            connectionSettings.setHostsArray(Host.parseHosts((String)connectionSettings.getHosts(), (int)this.getDefaultPort()));
        } else {
            throw new IllegalStateException("No hosts found, please set hosts parameter in application.properties or override getHosts() method");
        }
        String namespace = this.nameSpace();
        if (namespace != null) {
            dataSettings.setNamespace(namespace);
        }
        return new AerospikeSettings(connectionSettings, dataSettings);
    }
}

