/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.BatchUtils;
import org.springframework.data.aerospike.core.ExceptionUtils;
import org.springframework.data.aerospike.core.MappingUtils;
import org.springframework.data.aerospike.core.PolicyUtils;
import org.springframework.data.aerospike.core.TemplateContext;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.core.ValidationUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.index.IndexesCacheRefresher;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.cache.IndexRefresher;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.aerospike.util.InfoCommandUtils;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AerospikeTemplate
extends BaseAerospikeTemplate
implements AerospikeOperations,
IndexesCacheRefresher<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikeTemplate.class);
    private static final Pattern INDEX_EXISTS_REGEX_PATTERN = Pattern.compile("^FAIL:(-?\\d+).*$");
    private final IAerospikeClient client;
    private final QueryEngine queryEngine;
    private final IndexRefresher indexRefresher;
    private final TemplateContext templateContext;

    public AerospikeTemplate(IAerospikeClient client, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, QueryEngine queryEngine, IndexRefresher indexRefresher, ServerVersionSupport serverVersionSupport) {
        super(namespace, converter, mappingContext, exceptionTranslator, client.copyWritePolicyDefault(), serverVersionSupport);
        this.client = client;
        this.queryEngine = queryEngine;
        this.indexRefresher = indexRefresher;
        this.templateContext = TemplateContext.builder().client(client).converter(converter).namespace(namespace).mappingContext((MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty>)mappingContext).exceptionTranslator(exceptionTranslator).writePolicyDefault(this.writePolicyDefault).batchWritePolicyDefault(this.batchWritePolicyDefault).queryEngine(queryEngine).build();
    }

    @Override
    public IAerospikeClient getAerospikeClient() {
        return this.client;
    }

    @Override
    public long getQueryMaxRecords() {
        return this.queryEngine.getQueryMaxRecords();
    }

    @Override
    public Integer refreshIndexesCache() {
        return this.indexRefresher.refreshIndexes();
    }

    @Override
    public <T> void save(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.save(document, this.getSetName((Object)document));
    }

    @Override
    public <T> void save(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = PolicyUtils.expectGenerationCasAwarePolicy(data, this.templateContext.writePolicyDefault);
            TemplateUtils.doPersistWithVersionAndHandleCasError(document, data, writePolicy, true, BaseAerospikeTemplate.OperationType.SAVE_OPERATION, this.templateContext);
        } else {
            WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE, this.templateContext.writePolicyDefault);
            Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
            TemplateUtils.doPersistAndHandleError(data, writePolicy, operations, this.templateContext);
        }
    }

    @Override
    public <T> void saveAll(Iterable<T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for saving");
            return;
        }
        this.saveAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> void saveAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for saving");
            return;
        }
        BatchUtils.applyBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.SAVE_OPERATION, this.templateContext);
    }

    @Override
    public <T> void insert(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.insert(document, this.getSetName((Object)document));
    }

    @Override
    public <T> void insert(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.CREATE_ONLY, this.templateContext.writePolicyDefault);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            TemplateUtils.doPersistWithVersionAndHandleError(document, data, writePolicy, this.templateContext);
        } else {
            Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put);
            TemplateUtils.doPersistAndHandleError(data, writePolicy, operations, this.templateContext);
        }
    }

    @Override
    public <T> void insertAll(Iterable<T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for inserting");
            return;
        }
        this.insertAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> void insertAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for inserting");
            return;
        }
        BatchUtils.applyBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.INSERT_OPERATION, this.templateContext);
    }

    @Override
    public <T> void persist(T document, WritePolicy writePolicy) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)writePolicy, (String)"Policy must not be null!");
        this.persist(document, writePolicy, this.getSetName((Object)document));
    }

    @Override
    public <T> void persist(T document, WritePolicy writePolicy, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)writePolicy, (String)"Policy must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put);
        TemplateUtils.doPersistAndHandleError(data, new WritePolicy(writePolicy), operations, this.templateContext);
    }

    @Override
    public <T> void update(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.update(document, this.getSetName((Object)document));
    }

    @Override
    public <T> void update(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = PolicyUtils.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
            TemplateUtils.doPersistWithVersionAndHandleCasError(document, data, writePolicy, true, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION, this.templateContext);
        } else {
            WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
            Operation[] operations = (Operation[])Stream.concat(Stream.of(Operation.delete()), data.getBins().stream().map(Operation::put)).toArray(Operation[]::new);
            TemplateUtils.doPersistAndHandleError(data, writePolicy, operations, this.templateContext);
        }
    }

    @Override
    public <T> void update(T document, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.update(document, this.getSetName((Object)document), fields);
    }

    @Override
    public <T> void update(T document, String setName, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeDataWithSpecificFields(document, setName, fields, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = PolicyUtils.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
            TemplateUtils.doPersistWithVersionAndHandleCasError(document, data, writePolicy, false, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION, this.templateContext);
        } else {
            WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
            Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put);
            TemplateUtils.doPersistAndHandleError(data, writePolicy, operations, this.templateContext);
        }
    }

    @Override
    public <T> void updateAll(Iterable<T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for updating");
            return;
        }
        this.updateAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> void updateAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for updating");
            return;
        }
        BatchUtils.applyBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION, this.templateContext);
    }

    @Override
    public <T> boolean delete(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        return this.delete(document, this.getSetName((Object)document));
    }

    @Override
    public <T> boolean delete(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            return TemplateUtils.doDeleteWithVersionAndHandleCasError(data, this.templateContext);
        }
        return TemplateUtils.doDeleteIgnoreVersionAndTranslateError(data, this.templateContext);
    }

    @Override
    public <T> boolean deleteById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteById(id, this.getSetName((Class)entityClass));
    }

    @Override
    public boolean deleteById(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            Key key = TemplateUtils.getKey(id, setName, this.templateContext);
            WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)PolicyUtils.ignoreGenerationPolicy(this.templateContext.writePolicyDefault));
            return this.client.delete(writePolicy, key);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> void delete(Query query, Class<T> entityClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        List<Object> findQueryResults = this.find(query, entityClass, setName).filter(Objects::nonNull).toList();
        if (!findQueryResults.isEmpty()) {
            this.deleteAll(findQueryResults);
        }
    }

    @Override
    public <T> void delete(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.delete(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> void deleteByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        this.deleteByIdsUsingQuery(ids, entityClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T> void deleteByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, String setName, @Nullable Query query) {
        List findQueryResults = this.findByIdsUsingQuery(ids, entityClass, entityClass, setName, query).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        if (!findQueryResults.isEmpty()) {
            this.deleteAll(findQueryResults);
        }
    }

    @Override
    public <T> void deleteAll(Iterable<? extends T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for deleting");
            return;
        }
        String setName = this.getSetName((Object)documents.iterator().next());
        int batchSize = this.converter.getAerospikeDataSettings().getBatchWriteSize();
        ArrayList<T> documentsList = new ArrayList<T>();
        for (T document : documents) {
            if (BatchUtils.batchSizeMatch(batchSize, documentsList.size())) {
                this.deleteAll(documentsList, setName);
                documentsList.clear();
            }
            documentsList.add(document);
        }
        if (!documentsList.isEmpty()) {
            this.deleteAll(documentsList, setName);
        }
    }

    @Override
    public <T> void deleteAll(Iterable<? extends T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for deleting");
            return;
        }
        BatchUtils.applyBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.DELETE_OPERATION, this.templateContext);
    }

    @Override
    @Deprecated
    public <T> void deleteExistingByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteExistingByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> void deleteByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    @Deprecated
    public void deleteExistingByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return;
        }
        BatchUtils.deleteByIds(ids, setName, false, this.templateContext);
    }

    @Override
    public void deleteByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return;
        }
        BatchUtils.deleteByIds(ids, setName, true, this.templateContext);
    }

    @Override
    public void deleteByIds(GroupedKeys groupedKeys) {
        if (ValidationUtils.areInvalidGroupedKeys(groupedKeys)) {
            return;
        }
        BatchUtils.deleteGroupedEntitiesByGroupedKeys(groupedKeys, this.templateContext);
    }

    @Override
    public <T> void deleteAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteAll(entityClass, null);
    }

    @Override
    public <T> void deleteAll(Class<T> entityClass, Instant beforeLastUpdate) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteAll(this.getSetName((Class)entityClass), beforeLastUpdate);
    }

    @Override
    public void deleteAll(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.deleteAll(setName, null);
    }

    @Override
    public void deleteAll(String setName, Instant beforeLastUpdate) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Calendar beforeLastUpdateCalendar = MappingUtils.convertToCalendar(beforeLastUpdate);
        try {
            this.client.truncate(null, this.getNamespace(), setName, beforeLastUpdateCalendar);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T add(T document, Map<String, Long> values) {
        return this.add(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> T add(T document, String setName, Map<String, Long> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
            Operation[] ops = TemplateUtils.operations(values, Operation.Type.ADD, Operation.get());
            WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
            writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)writePolicy);
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), ops);
            return MappingUtils.mapToEntity(data.getKey(), MappingUtils.getEntityClass(document), aeroRecord, this.templateContext.converter);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T add(T document, String binName, long value) {
        return this.add(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> T add(T document, String setName, String binName, long value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
            WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
            writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)writePolicy);
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get()});
            return MappingUtils.mapToEntity(data.getKey(), MappingUtils.getEntityClass(document), aeroRecord, this.templateContext.converter);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T append(T document, Map<String, String> values) {
        return this.append(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> T append(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
            Operation[] ops = TemplateUtils.operations(values, Operation.Type.APPEND, Operation.get());
            WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)this.client.copyWritePolicyDefault());
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), ops);
            return MappingUtils.mapToEntity(data.getKey(), MappingUtils.getEntityClass(document), aeroRecord, this.templateContext.converter);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T append(T document, String binName, String value) {
        return this.append(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> T append(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
            WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)this.client.copyWritePolicyDefault());
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)});
            return MappingUtils.mapToEntity(data.getKey(), MappingUtils.getEntityClass(document), aeroRecord, this.templateContext.converter);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T prepend(T document, String fieldName, String value) {
        return this.prepend(document, this.getSetName((Object)document), fieldName, value);
    }

    @Override
    public <T> T prepend(T document, String setName, String fieldName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)fieldName, (String)"Field name must not be null!");
        try {
            AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
            WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)this.client.copyWritePolicyDefault());
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.prepend((Bin)new Bin(fieldName, value)), Operation.get((String)fieldName)});
            return MappingUtils.mapToEntity(data.getKey(), MappingUtils.getEntityClass(document), aeroRecord, this.templateContext.converter);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T prepend(T document, Map<String, String> values) {
        return this.prepend(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> T prepend(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
            Operation[] ops = TemplateUtils.operations(values, Operation.Type.PREPEND, Operation.get());
            WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)this.client.copyWritePolicyDefault());
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), ops);
            return MappingUtils.mapToEntity(data.getKey(), MappingUtils.getEntityClass(document), aeroRecord, this.templateContext.converter);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        try {
            return supplier.get();
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findById(id, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return (T)this.findById(id, entityClass, null, setName);
    }

    @Override
    public <T, S> S findById(Object id, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findById(id, entityClass, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> S findById(Object id, Class<T> entityClass, Class<S> targetClass, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return (S)this.findByIdUsingQuery(id, entityClass, targetClass, setName, null);
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        return this.findByIds(ids, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> entityClass, String setName) {
        return this.findByIds(ids, entityClass, null, setName);
    }

    @Override
    public <T, S> List<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass) {
        return this.findByIds(ids, entityClass, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> List<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass, String setName) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findByIdsUsingQueryWithPostProcessing(ids, entityClass, targetClass, setName, null, this.templateContext).filter(Objects::nonNull).toList();
    }

    @Override
    public GroupedEntities findByIds(GroupedKeys groupedKeys) {
        if (ValidationUtils.areInvalidGroupedKeys(groupedKeys)) {
            return GroupedEntities.builder().build();
        }
        return BatchUtils.findGroupedEntitiesByGroupedKeys(groupedKeys, this.templateContext);
    }

    @Override
    public <T, S> Object findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, Query query) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIdUsingQuery(id, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Object findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, String setName, @Nullable Query query) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = TemplateUtils.getKey(id, setName, this.templateContext);
            if (targetClass != null && targetClass != entityClass) {
                return TemplateUtils.getRecordMapToTargetClass(entity, key, targetClass, query, this.templateContext);
            }
            return MappingUtils.mapToEntity(key, entityClass, TemplateUtils.getRecord(entity, key, query, this.templateContext), this.templateContext.converter);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T, S> Stream<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, Query query) {
        return this.findByIdsUsingQuery(ids, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Stream<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, String setName, Query query) {
        return TemplateUtils.findByIdsUsingQueryWithPostProcessing(ids, entityClass, targetClass, setName, query, this.templateContext);
    }

    public <T, S> Stream<?> findByIdsWithoutPostProcessing(Collection<?> ids, Class<T> entityClass, @Nullable Class<S> targetClass, @Nullable Query query) {
        return BatchUtils.findByIdsWithoutPostProcessing(ids, entityClass, targetClass, this.getSetName((Class)entityClass), query, this.templateContext);
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> find(Query query, Class<T> entityClass, Class<S> targetClass) {
        return this.find(query, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> targetClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findWithPostProcessing(setName, targetClass, query, this.templateContext);
    }

    @Override
    public <T> Stream<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.findAll(entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> findAll(Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> findAll(Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.find(targetClass, setName, this.templateContext);
    }

    @Override
    public <T> Stream<T> findAll(Sort sort, long offset, long limit, Class<T> entityClass) {
        return this.findAll(sort, offset, limit, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> findAll(Sort sort, long offset, long limit, Class<T> entityClass, Class<S> targetClass) {
        return this.findAll(sort, offset, limit, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> findAll(Sort sort, long offset, long limit, Class<T> targetClass, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return TemplateUtils.findWithPostProcessing(setName, targetClass, sort, offset, limit, this.templateContext);
    }

    @Override
    public <T, S> Stream<S> findUsingQueryWithoutPostProcessing(Class<T> entityClass, Class<S> targetClass, Query query) {
        ValidationUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        return TemplateUtils.findUsingQueryWithDistinctPredicate(this.getSetName((Class)entityClass), targetClass, TemplateUtils.getDistinctPredicate(query), query, this.templateContext);
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        return this.findInRange(offset, limit, sort, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> findInRange(long offset, long limit, Sort sort, Class<T> entityClass, Class<S> targetClass) {
        return this.findInRange(offset, limit, sort, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findWithPostProcessing(setName, targetClass, sort, offset, limit, this.templateContext);
    }

    @Override
    public <T> boolean exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(id, this.getSetName((Class)entityClass));
    }

    @Override
    public boolean exists(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            Key key = TemplateUtils.getKey(id, setName, this.templateContext);
            WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(this.client, (Policy)this.client.copyWritePolicyDefault());
            Record aeroRecord = this.client.operate(writePolicy, key, new Operation[]{Operation.getHeader()});
            return aeroRecord != null;
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> boolean exists(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(query, this.getSetName((Class)entityClass));
    }

    @Override
    public boolean exists(Query query, String setName) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findExistingKeyRecordsUsingQuery(setName, query, this.templateContext).findAny().isPresent();
    }

    @Override
    public <T> boolean existsByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.existsByIdsUsingQuery(ids, this.getSetName((Class)entityClass), query);
    }

    @Override
    public boolean existsByIdsUsingQuery(Collection<?> ids, String setName, @Nullable Query query) {
        long findQueryResults = BatchUtils.findByIdsUsingQueryWithoutMapping(ids, setName, query, this.templateContext).filter(Objects::nonNull).count();
        return findQueryResults > 0L;
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.count(this.getSetName((Class)entityClass));
    }

    @Override
    public long count(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            Node[] nodes = this.client.getNodes();
            int replicationFactor = Utils.getReplicationFactor(this.client, nodes, this.namespace);
            long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(this.client, node, this.namespace, setName)).sum();
            return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> long count(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.count(query, this.getSetName((Class)entityClass));
    }

    @Override
    public long count(Query query, String setName) {
        return TemplateUtils.findExistingKeyRecordsUsingQuery(setName, query, this.templateContext).count();
    }

    @Override
    public <T> long countByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.countByIdsUsingQuery(ids, this.getSetName((Class)entityClass), query);
    }

    @Override
    public long countByIdsUsingQuery(Collection<?> ids, String setName, @Nullable Query query) {
        return BatchUtils.findByIdsUsingQueryWithoutMapping(ids, setName, query, this.templateContext).filter(Objects::nonNull).count();
    }

    @Override
    public <T> ResultSet aggregate(Filter filter, Class<T> entityClass, String module, String function, List<Value> arguments) {
        return this.aggregate(filter, this.getSetName((Class)entityClass), module, function, arguments);
    }

    @Override
    public ResultSet aggregate(Filter filter, String setName, String module, String function, List<Value> arguments) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Statement statement = new Statement();
        if (filter != null) {
            statement.setFilter(filter);
        }
        statement.setSetName(setName);
        statement.setNamespace(this.namespace);
        ResultSet resultSet = arguments != null && !arguments.isEmpty() ? this.client.queryAggregate(null, statement, module, function, arguments.toArray(new Value[0])) : this.client.queryAggregate(null, statement);
        return resultSet;
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.createIndex(entityClass, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.createIndex(this.getSetName((Class)entityClass), indexName, binName, indexType, indexCollectionType, ctx);
    }

    @Override
    public void createIndex(String setName, String indexName, String binName, IndexType indexType) {
        this.createIndex(setName, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public void createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        this.createIndex(setName, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public void createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull((Object)setName, (String)"Set name type must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        Assert.notNull((Object)ctx, (String)"Ctx must not be null!");
        try {
            IndexTask task = this.client.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType, ctx);
            if (task != null) {
                task.waitTillComplete();
            }
            this.refreshIndexesCache();
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> void deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteIndex(this.getSetName((Class)entityClass), indexName);
    }

    @Override
    public void deleteIndex(String setName, String indexName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            IndexTask task = this.client.dropIndex(null, this.namespace, setName, indexName);
            if (task != null) {
                task.waitTillComplete();
            }
            this.refreshIndexesCache();
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public boolean indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            Node[] nodes;
            for (Node node : nodes = this.client.getNodes()) {
                if (!node.isActive()) continue;
                String response = InfoCommandUtils.request(this.client, node, "sindex-exists:ns=" + this.namespace + ";indexname=" + indexName);
                if (response == null) {
                    throw new AerospikeException("Null node response");
                }
                if (response.equalsIgnoreCase("true")) {
                    return true;
                }
                if (response.equalsIgnoreCase("false")) {
                    return false;
                }
                Matcher matcher = INDEX_EXISTS_REGEX_PATTERN.matcher(response);
                if (matcher.matches()) {
                    int reason;
                    try {
                        reason = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        throw new AerospikeException("Unexpected node response, unable to parse ResultCode: " + response);
                    }
                    if (reason == 20) continue;
                    throw new AerospikeException(reason);
                }
                throw new AerospikeException("Unexpected node response: " + response);
            }
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
        return false;
    }
}

