/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.Log;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.WritePolicy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

abstract class BaseAerospikeTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAerospikeTemplate.class);
    protected final MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext;
    protected final MappingAerospikeConverter converter;
    protected final String namespace;
    protected final AerospikeExceptionTranslator exceptionTranslator;
    protected final WritePolicy writePolicyDefault;
    protected final BatchWritePolicy batchWritePolicyDefault;
    protected final ServerVersionSupport serverVersionSupport;

    BaseAerospikeTemplate(String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, WritePolicy writePolicyDefault, ServerVersionSupport serverVersionSupport) {
        Assert.notNull((Object)writePolicyDefault, (String)"Write policy must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        this.converter = converter;
        this.exceptionTranslator = exceptionTranslator;
        this.namespace = namespace;
        this.mappingContext = mappingContext;
        this.writePolicyDefault = writePolicyDefault;
        this.batchWritePolicyDefault = this.getFromWritePolicy(writePolicyDefault);
        this.serverVersionSupport = serverVersionSupport;
        this.loggerSetup();
    }

    private BatchWritePolicy getFromWritePolicy(WritePolicy writePolicy) {
        BatchWritePolicy batchWritePolicy = new BatchWritePolicy();
        batchWritePolicy.commitLevel = writePolicy.commitLevel;
        batchWritePolicy.durableDelete = writePolicy.durableDelete;
        batchWritePolicy.generationPolicy = writePolicy.generationPolicy;
        batchWritePolicy.expiration = writePolicy.expiration;
        batchWritePolicy.sendKey = writePolicy.sendKey;
        batchWritePolicy.recordExistsAction = writePolicy.recordExistsAction;
        batchWritePolicy.filterExp = writePolicy.filterExp;
        return batchWritePolicy;
    }

    private void loggerSetup() {
        Logger log = LoggerFactory.getLogger((String)"com.aerospike.client");
        Log.setCallback((level, message) -> {
            switch (level) {
                case INFO: {
                    log.info("{}", (Object)message);
                    break;
                }
                case DEBUG: {
                    log.debug("{}", (Object)message);
                    break;
                }
                case ERROR: {
                    log.error("{}", (Object)message);
                    break;
                }
                case WARN: {
                    log.warn("{}", (Object)message);
                }
            }
        });
    }

    public <T> String getSetName(Class<T> entityClass) {
        return ((BasicAerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass)).getSetName();
    }

    public <T> String getSetName(T document) {
        return ((BasicAerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass())).getSetName();
    }

    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public MappingAerospikeConverter getAerospikeConverter() {
        return this.converter;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public ServerVersionSupport getServerVersionSupport() {
        return this.serverVersionSupport;
    }

    protected static enum OperationType {
        SAVE_OPERATION("save"),
        INSERT_OPERATION("insert"),
        UPDATE_OPERATION("update"),
        DELETE_OPERATION("delete");

        private final String name;

        private OperationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

