/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchResults;
import com.aerospike.client.BatchWrite;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.client.reactor.dto.KeysRecords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.BatchWriteData;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.ExceptionUtils;
import org.springframework.data.aerospike.core.MappingUtils;
import org.springframework.data.aerospike.core.PolicyUtils;
import org.springframework.data.aerospike.core.TemplateContext;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.core.ValidationUtils;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BatchUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchUtils.class);

    private BatchUtils() {
        throw new UnsupportedOperationException("Utility class BatchUtils cannot be instantiated");
    }

    static <T> void applyBatchWriteInChunks(Iterable<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        BatchPolicy batchPolicy = (BatchPolicy)PolicyUtils.enrichPolicyWithTransaction(templateContext.client, (Policy)templateContext.client.copyBatchPolicyDefault());
        int batchSize = templateContext.converter.getAerospikeDataSettings().getBatchWriteSize();
        if (batchSize <= 0) {
            BatchUtils.batchWriteAllDocuments(Utils.iterableToList(documents), setName, operationType, batchPolicy, templateContext);
            return;
        }
        ArrayList<T> docsList = new ArrayList<T>();
        for (T doc : documents) {
            if (BatchUtils.batchSizeMatch(batchSize, docsList.size())) {
                BatchUtils.batchWriteAllDocuments(docsList, setName, operationType, batchPolicy, templateContext);
                docsList.clear();
            }
            docsList.add(doc);
        }
        if (!docsList.isEmpty()) {
            BatchUtils.batchWriteAllDocuments(docsList, setName, operationType, batchPolicy, templateContext);
        }
    }

    private static <T> void batchWriteAllDocuments(Collection<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType, BatchPolicy batchPolicy, TemplateContext templateContext) {
        ArrayList batchWriteDataList = new ArrayList();
        switch (operationType) {
            case SAVE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(BatchUtils.getBatchWriteForSave(document, setName, templateContext)));
                break;
            }
            case INSERT_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(BatchUtils.getBatchWriteForInsert(document, setName, templateContext)));
                break;
            }
            case UPDATE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(BatchUtils.getBatchWriteForUpdate(document, setName, templateContext)));
                break;
            }
            case DELETE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(BatchUtils.getBatchWriteForDelete(document, setName, templateContext)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected operation name: " + operationType);
            }
        }
        List<BatchRecord> batchWriteRecords = batchWriteDataList.stream().map(BatchWriteData::batchRecord).collect(Collectors.toList());
        try {
            templateContext.client.operate(batchPolicy, batchWriteRecords);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, templateContext.exceptionTranslator);
        }
        BatchUtils.checkForErrorsAndUpdateVersion(batchWriteDataList, batchWriteRecords, operationType, templateContext);
    }

    private static <T> void checkForErrorsAndUpdateVersion(Collection<BatchWriteData<T>> batchWriteDataList, Collection<BatchRecord> batchWriteRecords, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        boolean errorsFound = false;
        String casErrorDocumentId = null;
        for (BatchWriteData<T> data : batchWriteDataList) {
            if (!errorsFound && BatchUtils.batchRecordFailed(data.batchRecord(), false)) {
                errorsFound = true;
            }
            if (!data.hasVersionProperty()) continue;
            if (!BatchUtils.batchRecordFailed(data.batchRecord(), false)) {
                if (operationType == BaseAerospikeTemplate.OperationType.DELETE_OPERATION) continue;
                TemplateUtils.updateVersion(data.document(), data.batchRecord().record, templateContext);
                continue;
            }
            if (!ValidationUtils.hasOptimisticLockingError(data.batchRecord().resultCode)) continue;
            casErrorDocumentId = data.batchRecord().key.userKey.toString();
        }
        if (errorsFound) {
            if (casErrorDocumentId != null) {
                throw new OptimisticLockingFailureException("Failed to %s the record with ID '%s' due to versions mismatch".formatted(new Object[]{operationType, casErrorDocumentId}), null);
            }
            AerospikeException e = new AerospikeException("Errors during batch " + operationType);
            throw new AerospikeException.BatchRecordArray((BatchRecord[])batchWriteRecords.toArray(BatchRecord[]::new), (Throwable)e);
        }
    }

    static void deleteByIds(Iterable<?> ids, String setName, boolean skipNonExisting, TemplateContext templateContext) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return;
        }
        int batchSize = templateContext.converter.getAerospikeDataSettings().getBatchWriteSize();
        if (batchSize <= 0) {
            BatchUtils.doDeleteByIds(Utils.iterableToList(ids), setName, skipNonExisting, templateContext);
            return;
        }
        ArrayList idsList = new ArrayList();
        for (Object id : ids) {
            if (BatchUtils.batchSizeMatch(batchSize, idsList.size())) {
                BatchUtils.doDeleteByIds(idsList, setName, skipNonExisting, templateContext);
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            BatchUtils.doDeleteByIds(idsList, setName, skipNonExisting, templateContext);
        }
    }

    private static void doDeleteByIds(Collection<?> ids, String setName, boolean skipNonExisting, TemplateContext templateContext) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return;
        }
        Key[] keys = (Key[])MappingUtils.getKeys(ids, setName, templateContext).toArray(Key[]::new);
        BatchUtils.deleteAndHandleErrors(templateContext.client, keys, skipNonExisting, templateContext.exceptionTranslator);
    }

    static void deleteGroupedEntitiesByGroupedKeys(GroupedKeys groupedKeys, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        EntitiesKeys entitiesKeys = EntitiesKeys.of(MappingUtils.toEntitiesKeyMap(groupedKeys, templateContext));
        BatchUtils.deleteAndHandleErrors(templateContext.client, entitiesKeys.getKeys(), true, templateContext.exceptionTranslator);
    }

    private static void deleteAndHandleErrors(IAerospikeClient client, Key[] keys, boolean skipNonExisting, AerospikeExceptionTranslator exceptionTranslator) {
        BatchResults results;
        try {
            BatchPolicy batchPolicy = (BatchPolicy)PolicyUtils.enrichPolicyWithTransaction(client, (Policy)client.copyBatchPolicyDefault());
            results = client.delete(batchPolicy, null, keys);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, exceptionTranslator);
        }
        if (results.records == null) {
            throw new AerospikeException.BatchRecordArray(null, (Throwable)new AerospikeException("Errors during batch delete: resulting records are null"));
        }
        for (int i = 0; i < results.records.length; ++i) {
            BatchRecord record = results.records[i];
            if (!BatchUtils.batchRecordFailed(record, skipNonExisting)) continue;
            throw new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete"));
        }
    }

    static GroupedEntities findGroupedEntitiesByGroupedKeys(GroupedKeys groupedKeys, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        EntitiesKeys entitiesKeys = EntitiesKeys.of(MappingUtils.toEntitiesKeyMap(groupedKeys, templateContext));
        Record[] records = BatchUtils.findByKeysUsingQuery(Arrays.stream(entitiesKeys.getKeys()).toList(), null, null, templateContext);
        return MappingUtils.toGroupedEntities(entitiesKeys, records, templateContext.converter);
    }

    private static Record[] findByKeysUsingQuery(Collection<Key> keys, @Nullable String[] binNames, @Nullable Query query, TemplateContext templateContext) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        if (QualifierUtils.isQueryCriteriaNotNull(query)) {
            ValidationUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        }
        if (keys.isEmpty()) {
            return new Record[0];
        }
        try {
            BatchPolicy batchPolicy = PolicyUtils.getBatchPolicyFilterExp(query, templateContext);
            return BatchUtils.batchReadInChunks(batchPolicy, keys, binNames, templateContext);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, templateContext.exceptionTranslator);
        }
    }

    private static Record[] batchReadInChunks(BatchPolicy batchPolicy, Collection<Key> keys, String[] binNames, TemplateContext templateContext) {
        BatchPolicy batchPolicyEnriched = (BatchPolicy)PolicyUtils.enrichPolicyWithTransaction(templateContext.client, (Policy)batchPolicy);
        int batchSize = templateContext.converter.getAerospikeDataSettings().getBatchReadSize();
        if (keys.size() <= batchSize || batchSize <= 0) {
            return (Record[])BatchUtils.batchRead(batchPolicyEnriched, (Key[])keys.toArray(Key[]::new), binNames, templateContext).toArray(Record[]::new);
        }
        ArrayList allRecords = new ArrayList(keys.size());
        ArrayList<Key> keysChunk = new ArrayList<Key>(batchSize);
        for (Key key : keys) {
            keysChunk.add(key);
            if (keysChunk.size() < batchSize) continue;
            BatchUtils.batchRead(batchPolicyEnriched, (Key[])keysChunk.toArray(Key[]::new), binNames, templateContext).forEach(allRecords::add);
            keysChunk.clear();
        }
        if (!keysChunk.isEmpty()) {
            BatchUtils.batchRead(batchPolicyEnriched, (Key[])keysChunk.toArray(Key[]::new), binNames, templateContext).forEach(allRecords::add);
        }
        return (Record[])allRecords.toArray(Record[]::new);
    }

    private static Stream<Record> batchRead(BatchPolicy batchPolicy, Key[] keys, String[] binNames, TemplateContext templateContext) {
        if (binNames != null) {
            List<BatchRead> batchReads = BatchUtils.getBatchReadsWithBinNames(keys, binNames);
            templateContext.client.get(batchPolicy, batchReads);
            return batchReads.stream().map(batchRead -> batchRead.record);
        }
        return Arrays.stream(templateContext.client.get(batchPolicy, keys));
    }

    static Stream<Record> findByIdsUsingQueryWithoutMapping(Collection<?> ids, String setName, Query query, TemplateContext templateContext) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        Stream<Key> keys = MappingUtils.getKeys(ids, setName, templateContext);
        Record[] records = BatchUtils.findByKeysUsingQuery(keys.toList(), null, query, templateContext);
        return Arrays.stream(records);
    }

    static Stream<KeyRecord> findByIdsWithoutEntityMapping(Collection<?> ids, String setName, @Nullable String[] binNames, @Nullable Query query, TemplateContext templateContext) {
        Assert.notNull(ids, (String)"Ids must not be null");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (ids.isEmpty()) {
            return Stream.empty();
        }
        List<Key> keys = MappingUtils.getKeys(ids, setName, templateContext).toList();
        Record[] records = BatchUtils.findByKeysUsingQuery(keys, binNames, query, templateContext);
        return IntStream.range(0, records.length).filter(index -> records[index] != null).mapToObj(index -> new KeyRecord((Key)keys.get(index), records[index]));
    }

    static <T> Flux<T> applyReactiveBatchWriteInChunks(Iterable<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return Flux.defer(() -> {
            int batchSize = templateContext.converter.getAerospikeDataSettings().getBatchWriteSize();
            if (batchSize <= 0) {
                return BatchUtils.batchWriteAllDocumentsReactively(Utils.iterableToList(documents), setName, operationType, templateContext);
            }
            return BatchUtils.createNullTolerantBatches(documents, batchSize).concatMap(batch -> BatchUtils.batchWriteAllDocumentsReactively(batch, setName, operationType, templateContext));
        });
    }

    private static <T> Flux<T> batchWriteAllDocumentsReactively(List<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return Flux.defer(() -> {
            try {
                List batchWriteDataList = documents.stream().map(document -> switch (operationType) {
                    default -> throw new IncompatibleClassChangeError();
                    case BaseAerospikeTemplate.OperationType.SAVE_OPERATION -> BatchUtils.getBatchWriteForSave(document, setName, templateContext);
                    case BaseAerospikeTemplate.OperationType.INSERT_OPERATION -> BatchUtils.getBatchWriteForInsert(document, setName, templateContext);
                    case BaseAerospikeTemplate.OperationType.UPDATE_OPERATION -> BatchUtils.getBatchWriteForUpdate(document, setName, templateContext);
                    case BaseAerospikeTemplate.OperationType.DELETE_OPERATION -> BatchUtils.getBatchWriteForDelete(document, setName, templateContext);
                }).toList();
                List<BatchRecord> batchWriteRecords = batchWriteDataList.stream().map(BatchWriteData::batchRecord).toList();
                BatchPolicy defaultBatchPolicy = templateContext.reactorClient.getAerospikeClient().copyBatchPolicyDefault();
                return BatchUtils.batchWriteReactivelyAndCheckForErrors(defaultBatchPolicy, batchWriteRecords, batchWriteDataList, operationType, templateContext);
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
        });
    }

    private static <T> Flux<T> batchWriteReactivelyAndCheckForErrors(BatchPolicy batchPolicy, List<BatchRecord> batchWriteRecords, List<BatchWriteData<T>> batchWriteDataList, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        return PolicyUtils.enrichPolicyWithTransaction(templateContext.reactorClient, (Policy)batchPolicy).flatMap(batchPolicyEnriched -> templateContext.reactorClient.operate((BatchPolicy)batchPolicyEnriched, batchWriteRecords)).onErrorMap(e -> ExceptionUtils.translateError(e, templateContext.exceptionTranslator)).flatMap(ignore -> BatchUtils.checkForErrorsAndUpdateVersionForReactive(batchWriteDataList, batchWriteRecords, operationType, templateContext)).flux().flatMapIterable(list -> list.stream().map(BatchWriteData::document).toList());
    }

    private static <T> Mono<List<BatchWriteData<T>>> checkForErrorsAndUpdateVersionForReactive(List<BatchWriteData<T>> batchWriteDataList, List<BatchRecord> batchWriteRecords, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        boolean errorsFound = false;
        String casErrorDocumentId = null;
        for (BatchWriteData<T> data : batchWriteDataList) {
            if (!errorsFound && BatchUtils.batchRecordFailed(data.batchRecord(), false)) {
                errorsFound = true;
            }
            if (!data.hasVersionProperty()) continue;
            if (!BatchUtils.batchRecordFailed(data.batchRecord(), false)) {
                if (operationType == BaseAerospikeTemplate.OperationType.DELETE_OPERATION) continue;
                TemplateUtils.updateVersion(data.document(), data.batchRecord().record, templateContext);
                continue;
            }
            if (!ValidationUtils.hasOptimisticLockingError(data.batchRecord().resultCode)) continue;
            casErrorDocumentId = data.batchRecord().key.userKey.toString();
        }
        if (errorsFound) {
            if (casErrorDocumentId != null) {
                return Mono.error((Throwable)new OptimisticLockingFailureException("Failed to %s the record with ID '%s' due to versions mismatch".formatted(new Object[]{operationType, casErrorDocumentId}), null));
            }
            AerospikeException e = new AerospikeException("Errors during batch " + operationType);
            return Mono.error((Throwable)new AerospikeException.BatchRecordArray((BatchRecord[])batchWriteRecords.toArray(BatchRecord[]::new), (Throwable)e));
        }
        return Mono.just(batchWriteDataList);
    }

    static Mono<Void> deleteByIdsReactively(Iterable<?> ids, String setName, boolean skipNonExisting, TemplateContext templateContext) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return Mono.empty();
        }
        int batchSize = templateContext.converter.getAerospikeDataSettings().getBatchWriteSize();
        if (batchSize <= 0) {
            return BatchUtils.doDeleteByIdsReactively(Utils.iterableToList(ids), setName, skipNonExisting, templateContext);
        }
        ArrayList idsList = new ArrayList();
        ArrayList<Mono<Void>> deleteResults = new ArrayList<Mono<Void>>();
        for (Object id : ids) {
            if (BatchUtils.batchSizeMatch(batchSize, idsList.size())) {
                deleteResults.add(BatchUtils.doDeleteByIdsReactively(new ArrayList(idsList), setName, skipNonExisting, templateContext));
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            deleteResults.add(BatchUtils.doDeleteByIdsReactively(new ArrayList(idsList), setName, skipNonExisting, templateContext));
        }
        return Flux.concat((Publisher)Flux.fromIterable(deleteResults)).then();
    }

    private static Mono<Void> doDeleteByIdsReactively(Collection<?> ids, String setName, boolean skipNonExisting, TemplateContext templateContext) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return Mono.empty();
        }
        Key[] keys = (Key[])ids.stream().map(id -> TemplateUtils.getKey(id, setName, templateContext)).toArray(Key[]::new);
        return BatchUtils.batchDeleteReactivelyAndCheckForErrors(templateContext.reactorClient, keys, skipNonExisting, templateContext.exceptionTranslator);
    }

    private static Mono<Void> batchDeleteReactivelyAndCheckForErrors(IAerospikeReactorClient reactorClient, Key[] keys, boolean skipNonExisting, AerospikeExceptionTranslator exceptionTranslator) {
        Function<BatchResults, Mono> checkForErrors = results -> {
            if (results.records == null) {
                return Mono.error((Throwable)new AerospikeException.BatchRecordArray(null, (Throwable)new AerospikeException("Errors during batch delete: resulting records are null")));
            }
            for (BatchRecord record : results.records) {
                if (!BatchUtils.batchRecordFailed(record, skipNonExisting)) continue;
                return Mono.error((Throwable)new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete")));
            }
            return Mono.empty();
        };
        return PolicyUtils.enrichPolicyWithTransaction(reactorClient, (Policy)reactorClient.getAerospikeClient().copyBatchPolicyDefault()).flatMap(batchPolicy -> reactorClient.delete((BatchPolicy)batchPolicy, null, keys)).onErrorMap(e -> ExceptionUtils.translateError(e, exceptionTranslator)).flatMap(checkForErrors);
    }

    static Mono<Void> deleteEntitiesByGroupedKeysReactively(GroupedKeys groupedKeys, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        EntitiesKeys entitiesKeys = EntitiesKeys.of(MappingUtils.toEntitiesKeyMap(groupedKeys, templateContext));
        IAerospikeReactorClient reactorClient = templateContext.reactorClient;
        PolicyUtils.enrichPolicyWithTransaction(reactorClient, (Policy)reactorClient.getAerospikeClient().copyBatchPolicyDefault()).flatMap(batchPolicy -> reactorClient.delete((BatchPolicy)batchPolicy, null, entitiesKeys.getKeys())).onErrorMap(e -> ExceptionUtils.translateError(e, templateContext.exceptionTranslator));
        return BatchUtils.batchDeleteReactivelyAndCheckForErrors(reactorClient, entitiesKeys.getKeys(), true, templateContext.exceptionTranslator);
    }

    static Mono<GroupedEntities> findGroupedEntitiesByGroupedKeysReactively(BatchPolicy batchPolicy, GroupedKeys groupedKeys, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        EntitiesKeys entitiesKeys = EntitiesKeys.of(MappingUtils.toEntitiesKeyMap(groupedKeys, templateContext));
        return BatchUtils.batchReadInChunksReactively(batchPolicy, entitiesKeys.getKeys(), null, templateContext).collectList().map(keyRecordsList -> MappingUtils.toGroupedEntities(entitiesKeys, (Record[])BatchUtils.getRecordsStream(keyRecordsList).toArray(Record[]::new), templateContext.converter)).onErrorMap(e -> ExceptionUtils.translateError(e, templateContext.exceptionTranslator));
    }

    private static Stream<Record> getRecordsStream(List<KeyRecord> keyRecordsList) {
        return keyRecordsList.stream().map(keyRecord -> keyRecord.record);
    }

    static BatchPolicy getBatchPolicyForReactive(Query query, TemplateContext templateContext) {
        if (QualifierUtils.isQueryCriteriaNotNull(query)) {
            BatchPolicy batchPolicy = templateContext.reactorClient.getAerospikeClient().copyBatchPolicyDefault();
            Qualifier qualifier = query.getCriteriaObject();
            batchPolicy.filterExp = templateContext.reactorQueryEngine.getFilterExpressionsBuilder().build(qualifier);
            return batchPolicy;
        }
        return templateContext.reactorClient.getAerospikeClient().copyBatchPolicyDefault();
    }

    static Flux<KeyRecord> batchReadInChunksReactively(BatchPolicy batchPolicy, Key[] keys, @Nullable Class<?> targetClass, TemplateContext templateContext) {
        Mono<Policy> enrichedPolicyMono = PolicyUtils.enrichPolicyWithTransaction(templateContext.reactorClient, (Policy)batchPolicy);
        int batchSize = templateContext.converter.getAerospikeDataSettings().getBatchReadSize();
        return enrichedPolicyMono.flatMapMany(batchPolicyEnriched -> {
            if (batchSize <= 0) {
                return BatchUtils.batchReadReactively((BatchPolicy)batchPolicyEnriched, keys, targetClass, templateContext).flatMapIterable(BatchUtils::keysRecordsToList);
            }
            return Flux.fromArray((Object[])keys).buffer(batchSize).flatMapSequential(keyList -> {
                Key[] keysChunk = keyList.toArray(new Key[0]);
                return BatchUtils.batchReadReactively((BatchPolicy)batchPolicyEnriched, keysChunk, targetClass, templateContext).flatMapIterable(BatchUtils::keysRecordsToList);
            }, 1);
        });
    }

    private static Iterable<KeyRecord> keysRecordsToList(KeysRecords keysRecords) {
        ArrayList<KeyRecord> result = new ArrayList<KeyRecord>(keysRecords.keys.length);
        for (int i = 0; i < keysRecords.keys.length; ++i) {
            result.add(new KeyRecord(keysRecords.keys[i], keysRecords.records[i]));
        }
        return result;
    }

    private static Mono<KeysRecords> batchReadReactively(BatchPolicy batchPolicy, Key[] keys, @Nullable Class<?> targetClass, TemplateContext templateContext) {
        IAerospikeReactorClient reactorClient = templateContext.reactorClient;
        String[] binNames = MappingUtils.getBinNamesFromTargetClassOrNull(null, targetClass, templateContext.mappingContext);
        if (binNames != null) {
            return reactorClient.get(batchPolicy, BatchUtils.getBatchReadsWithBinNames(keys, binNames)).flatMap(batchReads -> BatchUtils.batchReadsToKeysRecords(keys, batchReads));
        }
        return reactorClient.get(batchPolicy, keys);
    }

    private static Mono<KeysRecords> batchReadsToKeysRecords(Key[] keys, List<BatchRead> batchReads) {
        Record[] records = (Record[])batchReads.stream().map(batchRead -> batchRead.record).toArray(Record[]::new);
        return Mono.just((Object)new KeysRecords(keys, records));
    }

    private static List<BatchRead> getBatchReadsWithBinNames(Key[] keys, @NonNull String[] binNames) {
        Assert.notNull((Object)binNames, (String)"Bin names must not be null");
        if (binNames.length == 0) {
            return Arrays.stream(keys).map(key -> new BatchRead(key, false)).collect(Collectors.toCollection(() -> new ArrayList(keys.length)));
        }
        return Arrays.stream(keys).map(key -> new BatchRead(key, binNames)).collect(Collectors.toCollection(() -> new ArrayList(keys.length)));
    }

    private static <T> BatchWriteData<T> getBatchWriteForSave(T document, String setName, TemplateContext templateContext) {
        Operation[] operations;
        BatchWritePolicy policy;
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)templateContext.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            policy = PolicyUtils.expectGenerationCasAwareBatchPolicy(data, templateContext.batchWritePolicyDefault);
            operations = TemplateUtils.getPutAndGetHeaderOperations(data, true);
        } else {
            policy = PolicyUtils.ignoreGenerationBatchPolicy(data, RecordExistsAction.UPDATE, templateContext.batchWritePolicyDefault);
            operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        }
        return new BatchWriteData<T>(document, (BatchRecord)new BatchWrite(policy, data.getKey(), operations), entity.hasVersionProperty());
    }

    private static <T> BatchWriteData<T> getBatchWriteForInsert(T document, String setName, TemplateContext templateContext) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)templateContext.mappingContext.getRequiredPersistentEntity(document.getClass());
        BatchWritePolicy policy = PolicyUtils.ignoreGenerationBatchPolicy(data, RecordExistsAction.CREATE_ONLY, templateContext.batchWritePolicyDefault);
        Operation[] operations = entity.hasVersionProperty() ? TemplateUtils.getPutAndGetHeaderOperations(data, false) : TemplateUtils.operations(data.getBinsAsArray(), Operation::put);
        return new BatchWriteData<T>(document, (BatchRecord)new BatchWrite(policy, data.getKey(), operations), entity.hasVersionProperty());
    }

    private static <T> BatchWriteData<T> getBatchWriteForUpdate(T document, String setName, TemplateContext templateContext) {
        Operation[] operations;
        BatchWritePolicy policy;
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)templateContext.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            policy = PolicyUtils.expectGenerationBatchPolicy(data, RecordExistsAction.UPDATE_ONLY, templateContext.batchWritePolicyDefault);
            operations = TemplateUtils.getPutAndGetHeaderOperations(data, true);
        } else {
            policy = PolicyUtils.ignoreGenerationBatchPolicy(data, RecordExistsAction.UPDATE_ONLY, templateContext.batchWritePolicyDefault);
            operations = (Operation[])Stream.concat(Stream.of(Operation.delete()), data.getBins().stream().map(Operation::put)).toArray(Operation[]::new);
        }
        return new BatchWriteData<T>(document, (BatchRecord)new BatchWrite(policy, data.getKey(), operations), entity.hasVersionProperty());
    }

    private static <T> BatchWriteData<T> getBatchWriteForDelete(T document, String setName, TemplateContext templateContext) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)templateContext.mappingContext.getRequiredPersistentEntity(document.getClass());
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, templateContext);
        BatchWritePolicy policy = entity.hasVersionProperty() ? PolicyUtils.expectGenerationBatchPolicy(data, RecordExistsAction.UPDATE_ONLY, templateContext.batchWritePolicyDefault) : PolicyUtils.ignoreGenerationBatchPolicy(data, RecordExistsAction.UPDATE_ONLY, templateContext.batchWritePolicyDefault);
        Operation[] operations = Operation.array((Operation[])new Operation[]{Operation.delete()});
        return new BatchWriteData<T>(document, (BatchRecord)new BatchWrite(policy, data.getKey(), operations), entity.hasVersionProperty());
    }

    static boolean batchSizeMatch(int batchSize, int currentSize) {
        return batchSize > 0 && currentSize == batchSize;
    }

    private static boolean batchRecordFailed(BatchRecord batchRecord, boolean skipNonExisting) {
        int resultCode = batchRecord.resultCode;
        if (skipNonExisting) {
            return resultCode != 0 && resultCode != 2;
        }
        return resultCode != 0 || batchRecord.record == null;
    }

    private static <T> Flux<List<T>> createNullTolerantBatches(Iterable<? extends T> source, int batchSize) {
        return Flux.create(sink -> {
            try {
                ArrayList currentBatch = new ArrayList();
                for (Object item : source) {
                    currentBatch.add(item);
                    if (!BatchUtils.batchSizeMatch(batchSize, currentBatch.size())) continue;
                    sink.next(new ArrayList(currentBatch));
                    currentBatch.clear();
                }
                if (!currentBatch.isEmpty()) {
                    sink.next(new ArrayList(currentBatch));
                }
                sink.complete();
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        });
    }

    static <T, S> Stream<?> findByIdsWithoutPostProcessing(Iterable<?> ids, Class<T> entityClass, @Nullable Class<S> targetClass, String setName, @Nullable Query query, TemplateContext templateContext) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        List<Key> keys = MappingUtils.getKeys(Utils.iterableToList(ids), setName, templateContext).toList();
        String[] binNames = MappingUtils.getBinNamesFromTargetClassOrNull(entityClass, targetClass, templateContext.mappingContext);
        Record[] records = BatchUtils.findByKeysUsingQuery(keys, binNames, query, templateContext);
        return IntStream.range(0, keys.size()).mapToObj(index -> MappingUtils.mapToEntity((Key)keys.get(index), MappingUtils.getTargetClass(entityClass, targetClass), records[index], templateContext.converter));
    }

    static Flux<KeyRecord> findByIdsUsingQueryWithoutEntityMappingReactively(Collection<?> ids, String setName, @Nullable Query query, TemplateContext templateContext) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy batchPolicy = BatchUtils.getBatchPolicyForReactive(query, templateContext);
        Key[] keys = (Key[])MappingUtils.getKeys(Utils.iterableToList(ids), setName, templateContext).toArray(Key[]::new);
        return BatchUtils.batchReadInChunksReactively(batchPolicy, keys, null, templateContext);
    }

    static <T, S> Flux<?> findByIdsWithoutPostProcessingReactively(Collection<?> ids, Class<T> entityClass, @Nullable Class<S> targetClass, String setName, @Nullable Query query, TemplateContext templateContext) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy batchPolicy = BatchUtils.getBatchPolicyForReactive(query, templateContext);
        Class<?> targetType = MappingUtils.getTargetClass(entityClass, targetClass);
        Key[] keys = (Key[])MappingUtils.getKeys(Utils.iterableToList(ids), setName, templateContext).toArray(Key[]::new);
        return BatchUtils.batchReadInChunksReactively(batchPolicy, keys, targetType, templateContext).flatMap(keyRecord -> MappingUtils.mapToEntityReactively(keyRecord.key, targetType, keyRecord.record, templateContext.converter));
    }
}

