/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.exceptions.IndexNotFoundException;

public class DefaultAerospikeExceptionTranslator
implements AerospikeExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException cause) {
        if (cause instanceof AerospikeException) {
            int resultCode = ((AerospikeException)((Object)cause)).getResultCode();
            String msg = cause.getMessage();
            if (cause instanceof AerospikeException.Connection && resultCode == -8) {
                return new QueryTimeoutException(msg, (Throwable)cause);
            }
            return switch (resultCode) {
                case 4 -> new InvalidDataAccessApiUsageException(msg, (Throwable)cause);
                case 5 -> new DuplicateKeyException(msg, (Throwable)cause);
                case 2 -> new DataRetrievalFailureException(msg, (Throwable)cause);
                case 201 -> new IndexNotFoundException(msg, cause);
                case 9, 212 -> new QueryTimeoutException(msg, (Throwable)cause);
                case -7, 14, 18 -> new TransientDataAccessResourceException(msg, (Throwable)cause);
                default -> new RecoverableDataAccessException(msg, (Throwable)cause);
            };
        }
        return null;
    }
}

