/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.Key;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;

final class EntitiesKeys {
    private final Class<?>[] entityClasses;
    private final Key[] keys;

    public static EntitiesKeys of(Map<Class<?>, List<Key>> entitiesKeys) {
        Class[] entityClasses = (Class[])entitiesKeys.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(item -> (Class)entry.getKey())).toArray(Class[]::new);
        Key[] keys = (Key[])entitiesKeys.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).toArray(Key[]::new);
        return EntitiesKeys.builder().entityClasses(entityClasses).keys(keys).build();
    }

    @Generated
    EntitiesKeys(Class<?>[] entityClasses, Key[] keys) {
        this.entityClasses = entityClasses;
        this.keys = keys;
    }

    @Generated
    public static EntitiesKeysBuilder builder() {
        return new EntitiesKeysBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesKeys)) {
            return false;
        }
        EntitiesKeys other = (EntitiesKeys)o;
        if (!Arrays.deepEquals(this.getEntityClasses(), other.getEntityClasses())) {
            return false;
        }
        return Arrays.deepEquals(this.getKeys(), other.getKeys());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getEntityClasses());
        result = result * 59 + Arrays.deepHashCode(this.getKeys());
        return result;
    }

    @Generated
    public String toString() {
        return "EntitiesKeys(entityClasses=" + Arrays.deepToString(this.getEntityClasses()) + ", keys=" + Arrays.deepToString(this.getKeys()) + ")";
    }

    @Generated
    public Class<?>[] getEntityClasses() {
        return this.entityClasses;
    }

    @Generated
    public Key[] getKeys() {
        return this.keys;
    }

    @Generated
    public static class EntitiesKeysBuilder {
        @Generated
        private Class<?>[] entityClasses;
        @Generated
        private Key[] keys;

        @Generated
        EntitiesKeysBuilder() {
        }

        @Generated
        public EntitiesKeysBuilder entityClasses(Class<?>[] entityClasses) {
            this.entityClasses = entityClasses;
            return this;
        }

        @Generated
        public EntitiesKeysBuilder keys(Key[] keys) {
            this.keys = keys;
            return this;
        }

        @Generated
        public EntitiesKeys build() {
            return new EntitiesKeys(this.entityClasses, this.keys);
        }

        @Generated
        public String toString() {
            return "EntitiesKeys.EntitiesKeysBuilder(entityClasses=" + Arrays.deepToString(this.entityClasses) + ", keys=" + Arrays.deepToString(this.keys) + ")";
        }
    }
}

