/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.TemplateContext;
import org.springframework.data.aerospike.core.ValidationUtils;

public final class ExceptionUtils {
    private ExceptionUtils() {
        throw new UnsupportedOperationException("Utility class ExceptionUtils cannot be instantiated");
    }

    static RuntimeException translateError(AerospikeException e, AerospikeExceptionTranslator translator) {
        DataAccessException translated = translator.translateExceptionIfPossible((RuntimeException)((Object)e));
        return translated == null ? e : translated;
    }

    static Throwable translateError(Throwable e, AerospikeExceptionTranslator translator) {
        if (e instanceof AerospikeException) {
            AerospikeException ae = (AerospikeException)e;
            return ExceptionUtils.translateError(ae, translator);
        }
        return e;
    }

    static Throwable translateCasThrowable(Throwable e, String operationName, TemplateContext templateContext) {
        if (e instanceof AerospikeException) {
            AerospikeException ae = (AerospikeException)e;
            return ExceptionUtils.translateCasException(ae, "Failed to %s record due to versions mismatch".formatted(operationName), templateContext.exceptionTranslator);
        }
        return e;
    }

    static RuntimeException translateCasException(AerospikeException e, String errMsg, AerospikeExceptionTranslator exceptionTranslator) {
        if (ValidationUtils.hasOptimisticLockingError(e.getResultCode())) {
            return new OptimisticLockingFailureException(errMsg, (Throwable)e);
        }
        return ExceptionUtils.translateError(e, exceptionTranslator);
    }
}

