/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.query.KeyRecord;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.ExceptionUtils;
import org.springframework.data.aerospike.core.TemplateContext;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class MappingUtils {
    private MappingUtils() {
        throw new UnsupportedOperationException("Utility class MappingUtils cannot be instantiated");
    }

    static <T> T mapToEntity(KeyRecord keyRecord, Class<T> targetClass, MappingAerospikeConverter converter) {
        return MappingUtils.mapToEntity(keyRecord.key, targetClass, keyRecord.record, converter);
    }

    static <T> T mapToEntity(Key key, Class<T> clazz, Record aeroRecord, MappingAerospikeConverter converter) {
        if (aeroRecord == null) {
            return null;
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, aeroRecord);
        return converter.read(clazz, data);
    }

    static <T> Mono<T> mapToEntityReactively(Key key, Class<T> clazz, Record aeroRecord, MappingAerospikeConverter converter) {
        if (aeroRecord == null) {
            return Mono.empty();
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, aeroRecord);
        return Mono.just(converter.read(clazz, data));
    }

    static GroupedEntities toGroupedEntities(EntitiesKeys entitiesKeys, Record[] records, MappingAerospikeConverter converter) {
        GroupedEntities.GroupedEntitiesBuilder builder = GroupedEntities.builder();
        IntStream.range(0, entitiesKeys.getKeys().length).filter(index -> records[index] != null).mapToObj(index -> MappingUtils.mapToEntity(entitiesKeys.getKeys()[index], entitiesKeys.getEntityClasses()[index], records[index], converter)).filter(Objects::nonNull).forEach(entity -> builder.entity(MappingUtils.getEntityClass(entity), entity));
        return builder.build();
    }

    static Map<Class<?>, List<Key>> toEntitiesKeyMap(GroupedKeys groupedKeys, TemplateContext templateContext) {
        return groupedKeys.getEntitiesKeys().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> MappingUtils.toKeysList((Class)entry.getKey(), (Collection)entry.getValue(), templateContext)));
    }

    static <T> List<String> fieldsToBinNames(T document, Collection<String> fields, TemplateContext templateContext) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)templateContext.mappingContext.getRequiredPersistentEntity(document.getClass());
        return fields.stream().map(field -> {
            if (entity.getPersistentProperty((String)field) != null) {
                return Objects.requireNonNull((AerospikePersistentProperty)entity.getPersistentProperty((String)field)).getFieldName();
            }
            if (MappingUtils.getFieldAnnotatedValue(entity, field) != null) {
                return field;
            }
            throw ExceptionUtils.translateError(new AerospikeException("Cannot convert field: " + field + " to bin name. field doesn't exists."), templateContext.exceptionTranslator);
        }).collect(Collectors.toList());
    }

    private static String getFieldAnnotatedValue(AerospikePersistentEntity<?> entity, String field) {
        for (AerospikePersistentProperty property : entity.getPersistentProperties(Field.class)) {
            if (!property.getFieldName().equals(field)) continue;
            return field;
        }
        return null;
    }

    private static <T> List<Key> toKeysList(Class<T> entityClass, Collection<?> ids, TemplateContext templateContext) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(ids, (String)"List of ids must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)templateContext.mappingContext.getRequiredPersistentEntity(entityClass);
        List<?> idsList = Utils.iterableToList(ids);
        return idsList.stream().map(id -> TemplateUtils.getKey(id, entity, templateContext)).collect(Collectors.toList());
    }

    static Calendar convertToCalendar(Instant instant) {
        if (instant == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        if (instant.toEpochMilli() > calendar.getTimeInMillis()) {
            throw new IllegalArgumentException("Last update time (%d) must be less than the current time".formatted(instant.toEpochMilli()));
        }
        calendar.setTime(Date.from(instant));
        return calendar;
    }

    static <S> S convertIfNecessary(MappingAerospikeConverter converter, Object source, Class<S> type) {
        return (S)(type.isAssignableFrom(source.getClass()) ? source : converter.getConversionService().convert(source, type));
    }

    static <T, S> Class<?> getTargetClass(Class<T> entityClass, Class<S> targetClass) {
        if (targetClass != null && targetClass != entityClass) {
            return targetClass;
        }
        return entityClass;
    }

    public static String[] getBinNamesFromTargetClassOrNull(@Nullable Class<?> entityClass, @Nullable Class<?> targetClass, MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext) {
        if (targetClass == null || targetClass == entityClass) {
            return null;
        }
        return MappingUtils.getBinNamesFromTargetClass(targetClass, mappingContext);
    }

    public static String[] getBinNamesFromTargetClass(Class<?> targetClass, MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext) {
        return MappingUtils.getBinNamesListFromTargetClass(targetClass, mappingContext).toArray(new String[0]);
    }

    public static List<String> getBinNamesListFromTargetClass(Class<?> targetClass, MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext) {
        AerospikePersistentEntity targetEntity = (AerospikePersistentEntity)mappingContext.getRequiredPersistentEntity(targetClass);
        ArrayList<String> binNamesList = new ArrayList<String>();
        targetEntity.doWithProperties(property -> {
            if (!property.isIdProperty()) {
                binNamesList.add(property.getFieldName());
            }
        });
        return binNamesList;
    }

    static <T> Class<T> getEntityClass(T entity) {
        return entity.getClass();
    }

    static Stream<Key> getKeys(Collection<?> ids, String setName, TemplateContext templateContext) {
        return ids.stream().map(id -> TemplateUtils.getKey(id, setName, templateContext));
    }
}

