/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.core.TemplateContext;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.transaction.reactive.AerospikeReactiveTransactionResourceHolder;
import org.springframework.data.aerospike.transaction.sync.AerospikeTransactionResourceHolder;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.reactive.TransactionContextManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import reactor.core.publisher.Mono;

public final class PolicyUtils {
    private PolicyUtils() {
        throw new UnsupportedOperationException("Utility class PolicyUtils cannot be instantiated");
    }

    public static Policy enrichPolicyWithTransaction(IAerospikeClient client, Policy policy) {
        if (TransactionSynchronizationManager.hasResource((Object)client)) {
            AerospikeTransactionResourceHolder resourceHolder = (AerospikeTransactionResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)client));
            if (resourceHolder != null) {
                policy.txn = resourceHolder.getTransaction();
            }
            return policy;
        }
        return policy;
    }

    private static Policy getPolicyFilterExp(IAerospikeClient client, QueryEngine queryEngine, Query query) {
        if (QualifierUtils.isQueryCriteriaNotNull(query)) {
            Policy policy = client.copyReadPolicyDefault();
            Qualifier qualifier = query.getCriteriaObject();
            policy.filterExp = queryEngine.getFilterExpressionsBuilder().build(qualifier);
            return policy;
        }
        return null;
    }

    static Policy getPolicyFilterExpOrDefault(IAerospikeClient client, QueryEngine queryEngine, Query query) {
        Policy policy = PolicyUtils.getPolicyFilterExp(client, queryEngine, query);
        return policy != null ? policy : client.copyReadPolicyDefault();
    }

    static Mono<Policy> enrichPolicyWithTransaction(IAerospikeReactorClient reactorClient, Policy policy) {
        return TransactionContextManager.currentContext().map(ctx -> {
            AerospikeReactiveTransactionResourceHolder resourceHolder = (AerospikeReactiveTransactionResourceHolder)((Object)((Object)ctx.getResources().get(reactorClient)));
            if (resourceHolder != null) {
                policy.txn = resourceHolder.getTransaction();
            }
            return policy;
        }).onErrorResume(NoTransactionException.class, ignored -> Mono.just((Object)policy));
    }

    static BatchPolicy getBatchPolicyFilterExp(Query query, TemplateContext templateContext) {
        if (QualifierUtils.isQueryCriteriaNotNull(query)) {
            BatchPolicy batchPolicy = templateContext.client.copyBatchPolicyDefault();
            Qualifier qualifier = query.getCriteriaObject();
            batchPolicy.filterExp = templateContext.queryEngine.getFilterExpressionsBuilder().build(qualifier);
            return batchPolicy;
        }
        return templateContext.client.copyBatchPolicyDefault();
    }

    static WritePolicy expectGenerationCasAwarePolicy(AerospikeWriteData data, WritePolicy writePolicyDefault) {
        RecordExistsAction recordExistsAction = data.getVersion().filter(v -> (long)v.intValue() > 0L).map(v -> RecordExistsAction.UPDATE_ONLY).orElse(RecordExistsAction.CREATE_ONLY);
        return PolicyUtils.expectGenerationPolicy(data, recordExistsAction, writePolicyDefault);
    }

    static BatchWritePolicy expectGenerationCasAwareBatchPolicy(AerospikeWriteData data, BatchWritePolicy batchWritePolicyDefault) {
        RecordExistsAction recordExistsAction = data.getVersion().filter(v -> (long)v.intValue() > 0L).map(v -> RecordExistsAction.UPDATE_ONLY).orElse(RecordExistsAction.CREATE_ONLY);
        return PolicyUtils.expectGenerationBatchPolicy(data, recordExistsAction, batchWritePolicyDefault);
    }

    static WritePolicy expectGenerationPolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction, WritePolicy writePolicyDefault) {
        return WritePolicyBuilder.builder(writePolicyDefault).generationPolicy(GenerationPolicy.EXPECT_GEN_EQUAL).generation(data.getVersion().orElse(0)).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    static BatchWritePolicy expectGenerationBatchPolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction, BatchWritePolicy batchWritePolicyDefault) {
        BatchWritePolicy batchWritePolicy = new BatchWritePolicy(batchWritePolicyDefault);
        batchWritePolicy.generationPolicy = GenerationPolicy.EXPECT_GEN_EQUAL;
        batchWritePolicy.generation = data.getVersion().orElse(0);
        batchWritePolicy.expiration = data.getExpiration();
        batchWritePolicy.recordExistsAction = recordExistsAction;
        return batchWritePolicy;
    }

    static WritePolicy ignoreGenerationPolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction, WritePolicy writePolicyDefault) {
        return WritePolicyBuilder.builder(writePolicyDefault).generationPolicy(GenerationPolicy.NONE).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    static BatchWritePolicy ignoreGenerationBatchPolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction, BatchWritePolicy batchWritePolicyDefault) {
        BatchWritePolicy batchWritePolicy = new BatchWritePolicy(batchWritePolicyDefault);
        batchWritePolicy.generationPolicy = GenerationPolicy.NONE;
        batchWritePolicy.expiration = data.getExpiration();
        batchWritePolicy.recordExistsAction = recordExistsAction;
        return batchWritePolicy;
    }

    static WritePolicy ignoreGenerationPolicy(WritePolicy writePolicyDefault) {
        return WritePolicyBuilder.builder(writePolicyDefault).generationPolicy(GenerationPolicy.NONE).build();
    }

    static WritePolicy expectGenerationPolicy(AerospikeWriteData data, WritePolicy writePolicyDefault) {
        return WritePolicyBuilder.builder(writePolicyDefault).generationPolicy(GenerationPolicy.EXPECT_GEN_EQUAL).generation(data.getVersion().orElse(0)).expiration(data.getExpiration()).build();
    }
}

