/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import java.util.Comparator;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;

public final class PostProcessingUtils {
    private PostProcessingUtils() {
        throw new UnsupportedOperationException("Utility class PostProcessingUtils cannot be instantiated");
    }

    public static <T> Stream<T> applyPostProcessingOnResults(Stream<T> results, @Nullable Query query) {
        if (query == null) {
            return results;
        }
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = TemplateUtils.getComparator(query);
            results = results.sorted(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.limit(query.getRows());
        }
        return results;
    }

    static <T> Stream<T> applyPostProcessingOnResults(Stream<T> results, Sort sort, long offset, long limit) {
        if (sort != null && sort.isSorted()) {
            Comparator comparator = TemplateUtils.getComparator(sort);
            results = results.sorted(comparator);
        }
        if (offset > 0L) {
            results = results.skip(offset);
        }
        if (limit > 0L) {
            results = results.limit(limit);
        }
        return results;
    }

    static <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, @Nullable Query query) {
        if (query == null) {
            return results;
        }
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = TemplateUtils.getComparator(query);
            results = results.sort(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.take((long)query.getRows());
        }
        return results;
    }

    static <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, Sort sort, long offset, long limit) {
        if (sort != null && sort.isSorted()) {
            Comparator comparator = TemplateUtils.getComparator(sort);
            results = results.sort(comparator);
        }
        if (offset > 0L) {
            results = results.skip(offset);
        }
        if (limit > 0L) {
            results = results.take(limit);
        }
        return results;
    }
}

