/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.util.Assert;

public final class QualifierUtils {
    private QualifierUtils() {
        throw new UnsupportedOperationException("Utility class QualifierUtils cannot be instantiated");
    }

    public static List<Object> getIdValue(Qualifier qualifier) {
        if (qualifier.hasId()) {
            return QualifierUtils.idObjectToList(qualifier.getId());
        }
        throw new IllegalArgumentException("Id qualifier must contain value");
    }

    private static List<Object> idObjectToList(Object ids) {
        Stream<Object> idStream;
        Assert.notNull((Object)ids, (String)"Ids must not be null");
        if (ids instanceof byte[]) {
            idStream = Stream.of(ids);
        } else if (ids.getClass().isArray()) {
            idStream = Arrays.stream((Object[])ids);
        } else if (ids instanceof Iterable) {
            Iterable iterable = (Iterable)ids;
            idStream = StreamSupport.stream(iterable.spliterator(), false).map(o -> o);
        } else {
            idStream = Stream.of(ids);
        }
        return idStream.toList();
    }

    private static Qualifier[] excludeIdQualifier(Qualifier[] qualifiers) {
        ArrayList<Qualifier> qualifiersWithoutId = new ArrayList<Qualifier>();
        if (qualifiers != null && qualifiers.length > 0) {
            for (Qualifier qualifier : qualifiers) {
                if (qualifier.hasQualifiers()) {
                    Qualifier[] internalQuals = QualifierUtils.excludeIdQualifier(qualifier.getQualifiers());
                    qualifiersWithoutId.add(QualifierUtils.combineMultipleQualifiers(qualifier.getOperation(), internalQuals));
                    continue;
                }
                if (qualifier.hasId()) continue;
                qualifiersWithoutId.add(qualifier);
            }
            return (Qualifier[])qualifiersWithoutId.toArray(Qualifier[]::new);
        }
        return null;
    }

    public static Qualifier excludeIdQualifier(Qualifier qualifier) {
        ArrayList<Qualifier> qualifiersWithoutId = new ArrayList<Qualifier>();
        if (qualifier != null && qualifier.hasQualifiers()) {
            for (Qualifier innerQual : qualifier.getQualifiers()) {
                if (innerQual.hasQualifiers()) {
                    Qualifier[] internalQuals = QualifierUtils.excludeIdQualifier(innerQual.getQualifiers());
                    qualifiersWithoutId.add(QualifierUtils.combineMultipleQualifiers(innerQual.getOperation(), internalQuals));
                    continue;
                }
                if (innerQual.hasId()) continue;
                qualifiersWithoutId.add(innerQual);
            }
            return QualifierUtils.combineMultipleQualifiers(qualifier.getOperation() != null ? qualifier.getOperation() : FilterOperation.AND, (Qualifier[])qualifiersWithoutId.toArray(Qualifier[]::new));
        }
        if (qualifier != null && qualifier.hasId()) {
            return null;
        }
        return qualifier;
    }

    private static Qualifier combineMultipleQualifiers(FilterOperation operation, Qualifier[] qualifiers) {
        if (operation == FilterOperation.OR) {
            return Qualifier.or(qualifiers);
        }
        if (operation == FilterOperation.AND) {
            return Qualifier.and(qualifiers);
        }
        throw new UnsupportedOperationException("Only OR / AND operations are supported");
    }
}

