/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.BatchUtils;
import org.springframework.data.aerospike.core.ExceptionUtils;
import org.springframework.data.aerospike.core.MappingUtils;
import org.springframework.data.aerospike.core.PolicyUtils;
import org.springframework.data.aerospike.core.PostProcessingUtils;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.core.TemplateContext;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.core.ValidationUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.index.IndexesCacheRefresher;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.ReactorQueryEngine;
import org.springframework.data.aerospike.query.cache.ReactorIndexRefresher;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.aerospike.util.InfoCommandUtils;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikeTemplate
extends BaseAerospikeTemplate
implements ReactiveAerospikeOperations,
IndexesCacheRefresher<Mono<Integer>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveAerospikeTemplate.class);
    private static final Pattern INDEX_EXISTS_REGEX_PATTERN = Pattern.compile("^FAIL:(-?\\d+).*$");
    private final IAerospikeReactorClient reactorClient;
    private final ReactorQueryEngine reactorQueryEngine;
    private final ReactorIndexRefresher reactorIndexRefresher;
    private final TemplateContext templateContext;

    public ReactiveAerospikeTemplate(IAerospikeReactorClient reactorClient, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, ReactorQueryEngine queryEngine, ReactorIndexRefresher reactorIndexRefresher, ServerVersionSupport serverVersionSupport) {
        super(namespace, converter, mappingContext, exceptionTranslator, reactorClient.getAerospikeClient().copyWritePolicyDefault(), serverVersionSupport);
        Assert.notNull((Object)reactorClient, (String)"Aerospike reactor client must not be null!");
        this.reactorClient = reactorClient;
        this.reactorQueryEngine = queryEngine;
        this.reactorIndexRefresher = reactorIndexRefresher;
        this.templateContext = TemplateContext.builder().reactorClient(reactorClient).converter(converter).namespace(namespace).mappingContext((MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty>)mappingContext).exceptionTranslator(exceptionTranslator).writePolicyDefault(this.writePolicyDefault).batchWritePolicyDefault(this.batchWritePolicyDefault).reactorQueryEngine(queryEngine).build();
    }

    @Override
    public Mono<Integer> refreshIndexesCache() {
        return this.reactorIndexRefresher.refreshIndexes();
    }

    @Override
    public <T> Mono<T> save(T document) {
        Assert.notNull(document, (String)"Document for saving must not be null!");
        return this.save(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> save(T document, String setName) {
        Assert.notNull(document, (String)"Document for saving must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = PolicyUtils.expectGenerationCasAwarePolicy(data, this.templateContext.writePolicyDefault);
            Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
            return TemplateUtils.doPersistWithVersionAndHandleCasErrorReactively(document, data, writePolicy, operations, BaseAerospikeTemplate.OperationType.SAVE_OPERATION, this.templateContext);
        }
        WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE, this.templateContext.writePolicyDefault);
        Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return TemplateUtils.doPersistAndHandleErrorReactively(document, data, writePolicy, operations, this.templateContext);
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for saving");
            return Flux.empty();
        }
        return this.saveAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for saving");
            return Flux.empty();
        }
        return BatchUtils.applyReactiveBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.SAVE_OPERATION, this.templateContext);
    }

    @Override
    public <T> Mono<T> insert(T document) {
        return this.insert(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> insert(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.CREATE_ONLY, this.templateContext.writePolicyDefault);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return TemplateUtils.doPersistWithVersionAndHandleErrorReactively(document, data, writePolicy, operations, this.templateContext);
        }
        Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put);
        return TemplateUtils.doPersistAndHandleErrorReactively(document, data, writePolicy, operations, this.templateContext);
    }

    @Override
    public <T> Flux<T> insertAll(Iterable<T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for inserting");
            return Flux.empty();
        }
        return this.insertAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> insertAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for inserting");
            return Flux.empty();
        }
        return BatchUtils.applyReactiveBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.INSERT_OPERATION, this.templateContext);
    }

    @Override
    public <T> Mono<T> persist(T document, WritePolicy writePolicy) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)writePolicy, (String)"Policy must not be null!");
        return this.persist(document, writePolicy, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> persist(T document, WritePolicy writePolicy, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)writePolicy, (String)"Policy must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put);
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)new WritePolicy(writePolicy)).flatMap(writePolicyEnriched -> TemplateUtils.doPersistAndHandleErrorReactively(document, data, (WritePolicy)writePolicyEnriched, operations, this.templateContext));
    }

    @Override
    public <T> Mono<T> update(T document) {
        return this.update(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> update(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = PolicyUtils.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
            Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}), Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return TemplateUtils.doPersistWithVersionAndHandleCasErrorReactively(document, data, writePolicy, operations, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION, this.templateContext);
        }
        WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
        Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return TemplateUtils.doPersistAndHandleErrorReactively(document, data, writePolicy, operations, this.templateContext);
    }

    @Override
    public <T> Mono<T> update(T document, Collection<String> fields) {
        return this.update(document, this.getSetName((Object)document), fields);
    }

    @Override
    public <T> Mono<T> update(T document, String setName, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(fields, (String)"Fields must not be null!");
        AerospikeWriteData data = TemplateUtils.writeDataWithSpecificFields(document, setName, fields, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = PolicyUtils.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
            Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return TemplateUtils.doPersistWithVersionAndHandleCasErrorReactively(document, data, writePolicy, operations, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION, this.templateContext);
        }
        WritePolicy writePolicy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, this.templateContext.writePolicyDefault);
        Operation[] operations = TemplateUtils.operations(data.getBinsAsArray(), Operation::put);
        return TemplateUtils.doPersistAndHandleErrorReactively(document, data, writePolicy, operations, this.templateContext);
    }

    @Override
    public <T> Flux<T> updateAll(Iterable<T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for updating");
            return Flux.empty();
        }
        return this.updateAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> updateAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for updating");
            return Flux.empty();
        }
        return BatchUtils.applyReactiveBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION, this.templateContext);
    }

    @Override
    public <T> Mono<Boolean> delete(T document) {
        return this.delete(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<Boolean> delete(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(document, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)PolicyUtils.expectGenerationPolicy(data, this.templateContext.writePolicyDefault)).flatMap(writePolicyEnriched -> this.reactorClient.delete((WritePolicy)writePolicyEnriched, data.getKey())).hasElement().onErrorMap(e -> ExceptionUtils.translateCasThrowable(e, BaseAerospikeTemplate.OperationType.DELETE_OPERATION.toString(), this.templateContext));
        }
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)PolicyUtils.ignoreGenerationPolicy(this.templateContext.writePolicyDefault)).flatMap(writePolicyEnriched -> this.reactorClient.delete((WritePolicy)writePolicyEnriched, data.getKey())).hasElement().onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T> Mono<Void> delete(Query query, Class<T> entityClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Mono findQueryResults = this.find(query, entityClass, setName).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        return findQueryResults.flatMap(list -> {
            if (!list.isEmpty()) {
                return this.deleteAll((Iterable)list);
            }
            return Mono.empty();
        });
    }

    @Override
    public <T> Mono<Void> delete(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.delete(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<Void> deleteByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.deleteByIdsUsingQuery(ids, entityClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T> Mono<Void> deleteByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, String setName, @Nullable Query query) {
        Mono findQueryResults = this.findByIdsUsingQuery(ids, entityClass, entityClass, setName, query).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        return findQueryResults.flatMap(list -> {
            if (!list.isEmpty()) {
                return this.deleteAll((Iterable)list);
            }
            return Mono.empty();
        });
    }

    @Override
    public <T> Mono<Boolean> deleteById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteById(id, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> deleteById(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)PolicyUtils.ignoreGenerationPolicy(this.templateContext.writePolicyDefault)).flatMap(writePolicyEnriched -> this.reactorClient.delete((WritePolicy)writePolicyEnriched, TemplateUtils.getKey(id, setName, this.templateContext))).map(k -> true).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T> Mono<Void> deleteAll(Iterable<? extends T> documents) {
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for deleting");
            return Mono.empty();
        }
        return this.deleteAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Mono<Void> deleteAll(Iterable<? extends T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(documents)) {
            TemplateUtils.logEmptyItems(log, "Documents for deleting");
            return Mono.empty();
        }
        return BatchUtils.applyReactiveBatchWriteInChunks(documents, setName, BaseAerospikeTemplate.OperationType.DELETE_OPERATION, this.templateContext).then();
    }

    @Override
    @Deprecated
    public <T> Mono<Void> deleteExistingByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return Mono.empty();
        }
        return this.deleteExistingByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<Void> deleteByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return Mono.empty();
        }
        return this.deleteByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    @Deprecated
    public Mono<Void> deleteExistingByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return Mono.empty();
        }
        return BatchUtils.deleteByIdsReactively(ids, setName, false, this.templateContext);
    }

    @Override
    public Mono<Void> deleteByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ValidationUtils.isEmpty(ids)) {
            TemplateUtils.logEmptyItems(log, "Ids for deleting");
            return Mono.empty();
        }
        return BatchUtils.deleteByIdsReactively(ids, setName, true, this.templateContext);
    }

    @Override
    public Mono<Void> deleteByIds(GroupedKeys groupedKeys) {
        if (ValidationUtils.areInvalidGroupedKeys(groupedKeys)) {
            return Mono.empty();
        }
        return BatchUtils.deleteEntitiesByGroupedKeysReactively(groupedKeys, this.templateContext);
    }

    @Override
    public <T> Mono<Void> deleteAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteAll(this.getSetName((Class)entityClass), null);
    }

    @Override
    public <T> Mono<Void> deleteAll(Class<T> entityClass, Instant beforeLastUpdate) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteAll(this.getSetName((Class)entityClass), beforeLastUpdate);
    }

    @Override
    public Mono<Void> deleteAll(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.deleteAll(setName, null);
    }

    @Override
    public Mono<Void> deleteAll(String setName, Instant beforeLastUpdate) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Calendar beforeLastUpdateCalendar = MappingUtils.convertToCalendar(beforeLastUpdate);
        try {
            return Mono.fromRunnable(() -> this.reactorClient.getAerospikeClient().truncate(null, this.namespace, setName, beforeLastUpdateCalendar));
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> Mono<T> add(T document, Map<String, Long> values) {
        return this.add(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> add(T document, String setName, Map<String, Long> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        Operation[] operations = new Operation[values.size() + 1];
        int x = 0;
        for (Map.Entry<String, Long> entry : values.entrySet()) {
            operations[x] = new Operation(Operation.Type.ADD, entry.getKey(), Value.get((Object)entry.getValue()));
            ++x;
        }
        operations[x] = Operation.get();
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> TemplateUtils.executeOperationsReactivelyOnValue(document, data, (WritePolicy)writePolicyEnriched, operations, this.templateContext));
    }

    @Override
    public <T> Mono<T> add(T document, String binName, long value) {
        return this.add(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> add(T document, String setName, String binName, long value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        Operation[] operations = new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> TemplateUtils.executeOperationsReactivelyOnValue(document, data, (WritePolicy)writePolicyEnriched, operations, this.templateContext));
    }

    @Override
    public <T> Mono<T> append(T document, Map<String, String> values) {
        return this.append(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> append(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        Operation[] operations = TemplateUtils.operations(values, Operation.Type.APPEND, Operation.get());
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> TemplateUtils.executeOperationsReactivelyOnValue(document, data, (WritePolicy)writePolicyEnriched, operations, this.templateContext));
    }

    @Override
    public <T> Mono<T> append(T document, String binName, String value) {
        return this.append(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> append(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        Operation[] operations = new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> TemplateUtils.executeOperationsReactivelyOnValue(document, data, (WritePolicy)writePolicyEnriched, operations, this.templateContext));
    }

    @Override
    public <T> Mono<T> prepend(T document, Map<String, String> values) {
        return this.prepend(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> prepend(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        Operation[] operations = TemplateUtils.operations(values, Operation.Type.PREPEND, Operation.get());
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> TemplateUtils.executeOperationsReactivelyOnValue(document, data, (WritePolicy)writePolicyEnriched, operations, this.templateContext));
    }

    @Override
    public <T> Mono<T> prepend(T document, String binName, String value) {
        return this.prepend(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> prepend(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = TemplateUtils.writeData(document, setName, this.templateContext);
        Operation[] operations = new Operation[]{Operation.prepend((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> TemplateUtils.executeOperationsReactivelyOnValue(document, data, (WritePolicy)writePolicyEnriched, operations, this.templateContext));
    }

    @Override
    public <T> Mono<T> execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        return Mono.fromSupplier(supplier).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findById(id, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass, String setName) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = TemplateUtils.getKey(id, setName, this.templateContext);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return TemplateUtils.touchAndGetReactively(key, entity.getExpiration(), null, null, this.templateContext).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> MappingUtils.mapToEntity(keyRecord.key, entityClass, keyRecord.record, this.templateContext.converter)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
        }
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, this.reactorClient.getAerospikeClient().copyReadPolicyDefault()).flatMap(policy -> this.reactorClient.get(policy, key)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> MappingUtils.mapToEntity(keyRecord.key, entityClass, keyRecord.record, this.templateContext.converter)).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T, S> Mono<S> findById(Object id, Class<T> entityClass, Class<S> targetClass) {
        return this.findById(id, entityClass, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Mono<S> findById(Object id, Class<T> entityClass, Class<S> targetClass, String setName) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = TemplateUtils.getKey(id, setName, this.templateContext);
        String[] binNames = MappingUtils.getBinNamesFromTargetClass(targetClass, this.templateContext.mappingContext);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return TemplateUtils.touchAndGetReactively(key, entity.getExpiration(), binNames, null, this.templateContext).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> MappingUtils.mapToEntity(keyRecord.key, targetClass, keyRecord.record, this.templateContext.converter)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
        }
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, this.reactorClient.getAerospikeClient().copyReadPolicyDefault()).flatMap(policy -> this.reactorClient.get(policy, key, binNames)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> MappingUtils.mapToEntity(keyRecord.key, targetClass, keyRecord.record, this.templateContext.converter)).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIds(ids, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIds(ids, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> targetClass, String setName) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(targetClass, (String)"Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return BatchUtils.findByIdsWithoutPostProcessingReactively(Utils.iterableToList(ids), targetClass, null, setName, null, this.templateContext);
    }

    @Override
    public Mono<GroupedEntities> findByIds(GroupedKeys groupedKeys) {
        if (ValidationUtils.areInvalidGroupedKeys(groupedKeys)) {
            return Mono.just((Object)GroupedEntities.builder().build());
        }
        return BatchUtils.findGroupedEntitiesByGroupedKeysReactively(this.reactorClient.getAerospikeClient().copyBatchPolicyDefault(), groupedKeys, this.templateContext);
    }

    @Override
    public <T, S> Mono<?> findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, Query query) {
        return this.findByIdUsingQuery(id, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Mono<?> findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, String setName, Query query) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = TemplateUtils.getKey(id, setName, this.templateContext);
        String[] binNames = MappingUtils.getBinNamesFromTargetClass(targetClass, this.templateContext.mappingContext);
        Class<?> target = MappingUtils.getTargetClass(entityClass, targetClass);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return TemplateUtils.touchAndGetReactively(key, entity.getExpiration(), binNames, query, this.templateContext).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> MappingUtils.mapToEntity(keyRecord.key, target, keyRecord.record, this.templateContext.converter)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
        }
        Policy policy = null;
        if (QualifierUtils.isQueryCriteriaNotNull(query)) {
            policy = this.reactorClient.getAerospikeClient().copyReadPolicyDefault();
            Qualifier qualifier = query.getCriteriaObject();
            policy.filterExp = this.reactorQueryEngine.getFilterExpressionsBuilder().build(qualifier);
        }
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, policy).flatMap(rPolicy -> this.reactorClient.get(rPolicy, key, binNames)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> MappingUtils.mapToEntity(keyRecord.key, target, keyRecord.record, this.templateContext.converter)).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T, S> Flux<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, @Nullable Query query) {
        return this.findByIdsUsingQuery(ids, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Flux<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, String setName, @Nullable Query query) {
        Flux<?> results = BatchUtils.findByIdsWithoutPostProcessingReactively(ids, entityClass, targetClass, setName, query, this.templateContext);
        return PostProcessingUtils.applyPostProcessingOnResults(results, query);
    }

    public <T, S> Flux<?> findByIdsWithoutPostProcessing(Collection<?> ids, Class<T> entityClass, @Nullable Class<S> targetClass, @Nullable Query query) {
        return BatchUtils.findByIdsWithoutPostProcessingReactively(ids, entityClass, targetClass, this.getSetName((Class)entityClass), query, this.templateContext);
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.find(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> find(Query query, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.find(query, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> targetClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findWithPostProcessingReactively(setName, targetClass, query, this.templateContext);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.findAll(entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findAll(Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findAll(Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findReactively(setName, targetClass, this.templateContext);
    }

    @Override
    public <T> Flux<T> findAll(Sort sort, long offset, long limit, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAll(sort, offset, limit, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findAll(Sort sort, long offset, long limit, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(sort, offset, limit, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findAll(Sort sort, long offset, long limit, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findWithPostProcessingReactively(setName, targetClass, sort, offset, limit, this.templateContext);
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findInRange(offset, limit, sort, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findInRange(long offset, long limit, Sort sort, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findInRange(offset, limit, sort, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findWithPostProcessingReactively(setName, targetClass, sort, offset, limit, this.templateContext);
    }

    @Override
    public <T> Mono<Boolean> exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(id, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> exists(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Key key = TemplateUtils.getKey(id, setName, this.templateContext);
        return PolicyUtils.enrichPolicyWithTransaction(this.reactorClient, this.reactorClient.getAerospikeClient().copyReadPolicyDefault()).flatMap(policy -> this.reactorClient.exists(policy, key)).map(Objects::nonNull).defaultIfEmpty((Object)false).onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T> Mono<Boolean> exists(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(query, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> exists(Query query, String setName) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.findExistingKeyRecordsUsingQueryReactively(setName, query, this.templateContext).hasElements();
    }

    @Override
    public <T> Mono<Boolean> existsByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.existsByIdsUsingQuery(ids, this.getSetName((Class)entityClass), query);
    }

    @Override
    public Mono<Boolean> existsByIdsUsingQuery(Collection<?> ids, String setName, @Nullable Query query) {
        return BatchUtils.findByIdsUsingQueryWithoutEntityMappingReactively(ids, setName, query, this.templateContext).filter(keyRecord -> keyRecord != null && keyRecord.record != null).hasElements();
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.count(setName);
    }

    @Override
    public Mono<Long> count(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            return Mono.fromCallable(() -> TemplateUtils.countSet(setName, this.templateContext));
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
    }

    @Override
    public <T> Mono<Long> countByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.countByIdsUsingQuery(ids, this.getSetName((Class)entityClass), query);
    }

    @Override
    public Mono<Long> countByIdsUsingQuery(Collection<?> ids, String setName, @Nullable Query query) {
        return BatchUtils.findByIdsUsingQueryWithoutEntityMappingReactively(ids, setName, query, this.templateContext).filter(keyRecord -> keyRecord != null && keyRecord.record != null).count();
    }

    @Override
    public <T> Mono<Long> count(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.count(query, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Long> count(Query query, String setName) {
        Assert.notNull((Object)setName, (String)"Set for count must not be null!");
        return TemplateUtils.findExistingKeyRecordsUsingQueryReactively(setName, query, this.templateContext).count();
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        return this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.createIndex(entityClass, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        return this.createIndex(this.getSetName((Class)entityClass), indexName, binName, indexType, indexCollectionType, ctx);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType) {
        return this.createIndex(setName, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.createIndex(setName, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        Assert.notNull((Object)ctx, (String)"Ctx must not be null!");
        return this.reactorClient.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType, ctx).then(this.refreshIndexesCache()).then().onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public <T> Mono<Void> deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteIndex(this.getSetName((Class)entityClass), indexName);
    }

    @Override
    public Mono<Void> deleteIndex(String setName, String indexName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        return this.reactorClient.dropIndex(null, this.namespace, setName, indexName).then(this.refreshIndexesCache()).then().onErrorMap(e -> ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator));
    }

    @Override
    public Mono<Boolean> indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            Node[] nodes;
            for (Node node : nodes = this.reactorClient.getAerospikeClient().getNodes()) {
                if (!node.isActive()) continue;
                String response = InfoCommandUtils.request(this.reactorClient.getAerospikeClient(), node, "sindex-exists:ns=" + this.namespace + ";indexname=" + indexName);
                if (response == null) {
                    throw new AerospikeException("Null node response");
                }
                if (response.equalsIgnoreCase("true")) {
                    return Mono.just((Object)true);
                }
                if (response.equalsIgnoreCase("false")) {
                    return Mono.just((Object)false);
                }
                Matcher matcher = INDEX_EXISTS_REGEX_PATTERN.matcher(response);
                if (matcher.matches()) {
                    int reason;
                    try {
                        reason = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        throw new AerospikeException("Unexpected node response, unable to parse ResultCode: " + response);
                    }
                    if (reason == 20) continue;
                    throw new AerospikeException(reason);
                }
                throw new AerospikeException("Unexpected node response: " + response);
            }
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, this.templateContext.exceptionTranslator);
        }
        return Mono.just((Object)false);
    }

    @Override
    public IAerospikeReactorClient getAerospikeReactorClient() {
        return this.reactorClient;
    }

    @Override
    public long getQueryMaxRecords() {
        return this.reactorQueryEngine.getQueryMaxRecords();
    }

    @Override
    public <T, S> Flux<S> findUsingQueryWithoutPostProcessing(Class<T> entityClass, Class<S> targetClass, Query query) {
        ValidationUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        return TemplateUtils.findUsingQueryWithDistinctPredicateReactively(this.getSetName((Class)entityClass), targetClass, TemplateUtils.getDistinctPredicate(query), query, this.templateContext);
    }
}

