/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.BatchUtils;
import org.springframework.data.aerospike.core.ExceptionUtils;
import org.springframework.data.aerospike.core.MappingUtils;
import org.springframework.data.aerospike.core.PolicyUtils;
import org.springframework.data.aerospike.core.PostProcessingUtils;
import org.springframework.data.aerospike.core.QualifierUtils;
import org.springframework.data.aerospike.core.TemplateContext;
import org.springframework.data.aerospike.core.ValidationUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.KeyRecordIterator;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TemplateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateUtils.class);

    private TemplateUtils() {
        throw new UnsupportedOperationException("Utility class TemplateUtils cannot be instantiated");
    }

    private static <T> ConvertingPropertyAccessor<T> getPropertyAccessor(AerospikePersistentEntity<?> entity, T source, MappingAerospikeConverter converter) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)converter.getConversionService());
    }

    static <T> T updateVersion(T document, Record newAeroRecord, TemplateContext templateContext) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)templateContext.mappingContext.getRequiredPersistentEntity(document.getClass());
        ConvertingPropertyAccessor<T> propertyAccessor = TemplateUtils.getPropertyAccessor(entity, document, templateContext.converter);
        AerospikePersistentProperty versionProperty = (AerospikePersistentProperty)entity.getRequiredVersionProperty();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)newAeroRecord.generation);
        return document;
    }

    static void logEmptyItems(Logger log, String itemsDescription) {
        log.debug("{} are empty", (Object)itemsDescription);
    }

    static boolean doDeleteWithVersionAndHandleCasError(AerospikeWriteData data, TemplateContext templateContext) {
        try {
            WritePolicy writePolicy = PolicyUtils.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, templateContext.writePolicyDefault);
            writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(templateContext.client, (Policy)writePolicy);
            return templateContext.client.delete(writePolicy, data.getKey());
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateCasException(e, "Failed to delete record due to versions mismatch", templateContext.exceptionTranslator);
        }
    }

    static boolean doDeleteIgnoreVersionAndTranslateError(AerospikeWriteData data, TemplateContext templateContext) {
        try {
            WritePolicy policy = PolicyUtils.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY, templateContext.writePolicyDefault);
            WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(templateContext.client, (Policy)policy);
            return templateContext.client.delete(writePolicy, data.getKey());
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, templateContext.exceptionTranslator);
        }
    }

    static Record getRecord(AerospikePersistentEntity<?> entity, Key key, @Nullable Query query, TemplateContext templateContext) {
        Record aeroRecord;
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
            aeroRecord = TemplateUtils.touchAndGet(key, entity.getExpiration(), templateContext, null, null);
        } else {
            Policy policy = PolicyUtils.enrichPolicyWithTransaction(templateContext.client, PolicyUtils.getPolicyFilterExpOrDefault(templateContext.client, templateContext.queryEngine, query));
            aeroRecord = templateContext.client.get(policy, key);
        }
        return aeroRecord;
    }

    static <T> Object getRecordMapToTargetClass(AerospikePersistentEntity<?> entity, Key key, Class<T> targetClass, @Nullable Query query, TemplateContext templateContext) {
        Record aeroRecord;
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        String[] binNames = MappingUtils.getBinNamesFromTargetClass(targetClass, templateContext.mappingContext);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
            aeroRecord = TemplateUtils.touchAndGet(key, entity.getExpiration(), templateContext, binNames, query);
        } else {
            Policy policy = PolicyUtils.enrichPolicyWithTransaction(templateContext.client, PolicyUtils.getPolicyFilterExpOrDefault(templateContext.client, templateContext.queryEngine, query));
            aeroRecord = templateContext.client.get(policy, key, binNames);
        }
        return MappingUtils.mapToEntity(key, targetClass, aeroRecord, templateContext.converter);
    }

    private static Record touchAndGet(Key key, int expiration, TemplateContext templateContext, @Nullable String[] binNames, @Nullable Query query) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(templateContext.client.copyWritePolicyDefault()).expiration(expiration);
        if (org.springframework.data.aerospike.query.QualifierUtils.isQueryCriteriaNotNull(query)) {
            Qualifier qualifier = query.getCriteriaObject();
            writePolicyBuilder.filterExp(templateContext.queryEngine.getFilterExpressionsBuilder().build(qualifier));
        }
        WritePolicy writePolicy = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(templateContext.client, (Policy)writePolicyBuilder.build());
        try {
            if (binNames == null || binNames.length == 0) {
                return templateContext.client.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
            }
            Operation[] operations = new Operation[binNames.length + 1];
            operations[0] = Operation.touch();
            for (int i = 1; i < operations.length; ++i) {
                operations[i] = Operation.get((String)binNames[i - 1]);
            }
            return templateContext.client.operate(writePolicy, key, operations);
        }
        catch (AerospikeException aerospikeException) {
            if (aerospikeException.getResultCode() == 2) {
                return null;
            }
            throw aerospikeException;
        }
    }

    static <T> Stream<T> find(Class<T> targetClass, String setName, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return TemplateUtils.findRecordsUsingQuery(setName, targetClass, null, templateContext).map(keyRecord -> MappingUtils.mapToEntity(keyRecord, targetClass, templateContext.converter));
    }

    static <T> Stream<T> findWithPostProcessing(String setName, Class<T> targetClass, Query query, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        ValidationUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        Stream<T> results = TemplateUtils.findUsingQueryWithDistinctPredicate(setName, targetClass, TemplateUtils.getDistinctPredicate(query), query, templateContext);
        return PostProcessingUtils.applyPostProcessingOnResults(results, query);
    }

    static <T> Stream<T> findUsingQueryWithDistinctPredicate(String setName, Class<T> targetClass, Predicate<KeyRecord> distinctPredicate, Query query, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return TemplateUtils.findRecordsUsingQuery(setName, targetClass, query, templateContext).filter(distinctPredicate).map(keyRecord -> MappingUtils.mapToEntity(keyRecord, targetClass, templateContext.converter));
    }

    static Stream<KeyRecord> findExistingKeyRecordsUsingQuery(String setName, Query query, TemplateContext templateContext) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        Qualifier qualifier2 = qualifier = org.springframework.data.aerospike.query.QualifierUtils.isQueryCriteriaNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = org.springframework.data.aerospike.query.QualifierUtils.getIdQualifier(qualifier)) != null) {
            return BatchUtils.findByIdsWithoutEntityMapping(QualifierUtils.getIdValue(idQualifier), setName, null, new Query(QualifierUtils.excludeIdQualifier(qualifier)), templateContext);
        }
        KeyRecordIterator recIterator = templateContext.queryEngine.selectForCount(templateContext.namespace, setName, query);
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    static Record doPersistAndHandleError(AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        try {
            WritePolicy writePolicyEnriched = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(templateContext.client, (Policy)writePolicy);
            return templateContext.client.operate(writePolicyEnriched, data.getKey(), operations);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, templateContext.exceptionTranslator);
        }
    }

    static <T> void doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy writePolicy, boolean firstlyDeleteBins, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        try {
            Record newAeroRecord = TemplateUtils.putAndGetHeader(data, writePolicy, firstlyDeleteBins, templateContext);
            TemplateUtils.updateVersion(document, newAeroRecord, templateContext);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateCasException(e, "Failed to " + operationType.toString() + " record", templateContext.exceptionTranslator);
        }
    }

    static <T> void doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy writePolicy, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        try {
            Record newAeroRecord = TemplateUtils.putAndGetHeader(data, writePolicy, false, templateContext);
            TemplateUtils.updateVersion(document, newAeroRecord, templateContext);
        }
        catch (AerospikeException e) {
            throw ExceptionUtils.translateError(e, templateContext.exceptionTranslator);
        }
    }

    private static Record putAndGetHeader(AerospikeWriteData data, WritePolicy writePolicy, boolean firstlyDeleteBins, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        Key key = data.getKey();
        Operation[] operations = TemplateUtils.getPutAndGetHeaderOperations(data, firstlyDeleteBins);
        WritePolicy writePolicyEnriched = (WritePolicy)PolicyUtils.enrichPolicyWithTransaction(templateContext.client, (Policy)writePolicy);
        return templateContext.client.operate(writePolicyEnriched, key, operations);
    }

    static <T> Stream<T> findWithPostProcessing(String setName, Class<T> targetClass, Sort sort, long offset, long limit, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        ValidationUtils.verifyUnsortedWithOffset(sort, offset);
        Stream<T> results = TemplateUtils.find(targetClass, setName, templateContext);
        return PostProcessingUtils.applyPostProcessingOnResults(results, sort, offset, limit);
    }

    private static <T> Stream<KeyRecord> findRecordsUsingQuery(String setName, Class<T> targetClass, Query query, TemplateContext templateContext) {
        Qualifier idQualifier;
        Qualifier qualifier = org.springframework.data.aerospike.query.QualifierUtils.isQueryCriteriaNotNull(query) ? query.getCriteriaObject() : null;
        String[] binNames = MappingUtils.getBinNamesFromTargetClassOrNull(null, targetClass, templateContext.mappingContext);
        if (qualifier != null && (idQualifier = org.springframework.data.aerospike.query.QualifierUtils.getIdQualifier(qualifier)) != null) {
            return BatchUtils.findByIdsWithoutEntityMapping(QualifierUtils.getIdValue(idQualifier), setName, binNames, new Query(QualifierUtils.excludeIdQualifier(qualifier)), templateContext);
        }
        KeyRecordIterator recIterator = binNames != null ? templateContext.queryEngine.select(templateContext.namespace, setName, binNames, query) : templateContext.queryEngine.select(templateContext.namespace, setName, query);
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    static <T> Mono<T> executeOperationsReactivelyOnValue(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return templateContext.reactorClient.operate(writePolicy, data.getKey(), operations).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> MappingUtils.mapToEntity(keyRecord.key, MappingUtils.getEntityClass(document), keyRecord.record, templateContext.converter)).onErrorMap(e -> ExceptionUtils.translateError(e, templateContext.exceptionTranslator));
    }

    static long countSet(String setName, TemplateContext templateContext) {
        IAerospikeReactorClient reactorClient = templateContext.reactorClient;
        String namespace = templateContext.namespace;
        Node[] nodes = reactorClient.getAerospikeClient().getNodes();
        int replicationFactor = Utils.getReplicationFactor(reactorClient.getAerospikeClient(), nodes, namespace);
        long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(reactorClient.getAerospikeClient(), node, namespace, setName)).sum();
        return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
    }

    static Flux<KeyRecord> findExistingKeyRecordsUsingQueryReactively(String setName, Query query, TemplateContext templateContext) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        Qualifier qualifier2 = qualifier = org.springframework.data.aerospike.query.QualifierUtils.isQueryCriteriaNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = org.springframework.data.aerospike.query.QualifierUtils.getIdQualifier(qualifier)) != null) {
            return TemplateUtils.findByIdsWithoutEntityMappingReactively(QualifierUtils.getIdValue(idQualifier), setName, null, new Query(QualifierUtils.excludeIdQualifier(qualifier)), templateContext);
        }
        return templateContext.reactorQueryEngine.selectForCount(templateContext.namespace, setName, query);
    }

    static <T> Mono<T> doPersistAndHandleErrorReactively(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        IAerospikeReactorClient reactorClient = templateContext.reactorClient;
        return PolicyUtils.enrichPolicyWithTransaction(reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> reactorClient.operate((WritePolicy)writePolicyEnriched, data.getKey(), operations)).map(docKey -> document).onErrorMap(e -> ExceptionUtils.translateError(e, templateContext.exceptionTranslator));
    }

    static <T> Mono<T> doPersistWithVersionAndHandleCasErrorReactively(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations, BaseAerospikeTemplate.OperationType operationType, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return PolicyUtils.enrichPolicyWithTransaction(templateContext.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> TemplateUtils.putAndGetHeaderForReactive(data, (WritePolicy)writePolicyEnriched, operations, templateContext)).map(newRecord -> TemplateUtils.updateVersion(document, newRecord, templateContext)).onErrorMap(AerospikeException.class, i -> ExceptionUtils.translateCasException(i, "Failed to " + operationType.toString() + " record due to versions mismatch", templateContext.exceptionTranslator));
    }

    static <T> Mono<T> doPersistWithVersionAndHandleErrorReactively(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return PolicyUtils.enrichPolicyWithTransaction(templateContext.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> TemplateUtils.putAndGetHeaderForReactive(data, (WritePolicy)writePolicyEnriched, operations, templateContext)).map(newRecord -> TemplateUtils.updateVersion(document, newRecord, templateContext)).onErrorMap(e -> ExceptionUtils.translateError(e, templateContext.exceptionTranslator));
    }

    private static Mono<Record> putAndGetHeaderForReactive(AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations, TemplateContext templateContext) {
        return templateContext.reactorClient.operate(writePolicy, data.getKey(), operations).map(keyRecord -> keyRecord.record);
    }

    static Mono<KeyRecord> touchAndGetReactively(Key key, int expiration, String[] binNames, Query query, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(templateContext.writePolicyDefault).expiration(expiration);
        if (org.springframework.data.aerospike.query.QualifierUtils.isQueryCriteriaNotNull(query)) {
            Qualifier qualifier = query.getCriteriaObject();
            writePolicyBuilder.filterExp(templateContext.reactorQueryEngine.getFilterExpressionsBuilder().build(qualifier));
        }
        WritePolicy writePolicy = writePolicyBuilder.build();
        IAerospikeReactorClient reactorClient = templateContext.reactorClient;
        if (binNames == null || binNames.length == 0) {
            return PolicyUtils.enrichPolicyWithTransaction(reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> reactorClient.operate((WritePolicy)writePolicyEnriched, key, new Operation[]{Operation.touch(), Operation.get()}));
        }
        Operation[] operations = new Operation[binNames.length + 1];
        operations[0] = Operation.touch();
        for (int i = 1; i < operations.length; ++i) {
            operations[i] = Operation.get((String)binNames[i - 1]);
        }
        return PolicyUtils.enrichPolicyWithTransaction(reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> reactorClient.operate((WritePolicy)writePolicyEnriched, key, operations));
    }

    static <T> Flux<T> findWithPostProcessingReactively(String setName, Class<T> targetClass, Query query, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        ValidationUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        Flux<T> results = TemplateUtils.findUsingQueryWithDistinctPredicateReactively(setName, targetClass, TemplateUtils.getDistinctPredicate(query), query, templateContext);
        results = PostProcessingUtils.applyPostProcessingOnResults(results, query);
        return results;
    }

    static <T> Flux<T> findWithPostProcessingReactively(String setName, Class<T> targetClass, Sort sort, long offset, long limit, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        ValidationUtils.verifyUnsortedWithOffset(sort, offset);
        Flux<T> results = TemplateUtils.findReactively(setName, targetClass, templateContext);
        results = PostProcessingUtils.applyPostProcessingOnResults(results, sort, offset, limit);
        return results;
    }

    static <T> Flux<T> findReactively(String setName, Class<T> targetClass, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return TemplateUtils.findRecordsUsingQueryReactively(setName, targetClass, null, templateContext).map(keyRecord -> MappingUtils.mapToEntity(keyRecord, targetClass, templateContext.converter));
    }

    static <T> Flux<T> findUsingQueryWithDistinctPredicateReactively(String setName, Class<T> targetClass, Predicate<KeyRecord> distinctPredicate, Query query, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        return TemplateUtils.findRecordsUsingQueryReactively(setName, targetClass, query, templateContext).filter(distinctPredicate).map(keyRecord -> MappingUtils.mapToEntity(keyRecord, targetClass, templateContext.converter));
    }

    private static <T> Flux<KeyRecord> findRecordsUsingQueryReactively(String setName, Class<T> targetClass, Query query, TemplateContext templateContext) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = org.springframework.data.aerospike.query.QualifierUtils.isQueryCriteriaNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = org.springframework.data.aerospike.query.QualifierUtils.getIdQualifier(qualifier)) != null) {
            return TemplateUtils.findByIdsWithoutEntityMappingReactively(QualifierUtils.getIdValue(idQualifier), setName, targetClass, new Query(QualifierUtils.excludeIdQualifier(qualifier)), templateContext);
        }
        if (targetClass != null) {
            String[] binNames = MappingUtils.getBinNamesFromTargetClass(targetClass, templateContext.mappingContext);
            return templateContext.reactorQueryEngine.select(templateContext.namespace, setName, binNames, query);
        }
        return templateContext.reactorQueryEngine.select(templateContext.namespace, setName, null, query);
    }

    private static <T> Flux<KeyRecord> findByIdsWithoutEntityMappingReactively(Collection<?> ids, String setName, Class<T> targetClass, Query query, TemplateContext templateContext) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy batchPolicy = BatchUtils.getBatchPolicyForReactive(query, templateContext);
        Key[] keys = (Key[])MappingUtils.getKeys(Utils.iterableToList(ids), setName, templateContext).toArray(Key[]::new);
        return BatchUtils.batchReadInChunksReactively(batchPolicy, keys, targetClass, templateContext).filter(keyRecord -> keyRecord != null && keyRecord.record != null);
    }

    static <T> Comparator<T> getComparator(Query query) {
        return query.getSort().stream().map(TemplateUtils::getPropertyComparator).reduce(Comparator::thenComparing).orElseThrow(() -> new IllegalStateException("Comparator can not be created if sort orders are empty"));
    }

    static <T> Comparator<T> getComparator(Sort sort) {
        return sort.stream().map(TemplateUtils::getPropertyComparator).reduce(Comparator::thenComparing).orElseThrow(() -> new IllegalStateException("Comparator can not be created if sort orders are empty"));
    }

    private static <T> Comparator<T> getPropertyComparator(Sort.Order order) {
        boolean ignoreCase = true;
        boolean ascending = order.getDirection().isAscending();
        return new PropertyComparator(order.getProperty(), ignoreCase, ascending);
    }

    static <T> AerospikeWriteData writeData(T document, String setName, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        AerospikeWriteData data = AerospikeWriteData.forWrite(templateContext.namespace);
        data.setSetName(setName);
        templateContext.converter.write(document, data);
        return data;
    }

    static <T> AerospikeWriteData writeDataWithSpecificFields(T document, String setName, Collection<String> fields, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        AerospikeWriteData data = AerospikeWriteData.forWrite(templateContext.namespace);
        data.setSetName(setName);
        data.setRequestedBins(MappingUtils.fieldsToBinNames(document, fields, templateContext));
        templateContext.converter.write(document, data);
        return data;
    }

    static Key getKey(Object id, AerospikePersistentEntity<?> entity, TemplateContext templateContext) {
        return TemplateUtils.getKey(id, entity.getSetName(), templateContext);
    }

    static Key getKey(Object id, String setName, TemplateContext templateContext) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        if (templateContext.converter.getAerospikeDataSettings().isKeepOriginalKeyTypes()) {
            if (id instanceof Byte || id instanceof Short || id instanceof Integer || id instanceof Long) {
                return new Key(templateContext.namespace, setName, MappingUtils.convertIfNecessary(templateContext.converter, ((Number)id).longValue(), Long.class).longValue());
            }
            if (id instanceof Character) {
                return new Key(templateContext.namespace, setName, (int)MappingUtils.convertIfNecessary(templateContext.converter, id, Character.class).charValue());
            }
            if (id instanceof byte[]) {
                return new Key(templateContext.namespace, setName, MappingUtils.convertIfNecessary(templateContext.converter, id, byte[].class));
            }
        }
        return new Key(templateContext.namespace, setName, MappingUtils.convertIfNecessary(templateContext.converter, id, String.class));
    }

    static Operation[] getPutAndGetHeaderOperations(AerospikeWriteData data, boolean firstlyDeleteBins) {
        Bin[] bins = data.getBinsAsArray();
        if (bins.length == 0) {
            throw new AerospikeException("Cannot put and get header on a document with no bins and class bin disabled.");
        }
        return TemplateUtils.operations(bins, Operation::put, firstlyDeleteBins ? Operation.array((Operation[])new Operation[]{Operation.delete()}) : null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
    }

    static <T> Operation[] operations(Map<String, T> values, Operation.Type operationType, Operation ... additionalOperations) {
        Operation[] operations = new Operation[values.size() + additionalOperations.length];
        int x = 0;
        for (Map.Entry<String, T> entry : values.entrySet()) {
            operations[x] = new Operation(operationType, entry.getKey(), Value.get(entry.getValue()));
            ++x;
        }
        Operation[] operationArray = additionalOperations;
        int n = operationArray.length;
        for (int i = 0; i < n; ++i) {
            Operation additionalOp;
            operations[x] = additionalOp = operationArray[i];
            ++x;
        }
        return operations;
    }

    static Operation[] operations(Bin[] bins, Function<Bin, Operation> binToOperation) {
        return TemplateUtils.operations(bins, binToOperation, null, null);
    }

    static Operation[] operations(Bin[] bins, Function<Bin, Operation> binToOperation, Operation[] precedingOperations) {
        return TemplateUtils.operations(bins, binToOperation, precedingOperations, null);
    }

    static Operation[] operations(Bin[] bins, Function<Bin, Operation> binToOperation, @Nullable Operation[] precedingOperations, @Nullable Operation[] additionalOperations) {
        int n;
        int n2;
        Operation[] operationArray;
        int precedingOpsLength = precedingOperations == null ? 0 : precedingOperations.length;
        int additionalOpsLength = additionalOperations == null ? 0 : additionalOperations.length;
        Operation[] operations = new Operation[precedingOpsLength + bins.length + additionalOpsLength];
        int i = 0;
        if (precedingOpsLength > 0) {
            operationArray = precedingOperations;
            n2 = operationArray.length;
            for (n = 0; n < n2; ++n) {
                Operation operation;
                operations[i] = operation = operationArray[n];
                ++i;
            }
        }
        for (Operation operation : bins) {
            operations[i] = binToOperation.apply((Bin)operation);
            ++i;
        }
        if (additionalOpsLength > 0) {
            operationArray = additionalOperations;
            n2 = operationArray.length;
            for (n = 0; n < n2; ++n) {
                Operation operation;
                operations[i] = operation = operationArray[n];
                ++i;
            }
        }
        return operations;
    }

    static Predicate<KeyRecord> getDistinctPredicate(Query query) {
        Predicate<KeyRecord> distinctPredicate;
        if (query != null && query.isDistinct()) {
            List<String> dotPathList = query.getCriteriaObject().getDotPath();
            if (dotPathList != null && !dotPathList.isEmpty() && dotPathList.get(0) != null) {
                String dotPathString = String.join((CharSequence)",", query.getCriteriaObject().getDotPath());
                throw new UnsupportedOperationException("DISTINCT queries are currently supported only for the first level objects, got a query for " + dotPathString);
            }
            ConcurrentHashMap.KeySetView distinctValues = ConcurrentHashMap.newKeySet();
            distinctPredicate = kr -> {
                String distinctField = query.getCriteriaObject().getBinName();
                if (kr.record == null || kr.record.bins == null) {
                    return false;
                }
                return distinctValues.add(kr.record.bins.get(distinctField));
            };
        } else {
            distinctPredicate = kr -> true;
        }
        return distinctPredicate;
    }

    static <T, S> Stream<?> findByIdsUsingQueryWithPostProcessing(Iterable<?> ids, Class<T> entityClass, @Nullable Class<S> targetClass, String setName, @Nullable Query query, TemplateContext templateContext) {
        Assert.notNull((Object)templateContext, (String)"TemplateContext name must not be null!");
        Stream<?> results = BatchUtils.findByIdsWithoutPostProcessing(ids, entityClass, targetClass, setName, query, templateContext);
        return PostProcessingUtils.applyPostProcessingOnResults(results, query);
    }
}

