/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import java.util.List;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public final class ValidationUtils {
    private ValidationUtils() {
        throw new UnsupportedOperationException("Utility class ValidationUtils cannot be instantiated");
    }

    static boolean areInvalidGroupedKeys(GroupedKeys groupedKeys) {
        Assert.notNull((Object)groupedKeys, (String)"Grouped keys must not be null!");
        return ValidationUtils.isEmpty(groupedKeys.getEntitiesKeys().keySet());
    }

    static boolean isEmpty(Iterable<?> iterable) {
        Assert.notNull(iterable, (String)"Iterable must not be null!");
        return !iterable.iterator().hasNext();
    }

    static boolean hasOptimisticLockingError(int resultCode) {
        return List.of(Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(2)).contains(resultCode);
    }

    static void verifyUnsortedWithOffset(Sort sort, long offset) {
        if ((sort == null || sort.isUnsorted()) && offset > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
    }
}

