/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.query.Filter;
import com.aerospike.client.query.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.QueryContext;
import org.springframework.data.aerospike.query.cache.IndexesCache;
import org.springframework.data.aerospike.query.model.Index;
import org.springframework.data.aerospike.query.model.IndexedField;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class QueryContextBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryContextBuilder.class);
    private final IndexesCache indexesCache;

    public QueryContextBuilder(IndexesCache indexesCache) {
        this.indexesCache = indexesCache;
    }

    public QueryContext build(String namespace, String set, Query query) {
        return this.build(namespace, set, query, null);
    }

    public QueryContext build(String namespace, String set, @Nullable Query query, String[] binNames) {
        Statement stmt = new Statement();
        stmt.setNamespace(namespace);
        stmt.setSetName(set);
        if (binNames != null && binNames.length != 0) {
            stmt.setBinNames(binNames);
        }
        Qualifier processedParentQualifier = null;
        if (QualifierUtils.isQueryCriteriaNotNull(query)) {
            Utils.logQualifierDetails(query.getCriteriaObject(), log);
            processedParentQualifier = this.setFilterAndProcessQualifier(stmt, query.getCriteriaObject());
        }
        return new QueryContext(stmt, processedParentQualifier);
    }

    private Qualifier setFilterAndProcessQualifier(Statement stmt, Qualifier parentQualifier) {
        if (parentQualifier == null) {
            return null;
        }
        Qualifier resultQualifier = parentQualifier.getOperation() == FilterOperation.AND ? this.setFilterAndProcessCombinedQualifier(stmt, parentQualifier) : (this.isIndexedBin(stmt, parentQualifier) ? QueryContextBuilder.setFilterAndProcessSingleQualifier(stmt, parentQualifier) : parentQualifier);
        QueryContextBuilder.logFilterStatus(stmt, parentQualifier);
        return resultQualifier;
    }

    private Qualifier setFilterAndProcessCombinedQualifier(Statement stmt, Qualifier parentQualifier) {
        Qualifier qualifierChosenByCardinality = this.getMinBinValuesRatioQualifier(parentQualifier, stmt);
        if (qualifierChosenByCardinality != null) {
            Filter filter = qualifierChosenByCardinality.getSecondaryIndexFilter();
            stmt.setFilter(filter);
            return this.processCombinedQualifierWithCardinality(parentQualifier, qualifierChosenByCardinality, filter);
        }
        QualifiersWithFilter qualifiersWithFilter = this.processCombinedQualifierWithoutCardinality(parentQualifier, stmt);
        if (qualifiersWithFilter.filter() != null) {
            stmt.setFilter(qualifiersWithFilter.filter());
            return QueryContextBuilder.getNewParentQualifierForAND(parentQualifier, qualifiersWithFilter.innerQualifiers());
        }
        return parentQualifier;
    }

    private static void logFilterStatus(Statement stmt, Qualifier qualifier) {
        if (stmt.getFilter() != null) {
            log.debug("Query #{}, secondary index filter is set on the bin '{}'", (Object)qualifier.hashCode(), (Object)stmt.getFilter().getName());
        } else {
            log.debug("Query #{}, secondary index filter is not set", (Object)qualifier.hashCode());
        }
    }

    private static Qualifier setFilterAndProcessSingleQualifier(Statement stmt, Qualifier qualifier) {
        Filter filter = qualifier.getSecondaryIndexFilter();
        if (filter != null) {
            stmt.setFilter(filter);
            return null;
        }
        return qualifier;
    }

    private Qualifier processCombinedQualifierWithCardinality(Qualifier parentQualifier, Qualifier qualifierChosenByCardinality, Filter filter) {
        if (filter != null) {
            List<Qualifier> updatedQualifiers = QueryContextBuilder.getUpdatedInnerQualifiersWithCardinality(parentQualifier, qualifierChosenByCardinality);
            return QueryContextBuilder.getNewParentQualifierForAND(parentQualifier, updatedQualifiers);
        }
        return parentQualifier;
    }

    private Qualifier getMinBinValuesRatioQualifier(Qualifier parentQualifier, Statement stmt) {
        int minBinValuesRatio = Integer.MAX_VALUE;
        Qualifier minBinValuesRatioQualifier = null;
        for (Qualifier innerQualifier : parentQualifier.getQualifiers()) {
            int currBinValuesRatio;
            if (innerQualifier == null || !this.isIndexedBin(stmt, innerQualifier) || (currBinValuesRatio = this.getMinBinValuesRatioForQualifier(stmt, innerQualifier)) == 0 || currBinValuesRatio >= minBinValuesRatio) continue;
            minBinValuesRatio = currBinValuesRatio;
            minBinValuesRatioQualifier = innerQualifier;
        }
        return minBinValuesRatioQualifier;
    }

    private static Qualifier getNewParentQualifierForAND(Qualifier parentQualifier, List<Qualifier> newInnerQualifiers) {
        Qualifier newParentQualifier = Qualifier.and((Qualifier[])newInnerQualifiers.toArray(Qualifier[]::new));
        newParentQualifier.setDataSettings(parentQualifier.getDataSettings());
        return newParentQualifier;
    }

    private QualifiersWithFilter processCombinedQualifierWithoutCardinality(Qualifier parentQualifier, Statement stmt) {
        ArrayList<Qualifier> newInnerQualifiers = new ArrayList<Qualifier>();
        Filter filter = null;
        for (Qualifier innerQualifier : parentQualifier.getQualifiers()) {
            if (innerQualifier != null && this.isIndexedBin(stmt, innerQualifier) && (filter = innerQualifier.getSecondaryIndexFilter()) != null) {
                if (!FilterOperation.dualFilterOperations.contains((Object)innerQualifier.getOperation())) continue;
                newInnerQualifiers.add(innerQualifier);
                continue;
            }
            newInnerQualifiers.add(innerQualifier);
        }
        return new QualifiersWithFilter(newInnerQualifiers, filter);
    }

    private static List<Qualifier> getUpdatedInnerQualifiersWithCardinality(Qualifier parentQualifier, Qualifier minBinValuesRatioQualifier) {
        return Arrays.stream(parentQualifier.getQualifiers()).flatMap(innerQualifier -> {
            if (innerQualifier.hasQualifiers() && innerQualifier.getOperation() == FilterOperation.AND) {
                List<Qualifier> innerQualifiersToAdd = QueryContextBuilder.getUpdatedInnerQualifiersWithCardinality(innerQualifier, minBinValuesRatioQualifier);
                return innerQualifiersToAdd.stream();
            }
            return Stream.of(innerQualifier);
        }).filter(innerQualifier -> {
            if (innerQualifier.equals(minBinValuesRatioQualifier)) {
                return FilterOperation.dualFilterOperations.contains((Object)innerQualifier.getOperation());
            }
            return true;
        }).collect(Collectors.toList());
    }

    private boolean isIndexedBin(Statement stmt, Qualifier qualifier) {
        boolean hasIndexesForField = false;
        if (StringUtils.hasLength((String)qualifier.getBinName())) {
            hasIndexesForField = this.indexesCache.hasIndexFor(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getBinName()));
            if (log.isDebugEnabled()) {
                log.debug("Qualifier #{}, bin {}.{}.{} has secondary index(es): {}", new Object[]{qualifier.hashCode(), stmt.getNamespace(), stmt.getSetName(), qualifier.getBinName(), hasIndexesForField});
            }
        }
        return hasIndexesForField;
    }

    private int getMinBinValuesRatioForQualifier(Statement stmt, Qualifier qualifier) {
        List<Index> indexList = this.indexesCache.getAllIndexesForField(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getBinName()));
        Optional<Index> minBinValuesRatio = indexList.stream().filter(index -> index.getBinValuesRatio() != 0).min(Comparator.comparing(Index::getBinValuesRatio));
        return minBinValuesRatio.map(Index::getBinValuesRatio).orElse(0);
    }

    private record QualifiersWithFilter(List<Qualifier> innerQualifiers, @Nullable Filter filter) {
    }
}

