/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.config.AerospikeDataSettings;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.KeyRecordIterator;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.QueryContext;
import org.springframework.data.aerospike.query.QueryContextBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.lang.Nullable;

public class QueryEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryEngine.class);
    public static final String SCANS_DISABLED_MESSAGE = "Query without a secondary index filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scans-enabled` property.";
    public static final List<Integer> SEC_INDEX_ERROR_RESULT_CODES = List.of(Integer.valueOf(201), Integer.valueOf(202), Integer.valueOf(203), Integer.valueOf(204), Integer.valueOf(205), Integer.valueOf(206));
    private final IAerospikeClient client;
    private final QueryContextBuilder queryContextBuilder;
    private final FilterExpressionsBuilder filterExpressionsBuilder;
    private final AerospikeDataSettings dataSettings;
    private boolean scansEnabled;
    private long queryMaxRecords;

    public QueryEngine(IAerospikeClient client, QueryContextBuilder queryContextBuilder, FilterExpressionsBuilder filterExpressionsBuilder, AerospikeDataSettings dataSettings) {
        this.client = client;
        this.queryContextBuilder = queryContextBuilder;
        this.filterExpressionsBuilder = filterExpressionsBuilder;
        this.dataSettings = dataSettings;
    }

    public KeyRecordIterator select(String namespace, String set, @Nullable Query query) {
        return this.select(namespace, set, null, query);
    }

    public KeyRecordIterator select(String namespace, String set, String[] binNames, @Nullable Query query) {
        if (QualifierUtils.isQueryCriteriaNotNull(query) && query.getCriteriaObject() != null) {
            query.getCriteriaObject().setDataSettings(this.dataSettings);
        }
        QueryContext queryContext = this.queryContextBuilder.build(namespace, set, query, binNames);
        Statement statement = queryContext.statement();
        statement.setMaxRecords(this.queryMaxRecords);
        QueryPolicy localQueryPolicy = this.getQueryPolicy(queryContext.qualifier(), true);
        if (!this.scansEnabled && statement.getFilter() == null) {
            throw new IllegalStateException(SCANS_DISABLED_MESSAGE);
        }
        RecordSet rs = this.client.query(localQueryPolicy, statement);
        try {
            return new KeyRecordIterator(namespace, rs);
        }
        catch (AerospikeException e) {
            if (statement.getFilter() != null && SEC_INDEX_ERROR_RESULT_CODES.contains(e.getResultCode())) {
                log.warn("Got secondary index related exception (resultCode: {}), retrying with filter expression only (scan operation)", (Object)e.getResultCode());
                Qualifier qualifier = QualifierUtils.isQueryCriteriaNotNull(query) ? query.getCriteriaObject() : null;
                return this.retryWithFilterExpression(namespace, qualifier, statement);
            }
            throw e;
        }
    }

    private KeyRecordIterator retryWithFilterExpression(String namespace, Qualifier qualifier, Statement statement) {
        QueryPolicy localQueryPolicyFallback = this.getQueryPolicy(qualifier, true);
        statement.setFilter(null);
        RecordSet rs = this.client.query(localQueryPolicyFallback, statement);
        return new KeyRecordIterator(namespace, rs);
    }

    public KeyRecordIterator selectForCount(String namespace, String set, @Nullable Query query) {
        QueryContext queryContext = this.queryContextBuilder.build(namespace, set, query);
        Statement statement = queryContext.statement();
        statement.setMaxRecords(this.queryMaxRecords);
        Qualifier qualifier = queryContext.qualifier() != null ? queryContext.qualifier() : null;
        QueryPolicy localQueryPolicy = this.getQueryPolicy(qualifier, false);
        if (!this.scansEnabled && statement.getFilter() == null) {
            throw new IllegalStateException(SCANS_DISABLED_MESSAGE);
        }
        RecordSet rs = this.client.query(localQueryPolicy, statement);
        return new KeyRecordIterator(namespace, rs);
    }

    private QueryPolicy getQueryPolicy(Qualifier qualifier, boolean includeBins) {
        QueryPolicy queryPolicy = new QueryPolicy(this.client.getQueryPolicyDefault());
        queryPolicy.filterExp = this.filterExpressionsBuilder.build(qualifier);
        queryPolicy.includeBinData = includeBins;
        return queryPolicy;
    }

    @Generated
    public QueryContextBuilder getQueryContextBuilder() {
        return this.queryContextBuilder;
    }

    @Generated
    public FilterExpressionsBuilder getFilterExpressionsBuilder() {
        return this.filterExpressionsBuilder;
    }

    @Generated
    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    @Generated
    public void setQueryMaxRecords(long queryMaxRecords) {
        this.queryMaxRecords = queryMaxRecords;
    }

    @Generated
    public long getQueryMaxRecords() {
        return this.queryMaxRecords;
    }
}

