/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.core.PostProcessingUtils;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;

public class AerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final AerospikeTemplate template;

    public AerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodValueEvaluationContextAccessor evalContextAccessor, AerospikeTemplate template, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextAccessor, queryCreator, (AerospikeMappingContext)template.getMappingContext(), template.getAerospikeConverter(), template.getServerVersionSupport());
        this.template = template;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = AerospikePartTreeQuery.getTargetClass(accessor, this.queryMethod);
        if (parameters != null && parameters.length > 0) {
            Qualifier criteria = query.getCriteriaObject();
            if (criteria.hasSingleId()) {
                return this.runQueryWithIdsEquality(targetClass, org.springframework.data.aerospike.core.QualifierUtils.getIdValue(criteria), null, accessor.getPageable());
            }
            Qualifier idQualifier = QualifierUtils.getIdQualifier(criteria);
            if (idQualifier != null) {
                return this.runQueryWithIdsEquality(targetClass, org.springframework.data.aerospike.core.QualifierUtils.getIdValue(idQualifier), AerospikePartTreeQuery.getQueryWithExcludedIdQualifier(query, criteria), accessor.getPageable());
            }
        }
        if (AerospikePartTreeQuery.isExistsQuery(this.queryMethod)) {
            return this.template.exists(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (AerospikePartTreeQuery.isCountQuery(this.queryMethod)) {
            return this.template.count(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (AerospikePartTreeQuery.isDeleteQuery(this.queryMethod)) {
            this.template.delete(query, this.queryMethod.getEntityInformation().getJavaType());
            return Optional.empty();
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Stream<?> unprocessedResultsStream = this.template.findUsingQueryWithoutPostProcessing(this.entityClass, targetClass, query);
            return this.processPagedQuery(unprocessedResultsStream, accessor.getPageable(), query);
        }
        if (this.queryMethod.isStreamQuery()) {
            return this.findByQuery(query, targetClass);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.findByQuery(query, targetClass).collect(Collectors.toList());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Stream<?> result = this.findByQuery(query, targetClass);
            return result.findFirst().orElse(null);
        }
        throw new UnsupportedOperationException("Query method " + this.queryMethod.getNamedQueryName() + " is not supported");
    }

    private Stream<?> findByQuery(Query query, @Nullable Class<?> targetClass) {
        if (targetClass != null && targetClass != this.entityClass) {
            return this.template.find(query, this.entityClass, targetClass);
        }
        return this.template.find(query, this.entityClass);
    }

    @Override
    protected Object runQueryWithIdsEquality(Class<?> targetClass, List<Object> ids, @Nullable Query query, Pageable pageable) {
        if (AerospikePartTreeQuery.isExistsQuery(this.queryMethod)) {
            return this.template.existsByIdsUsingQuery(ids, this.entityClass, query);
        }
        if (AerospikePartTreeQuery.isCountQuery(this.queryMethod)) {
            return this.template.countByIdsUsingQuery(ids, this.entityClass, query);
        }
        if (AerospikePartTreeQuery.isDeleteQuery(this.queryMethod)) {
            this.template.deleteByIdsUsingQuery(ids, this.entityClass, query);
            return Optional.empty();
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            return this.processPaginatedIdQuery(targetClass, ids, pageable, query);
        }
        return this.template.findByIdsUsingQuery(ids, this.entityClass, targetClass, query).filter(Objects::nonNull);
    }

    private Slice<?> processPaginatedIdQuery(Class<?> targetClass, List<Object> ids, Pageable pageable, @Nullable Query query) {
        Stream<Object> unprocessedResultsStream = this.template.findByIdsWithoutPostProcessing(ids, this.entityClass, targetClass, query).filter(Objects::nonNull);
        return this.processPagedQuery(unprocessedResultsStream, pageable, query);
    }

    private Slice<?> processPagedQuery(Stream<?> unprocessedResultsStream, Pageable pageable, Query query) {
        if (this.queryMethod.isSliceQuery()) {
            return this.processSliceQuery(unprocessedResultsStream, pageable, query);
        }
        return this.processPageQuery(unprocessedResultsStream, pageable, query);
    }

    private Slice<?> processSliceQuery(Stream<?> unprocessedResultsStream, Pageable pageable, Query query) {
        boolean hasNext;
        if (pageable.isUnpaged()) {
            return new SliceImpl(unprocessedResultsStream.toList(), pageable, false);
        }
        Query limitedQueryPlusOne = query.limit(pageable.getPageSize() + 1);
        List limitedResultsPlusOne = PostProcessingUtils.applyPostProcessingOnResults(unprocessedResultsStream, limitedQueryPlusOne).collect(Collectors.toList());
        boolean bl = hasNext = limitedResultsPlusOne.size() > pageable.getPageSize();
        if (hasNext) {
            limitedResultsPlusOne = limitedResultsPlusOne.subList(0, pageable.getPageSize());
        }
        return new SliceImpl(limitedResultsPlusOne, pageable, hasNext);
    }

    private Page<?> processPageQuery(Stream<?> unprocessedResultsStream, Pageable pageable, Query query) {
        List<?> unprocessedResults = unprocessedResultsStream.toList();
        List<Object> resultsPage = pageable.isUnpaged() ? unprocessedResults : PostProcessingUtils.applyPostProcessingOnResults(unprocessedResults.stream(), query).toList();
        return new PageImpl(resultsPage, pageable, (long)unprocessedResults.size());
    }
}

