/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import java.util.List;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.BaseQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;

public class QueryQualifierBuilder
extends BaseQualifierBuilder<QualifierBuilder> {
    QueryQualifierBuilder() {
    }

    public QueryQualifierBuilder setInnerQbFilterOperation(FilterOperation operationType) {
        this.map.put(QualifierKey.FILTER_OPERATION, operationType);
        return this;
    }

    public QueryQualifierBuilder setIgnoreCase(boolean ignoreCase) {
        this.map.put(QualifierKey.IGNORE_CASE, ignoreCase);
        return this;
    }

    public QueryQualifierBuilder setBinName(String field) {
        this.map.put(QualifierKey.BIN_NAME, field);
        return this;
    }

    public QueryQualifierBuilder setBinType(Exp.Type type) {
        this.map.put(QualifierKey.BIN_TYPE, type);
        return this;
    }

    public QueryQualifierBuilder setDotPath(List<String> dotPath) {
        this.map.put(QualifierKey.DOT_PATH, dotPath);
        return this;
    }

    public QueryQualifierBuilder setCtxArray(CTX[] ctxArray) {
        this.map.put(QualifierKey.CTX_ARRAY, ctxArray);
        return this;
    }

    public QueryQualifierBuilder setKey(Value key) {
        this.map.put(QualifierKey.KEY, key);
        return this;
    }

    public QueryQualifierBuilder setNestedKey(Value key) {
        this.map.put(QualifierKey.NESTED_KEY, key);
        return this;
    }

    public QueryQualifierBuilder setNestedType(int type) {
        this.map.put(QualifierKey.NESTED_TYPE, type);
        return this;
    }

    public QueryQualifierBuilder setServerVersionSupport(ServerVersionSupport serverVersionSupport) {
        this.map.put(QualifierKey.SERVER_VERSION_SUPPORT, serverVersionSupport);
        return this;
    }

    public QueryQualifierBuilder setMapKeyPlaceholder() {
        this.map.put(QualifierKey.MAP_KEY_PLACEHOLDER, true);
        return this;
    }

    public boolean hasDotPath() {
        return this.map.get((Object)QualifierKey.DOT_PATH) != null;
    }

    public QueryQualifierBuilder setIsIdExpr(boolean value) {
        this.map.put(QualifierKey.IS_ID_EXPR, value);
        return this;
    }
}

