/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.aerospike.core.PostProcessingUtils;
import org.springframework.data.aerospike.core.ReactiveAerospikeTemplate;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final ReactiveAerospikeTemplate template;

    public ReactiveAerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodValueEvaluationContextAccessor evalContextAccessor, ReactiveAerospikeTemplate template, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextAccessor, queryCreator, (AerospikeMappingContext)template.getMappingContext(), template.getAerospikeConverter(), template.getServerVersionSupport());
        this.template = template;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = ReactiveAerospikePartTreeQuery.getTargetClass(accessor, this.queryMethod);
        if (parameters != null && parameters.length > 0) {
            Qualifier criteria = query.getCriteriaObject();
            if (criteria.hasSingleId()) {
                return this.runQueryWithIdsEquality(targetClass, org.springframework.data.aerospike.core.QualifierUtils.getIdValue(criteria), null, accessor.getPageable());
            }
            Qualifier idQualifier = QualifierUtils.getIdQualifier(criteria);
            if (idQualifier != null) {
                return this.runQueryWithIdsEquality(targetClass, org.springframework.data.aerospike.core.QualifierUtils.getIdValue(idQualifier), ReactiveAerospikePartTreeQuery.getQueryWithExcludedIdQualifier(query, criteria), accessor.getPageable());
            }
        }
        if (ReactiveAerospikePartTreeQuery.isExistsQuery(this.queryMethod)) {
            return this.template.exists(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (ReactiveAerospikePartTreeQuery.isCountQuery(this.queryMethod)) {
            return this.template.count(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (ReactiveAerospikePartTreeQuery.isDeleteQuery(this.queryMethod)) {
            this.template.delete(query, this.queryMethod.getEntityInformation().getJavaType());
            return Optional.empty();
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Pageable pageable = accessor.getPageable();
            Flux<?> unprocessedResults = this.template.findUsingQueryWithoutPostProcessing(this.entityClass, targetClass, query);
            return this.processPagedQuery(unprocessedResults, pageable, query);
        }
        if (this.queryMethod.isStreamQuery()) {
            return this.findByQuery(query, targetClass).toStream();
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.findByQuery(query, targetClass).collectList();
        }
        if (this.queryMethod.isQueryForEntity() || !ReactiveAerospikePartTreeQuery.isEntityAssignableFromReturnType(this.queryMethod)) {
            return this.findByQuery(query, targetClass);
        }
        throw new UnsupportedOperationException("Query method " + this.queryMethod.getNamedQueryName() + " is not supported");
    }

    private Flux<?> findByQuery(Query query, Class<?> targetClass) {
        if (targetClass != this.entityClass) {
            return this.template.find(query, this.entityClass, targetClass);
        }
        return this.template.find(query, this.entityClass);
    }

    @Override
    protected Object runQueryWithIdsEquality(Class<?> targetClass, List<Object> ids, Query query, Pageable pageable) {
        if (ReactiveAerospikePartTreeQuery.isExistsQuery(this.queryMethod)) {
            return this.template.existsByIdsUsingQuery(ids, this.entityClass, query);
        }
        if (ReactiveAerospikePartTreeQuery.isCountQuery(this.queryMethod)) {
            return this.template.countByIdsUsingQuery(ids, this.entityClass, query);
        }
        if (ReactiveAerospikePartTreeQuery.isDeleteQuery(this.queryMethod)) {
            return this.template.deleteByIdsUsingQuery(ids, this.entityClass, query);
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            return this.processPaginatedIdQuery(targetClass, ids, pageable, query);
        }
        return this.template.findByIdsUsingQuery(ids, this.entityClass, targetClass, query);
    }

    private Mono<?> processPaginatedIdQuery(Class<?> targetClass, List<Object> ids, Pageable pageable, Query query) {
        Flux unprocessedResultsStream = this.template.findByIdsWithoutPostProcessing(ids, this.entityClass, targetClass, query).filter(Objects::nonNull);
        return this.processPagedQuery(unprocessedResultsStream, pageable, query);
    }

    private Mono<?> processPagedQuery(Flux<?> unprocessedResults, Pageable pageable, Query query) {
        if (this.queryMethod.isSliceQuery()) {
            return this.processSliceQuery(unprocessedResults, pageable, query);
        }
        return this.processPageQuery(unprocessedResults, pageable, query);
    }

    private Mono<Slice<?>> processSliceQuery(Flux<?> unprocessedResults, Pageable pageable, Query query) {
        return unprocessedResults.collectList().map(list -> {
            boolean hasNext;
            if (list.isEmpty() || pageable.isUnpaged()) {
                return new SliceImpl(list, pageable, false);
            }
            Query limitedQueryPlusOne = query.limit(pageable.getPageSize() + 1);
            List limitedResultsPlusOne = PostProcessingUtils.applyPostProcessingOnResults(list.stream(), limitedQueryPlusOne).collect(Collectors.toList());
            boolean bl = hasNext = limitedResultsPlusOne.size() > pageable.getPageSize();
            if (hasNext) {
                limitedResultsPlusOne = limitedResultsPlusOne.subList(0, pageable.getPageSize());
            }
            return new SliceImpl(limitedResultsPlusOne, pageable, hasNext);
        });
    }

    private Mono<Page<?>> processPageQuery(Flux<?> unprocessedResults, Pageable pageable, Query query) {
        return unprocessedResults.collectList().map(list -> {
            List resultsPage = list.isEmpty() || pageable.isUnpaged() ? list : PostProcessingUtils.applyPostProcessingOnResults(list.stream(), query).toList();
            return new PageImpl(resultsPage, pageable, (long)list.size());
        });
    }
}

