/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.dragselectrecyclerview;

import android.content.Context;
import android.os.Handler;
import android.view.MotionEvent;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.RecyclerView;
import com.afollestad.dragselectrecyclerview.DragSelectReceiver;
import com.afollestad.dragselectrecyclerview.DragSelectTouchListener;
import com.afollestad.dragselectrecyclerview.ExtensionsKt;
import com.afollestad.dragselectrecyclerview.Mode;
import com.afollestad.dragselectrecyclerview.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f*\u0001\u0016\u0018\u0000 J2\u00020\u0001:\u0001JB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00109\u001a\u00020\u000fJ\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010;\u001a\u00020\u000fH\u0002J\u0018\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020?H\u0017J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u000bH\u0017J\u0018\u0010B\u001a\u00020\u000f2\u0006\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020?H\u0017J(\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u0019H\u0002J\u0016\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R=\u0010\t\u001a%\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\nj\u0004\u0018\u0001`\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u000e\u0010(\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u0002022\u0006\u00101\u001a\u000202@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/afollestad/dragselectrecyclerview/DragSelectTouchListener;", "Landroidx/recyclerview/widget/RecyclerView$OnItemTouchListener;", "context", "Landroid/content/Context;", "receiver", "Lcom/afollestad/dragselectrecyclerview/DragSelectReceiver;", "(Landroid/content/Context;Lcom/afollestad/dragselectrecyclerview/DragSelectReceiver;)V", "autoScrollHandler", "Landroid/os/Handler;", "autoScrollListener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "scrolling", "", "Lcom/afollestad/dragselectrecyclerview/AutoScrollListener;", "getAutoScrollListener", "()Lkotlin/jvm/functions/Function1;", "setAutoScrollListener", "(Lkotlin/jvm/functions/Function1;)V", "autoScrollRunnable", "com/afollestad/dragselectrecyclerview/DragSelectTouchListener$autoScrollRunnable$1", "Lcom/afollestad/dragselectrecyclerview/DragSelectTouchListener$autoScrollRunnable$1;", "autoScrollVelocity", "", "dragSelectActive", "hotspotBottomBoundEnd", "hotspotBottomBoundStart", "hotspotHeight", "getHotspotHeight", "()I", "setHotspotHeight", "(I)V", "hotspotOffsetBottom", "getHotspotOffsetBottom", "setHotspotOffsetBottom", "hotspotOffsetTop", "getHotspotOffsetTop", "setHotspotOffsetTop", "hotspotTopBoundEnd", "hotspotTopBoundStart", "inBottomHotspot", "inTopHotspot", "initialSelection", "isAutoScrolling", "lastDraggedIndex", "maxReached", "minReached", "mode", "Lcom/afollestad/dragselectrecyclerview/Mode;", "getMode", "()Lcom/afollestad/dragselectrecyclerview/Mode;", "setMode", "(Lcom/afollestad/dragselectrecyclerview/Mode;)V", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "disableAutoScroll", "notifyAutoScrollListener", "onDragSelectionStop", "onInterceptTouchEvent", "view", "event", "Landroid/view/MotionEvent;", "onRequestDisallowInterceptTouchEvent", "disallow", "onTouchEvent", "selectRange", "from", "to", "min", "max", "setIsActive", "active", "Companion", "com.afollestad.drag-select-recyclerview"})
public final class DragSelectTouchListener
implements RecyclerView.OnItemTouchListener {
    private final Handler autoScrollHandler;
    private final autoScrollRunnable.1 autoScrollRunnable;
    private int hotspotHeight;
    private int hotspotOffsetTop;
    private int hotspotOffsetBottom;
    @Nullable
    private Function1<? super Boolean, Unit> autoScrollListener;
    @NotNull
    private Mode mode;
    private RecyclerView recyclerView;
    private int lastDraggedIndex;
    private int initialSelection;
    private boolean dragSelectActive;
    private int minReached;
    private int maxReached;
    private int hotspotTopBoundStart;
    private int hotspotTopBoundEnd;
    private int hotspotBottomBoundStart;
    private int hotspotBottomBoundEnd;
    private boolean inTopHotspot;
    private boolean inBottomHotspot;
    private int autoScrollVelocity;
    private boolean isAutoScrolling;
    private final DragSelectReceiver receiver;
    private static final int AUTO_SCROLL_DELAY = 25;
    private static final boolean DEBUG_MODE = false;
    public static final Companion Companion = new Companion(null);

    public final int getHotspotHeight() {
        return this.hotspotHeight;
    }

    public final void setHotspotHeight(int n) {
        this.hotspotHeight = n;
    }

    public final int getHotspotOffsetTop() {
        return this.hotspotOffsetTop;
    }

    public final void setHotspotOffsetTop(int n) {
        this.hotspotOffsetTop = n;
    }

    public final int getHotspotOffsetBottom() {
        return this.hotspotOffsetBottom;
    }

    public final void setHotspotOffsetBottom(int n) {
        this.hotspotOffsetBottom = n;
    }

    @Nullable
    public final Function1<Boolean, Unit> getAutoScrollListener() {
        return this.autoScrollListener;
    }

    public final void setAutoScrollListener(@Nullable Function1<? super Boolean, Unit> function1) {
        this.autoScrollListener = function1;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        this.mode = mode;
        this.setIsActive(false, -1);
    }

    public final void disableAutoScroll() {
        this.hotspotHeight = -1;
        this.hotspotOffsetTop = -1;
        this.hotspotOffsetBottom = -1;
    }

    private final void notifyAutoScrollListener(boolean scrolling) {
        block1: {
            if (this.isAutoScrolling == scrolling) {
                return;
            }
            DragSelectTouchListener.Companion.log(scrolling ? "Auto scrolling is active" : "Auto scrolling is inactive");
            this.isAutoScrolling = scrolling;
            Function1<? super Boolean, Unit> function1 = this.autoScrollListener;
            if (function1 == null) break block1;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)scrolling);
        }
    }

    public final boolean setIsActive(boolean active, int initialSelection) {
        if (active && this.dragSelectActive) {
            DragSelectTouchListener.Companion.log("Drag selection is already active.");
            return false;
        }
        this.lastDraggedIndex = -1;
        this.minReached = -1;
        this.maxReached = -1;
        this.autoScrollHandler.removeCallbacks((Runnable)this.autoScrollRunnable);
        this.notifyAutoScrollListener(false);
        this.inTopHotspot = false;
        this.inBottomHotspot = false;
        if (!active) {
            this.initialSelection = -1;
            return false;
        }
        if (!this.receiver.isIndexSelectable(initialSelection)) {
            this.dragSelectActive = false;
            this.initialSelection = -1;
            DragSelectTouchListener.Companion.log("Index " + initialSelection + " is not selectable.");
            return false;
        }
        this.receiver.setSelected(initialSelection, true);
        this.dragSelectActive = active;
        this.initialSelection = initialSelection;
        this.lastDraggedIndex = initialSelection;
        DragSelectTouchListener.Companion.log("Drag selection initialized, starting at index " + initialSelection + '.');
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean onInterceptTouchEvent(@NotNull RecyclerView view, @NotNull MotionEvent event) {
        boolean result;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        RecyclerView.Adapter adapter = view.getAdapter();
        boolean adapterIsEmpty = adapter != null ? ExtensionsKt.isEmpty(adapter) : true;
        boolean bl = result = this.dragSelectActive && !adapterIsEmpty;
        if (result) {
            this.recyclerView = view;
            DragSelectTouchListener.Companion.log("RecyclerView height = " + view.getMeasuredHeight());
            if (this.hotspotHeight > -1) {
                this.hotspotTopBoundStart = this.hotspotOffsetTop;
                this.hotspotTopBoundEnd = this.hotspotOffsetTop + this.hotspotHeight;
                this.hotspotBottomBoundStart = view.getMeasuredHeight() - this.hotspotHeight - this.hotspotOffsetBottom;
                this.hotspotBottomBoundEnd = view.getMeasuredHeight() - this.hotspotOffsetBottom;
                DragSelectTouchListener.Companion.log("Hotspot top bound = " + this.hotspotTopBoundStart + " to " + this.hotspotTopBoundEnd);
                DragSelectTouchListener.Companion.log("Hotspot bottom bound = " + this.hotspotBottomBoundStart + " to " + this.hotspotBottomBoundEnd);
            }
        }
        if (result && event.getAction() == 1) {
            this.onDragSelectionStop();
        }
        return result;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onTouchEvent(@NotNull RecyclerView view, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getAction();
        int itemPosition = ExtensionsKt.getItemPosition(view, event);
        float y = event.getY();
        switch (action) {
            case 1: {
                this.onDragSelectionStop();
                return;
            }
            case 2: {
                if (this.hotspotHeight > -1) {
                    if (y >= (float)this.hotspotTopBoundStart && y <= (float)this.hotspotTopBoundEnd) {
                        this.inBottomHotspot = false;
                        if (!this.inTopHotspot) {
                            this.inTopHotspot = true;
                            DragSelectTouchListener.Companion.log("Now in TOP hotspot");
                            this.autoScrollHandler.removeCallbacks((Runnable)this.autoScrollRunnable);
                            this.autoScrollHandler.postDelayed((Runnable)this.autoScrollRunnable, (long)25);
                            this.notifyAutoScrollListener(true);
                        }
                        float simulatedFactor = this.hotspotTopBoundEnd - this.hotspotTopBoundStart;
                        float simulatedY = y - (float)this.hotspotTopBoundStart;
                        this.autoScrollVelocity = (int)(simulatedFactor - simulatedY) / 2;
                        DragSelectTouchListener.Companion.log("Auto scroll velocity = " + this.autoScrollVelocity);
                    } else if (y >= (float)this.hotspotBottomBoundStart && y <= (float)this.hotspotBottomBoundEnd) {
                        this.inTopHotspot = false;
                        if (!this.inBottomHotspot) {
                            this.inBottomHotspot = true;
                            DragSelectTouchListener.Companion.log("Now in BOTTOM hotspot");
                            this.autoScrollHandler.removeCallbacks((Runnable)this.autoScrollRunnable);
                            this.autoScrollHandler.postDelayed((Runnable)this.autoScrollRunnable, (long)25);
                            this.notifyAutoScrollListener(true);
                        }
                        float simulatedY = y + (float)this.hotspotBottomBoundEnd;
                        float simulatedFactor = this.hotspotBottomBoundStart + this.hotspotBottomBoundEnd;
                        this.autoScrollVelocity = (int)(simulatedY - simulatedFactor) / 2;
                        DragSelectTouchListener.Companion.log("Auto scroll velocity = " + this.autoScrollVelocity);
                    } else if (this.inTopHotspot || this.inBottomHotspot) {
                        DragSelectTouchListener.Companion.log("Left the hotspot");
                        this.autoScrollHandler.removeCallbacks((Runnable)this.autoScrollRunnable);
                        this.notifyAutoScrollListener(false);
                        this.inTopHotspot = false;
                        this.inBottomHotspot = false;
                    }
                }
                if (this.mode == Mode.PATH && itemPosition != -1) {
                    if (this.lastDraggedIndex == itemPosition) {
                        return;
                    }
                    this.lastDraggedIndex = itemPosition;
                    this.receiver.setSelected(this.lastDraggedIndex, !this.receiver.isSelected(this.lastDraggedIndex));
                    return;
                }
                if (this.mode == Mode.RANGE && itemPosition != -1 && this.lastDraggedIndex != itemPosition) {
                    this.lastDraggedIndex = itemPosition;
                    if (this.minReached == -1) {
                        this.minReached = this.lastDraggedIndex;
                    }
                    if (this.maxReached == -1) {
                        this.maxReached = this.lastDraggedIndex;
                    }
                    if (this.lastDraggedIndex > this.maxReached) {
                        this.maxReached = this.lastDraggedIndex;
                    }
                    if (this.lastDraggedIndex < this.minReached) {
                        this.minReached = this.lastDraggedIndex;
                    }
                    this.selectRange(this.initialSelection, this.lastDraggedIndex, this.minReached, this.maxReached);
                    if (this.initialSelection == this.lastDraggedIndex) {
                        this.minReached = this.lastDraggedIndex;
                        this.maxReached = this.lastDraggedIndex;
                    }
                }
                return;
            }
        }
    }

    private final void onDragSelectionStop() {
        this.dragSelectActive = false;
        this.inTopHotspot = false;
        this.inBottomHotspot = false;
        this.autoScrollHandler.removeCallbacks((Runnable)this.autoScrollRunnable);
        this.notifyAutoScrollListener(false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onRequestDisallowInterceptTouchEvent(boolean disallow) {
    }

    /*
     * WARNING - void declaration
     */
    private final void selectRange(int from, int to, int min, int max) {
        DragSelectReceiver dragSelectReceiver;
        DragSelectReceiver $receiver = dragSelectReceiver = this.receiver;
        boolean bl = false;
        if (from == to) {
            int n = min;
            int n2 = max;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (i != from) {
                        $receiver.setSelected((int)i, false);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return;
        }
        if (to < from) {
            int i = to;
            int n = from;
            if (i <= n) {
                while (true) {
                    $receiver.setSelected(i, true);
                    if (i == n) break;
                    ++i;
                }
            }
            if (min > -1 && min < to) {
                n = to;
                for (i = min; i < n; ++i) {
                    if (i == from) continue;
                    $receiver.setSelected(i, false);
                }
            }
            if (max > -1 && (i = from + 1) <= (n = max)) {
                while (true) {
                    $receiver.setSelected(i, false);
                    if (i != n) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int i = from;
            int n = to;
            if (i <= n) {
                while (true) {
                    $receiver.setSelected(i, true);
                    if (i == n) break;
                    ++i;
                }
            }
            if (max > -1 && max > to && (i = to + 1) <= (n = max)) {
                while (true) {
                    if (i != from) {
                        $receiver.setSelected(i, false);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if (min > -1) {
                n = from;
                for (i = min; i < n; ++i) {
                    $receiver.setSelected(i, false);
                }
            }
        }
    }

    private DragSelectTouchListener(Context context, DragSelectReceiver receiver) {
        this.receiver = receiver;
        this.autoScrollHandler = new Handler();
        this.autoScrollRunnable = new Runnable(this){
            final /* synthetic */ DragSelectTouchListener this$0;

            public void run() {
                if (DragSelectTouchListener.access$getInTopHotspot$p(this.this$0)) {
                    RecyclerView recyclerView = DragSelectTouchListener.access$getRecyclerView$p(this.this$0);
                    if (recyclerView != null) {
                        recyclerView.scrollBy(0, -DragSelectTouchListener.access$getAutoScrollVelocity$p(this.this$0));
                    }
                    DragSelectTouchListener.access$getAutoScrollHandler$p(this.this$0).postDelayed((Runnable)this, (long)25);
                } else if (DragSelectTouchListener.access$getInBottomHotspot$p(this.this$0)) {
                    RecyclerView recyclerView = DragSelectTouchListener.access$getRecyclerView$p(this.this$0);
                    if (recyclerView != null) {
                        recyclerView.scrollBy(0, DragSelectTouchListener.access$getAutoScrollVelocity$p(this.this$0));
                    }
                    DragSelectTouchListener.access$getAutoScrollHandler$p(this.this$0).postDelayed((Runnable)this, (long)25);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.hotspotHeight = ExtensionsKt.dimen(context, R.dimen.dsrv_defaultHotspotHeight);
        this.mode = Mode.RANGE;
        this.lastDraggedIndex = -1;
    }

    public static final /* synthetic */ boolean access$getInTopHotspot$p(DragSelectTouchListener $this) {
        return $this.inTopHotspot;
    }

    public static final /* synthetic */ void access$setInTopHotspot$p(DragSelectTouchListener $this, boolean bl) {
        $this.inTopHotspot = bl;
    }

    public static final /* synthetic */ RecyclerView access$getRecyclerView$p(DragSelectTouchListener $this) {
        return $this.recyclerView;
    }

    public static final /* synthetic */ void access$setRecyclerView$p(DragSelectTouchListener $this, RecyclerView recyclerView) {
        $this.recyclerView = recyclerView;
    }

    public static final /* synthetic */ int access$getAutoScrollVelocity$p(DragSelectTouchListener $this) {
        return $this.autoScrollVelocity;
    }

    public static final /* synthetic */ void access$setAutoScrollVelocity$p(DragSelectTouchListener $this, int n) {
        $this.autoScrollVelocity = n;
    }

    public static final /* synthetic */ Handler access$getAutoScrollHandler$p(DragSelectTouchListener $this) {
        return $this.autoScrollHandler;
    }

    public static final /* synthetic */ boolean access$getInBottomHotspot$p(DragSelectTouchListener $this) {
        return $this.inBottomHotspot;
    }

    public static final /* synthetic */ void access$setInBottomHotspot$p(DragSelectTouchListener $this, boolean bl) {
        $this.inBottomHotspot = bl;
    }

    public /* synthetic */ DragSelectTouchListener(Context context, DragSelectReceiver receiver, DefaultConstructorMarker $constructor_marker) {
        this(context, receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001b\b\u0002\u0010\r\u001a\u0015\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/afollestad/dragselectrecyclerview/DragSelectTouchListener$Companion;", "", "()V", "AUTO_SCROLL_DELAY", "", "DEBUG_MODE", "", "create", "Lcom/afollestad/dragselectrecyclerview/DragSelectTouchListener;", "context", "Landroid/content/Context;", "receiver", "Lcom/afollestad/dragselectrecyclerview/DragSelectReceiver;", "config", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "log", "msg", "", "com.afollestad.drag-select-recyclerview"})
    public static final class Companion {
        private final void log(String msg) {
        }

        @NotNull
        public final DragSelectTouchListener create(@NotNull Context context, @NotNull DragSelectReceiver receiver, @Nullable Function1<? super DragSelectTouchListener, Unit> config) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
            DragSelectTouchListener listener = new DragSelectTouchListener(context, receiver, null);
            if (config != null) {
                config.invoke((Object)listener);
            }
            return listener;
        }

        @NotNull
        public static /* synthetic */ DragSelectTouchListener create$default(Companion companion, Context context, DragSelectReceiver dragSelectReceiver, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = null;
            }
            return companion.create(context, dragSelectReceiver, (Function1<? super DragSelectTouchListener, Unit>)function1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

