/*
 * Decompiled with CFR 0.152.
 */
package com.afrozaar.wordpress.wpapi.v2;

import com.afrozaar.wordpress.wpapi.v2.Wordpress;
import com.afrozaar.wordpress.wpapi.v2.exception.InvalidParameterException;
import com.afrozaar.wordpress.wpapi.v2.exception.PageNotFoundException;
import com.afrozaar.wordpress.wpapi.v2.exception.ParsedRestException;
import com.afrozaar.wordpress.wpapi.v2.exception.PostCreateException;
import com.afrozaar.wordpress.wpapi.v2.exception.PostNotFoundException;
import com.afrozaar.wordpress.wpapi.v2.exception.TermNotFoundException;
import com.afrozaar.wordpress.wpapi.v2.exception.UserEmailAlreadyExistsException;
import com.afrozaar.wordpress.wpapi.v2.exception.UserNotFoundException;
import com.afrozaar.wordpress.wpapi.v2.exception.UsernameAlreadyExistsException;
import com.afrozaar.wordpress.wpapi.v2.exception.WpApiParsedException;
import com.afrozaar.wordpress.wpapi.v2.model.DeleteResponse;
import com.afrozaar.wordpress.wpapi.v2.model.Link;
import com.afrozaar.wordpress.wpapi.v2.model.Media;
import com.afrozaar.wordpress.wpapi.v2.model.Page;
import com.afrozaar.wordpress.wpapi.v2.model.Post;
import com.afrozaar.wordpress.wpapi.v2.model.PostMeta;
import com.afrozaar.wordpress.wpapi.v2.model.PostStatus;
import com.afrozaar.wordpress.wpapi.v2.model.RenderableField;
import com.afrozaar.wordpress.wpapi.v2.model.Taxonomy;
import com.afrozaar.wordpress.wpapi.v2.model.Term;
import com.afrozaar.wordpress.wpapi.v2.model.User;
import com.afrozaar.wordpress.wpapi.v2.request.Request;
import com.afrozaar.wordpress.wpapi.v2.request.SearchRequest;
import com.afrozaar.wordpress.wpapi.v2.response.CustomRenderableParser;
import com.afrozaar.wordpress.wpapi.v2.response.PagedResponse;
import com.afrozaar.wordpress.wpapi.v2.util.AuthUtil;
import com.afrozaar.wordpress.wpapi.v2.util.FieldExtractor;
import com.afrozaar.wordpress.wpapi.v2.util.MavenProperties;
import com.afrozaar.wordpress.wpapi.v2.util.Tuple2;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class Client
implements Wordpress {
    private static final String DEFAULT_CONTEXT = "/wp-json/wp/v2";
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private static final String META_KEY = "key";
    private static final String META_VALUE = "value";
    private static final String FORCE = "force";
    private static final String CONTEXT_ = "context";
    private static final String REASSIGN = "reassign";
    private static final String VIEW = "view";
    private static final String DATA = "data";
    private static final String VERSION = "version";
    private static final String ARTIFACT_ID = "artifactId";
    protected final RestTemplate restTemplate;
    private final Predicate<Link> next = link -> "next".equals(link.getRel());
    private final Predicate<Link> previous = link -> "prev".equals(link.getRel());
    private final Tuple2<String, String> userAgentTuple;
    public final String context;
    public final String baseUrl;
    public final String username;
    public final String password;
    public final boolean debug;
    public final boolean permalinkEndpoint;
    private Boolean canDeleteMetaViaPost = null;
    private BiFunction<Long, Long, Boolean> supportsMetaDeleteViaPostMethod;

    public Client(String baseUrl, String username, String password, boolean usePermalinkEndpoint, boolean debug) {
        this(null, baseUrl, username, password, usePermalinkEndpoint, debug, null);
    }

    public Client(String baseUrl, String username, String password, boolean usePermalinkEndpoint, boolean debug, ClientHttpRequestFactory requestFactory) {
        this(null, baseUrl, username, password, usePermalinkEndpoint, debug, requestFactory);
    }

    public Client(String context, String baseUrl, String username, String password, boolean usePermalinkEndpoint, boolean debug) {
        this(context, baseUrl, username, password, usePermalinkEndpoint, debug, null);
    }

    public Client(String context, String baseUrl, String username, String password, boolean usePermalinkEndpoint, boolean debug, ClientHttpRequestFactory requestFactory) {
        Properties properties = MavenProperties.getProperties();
        this.userAgentTuple = Tuple2.of("User-Agent", String.format("%s/%s", properties.getProperty(ARTIFACT_ID), properties.getProperty(VERSION)));
        this.supportsMetaDeleteViaPostMethod = (pid, mid) -> {
            if (Objects.nonNull(this.canDeleteMetaViaPost)) {
                return this.canDeleteMetaViaPost;
            }
            try {
                Function<Map, Boolean> expected = map -> {
                    boolean bl;
                    if (Objects.nonNull(map)) {
                        if (Stream.of("endpoints", "methods", "namespace").allMatch(map::containsKey) && Objects.equals(((ArrayList)map.get("methods")).get(0), "POST")) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                };
                ResponseEntity<Map> responseEntity = this.doExchange1("/posts/{postId}/meta/{metaId}/delete", HttpMethod.OPTIONS, Map.class, Client.forExpand(pid, mid), null, null);
                Map body = (Map)responseEntity.getBody();
                this.canDeleteMetaViaPost = responseEntity.getStatusCode().is2xxSuccessful() && expected.apply(body) != false;
                LOG.info("Wordpress instance at {} supports deleting meta via POST /posts/:pid/meta/:mid/delete : {}", (Object)this.baseUrl, (Object)this.canDeleteMetaViaPost);
                return this.canDeleteMetaViaPost;
            }
            catch (Exception jme) {
                this.canDeleteMetaViaPost = false;
                if (!(jme instanceof JsonMappingException)) {
                    LOG.error("Unexpected exception pinging for POST /posts/:pid/meta/:mid/delete", (Throwable)jme);
                }
                return this.canDeleteMetaViaPost;
            }
        };
        this.context = context;
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
        this.debug = debug;
        this.permalinkEndpoint = usePermalinkEndpoint;
        ObjectMapper emptyArrayAsNullObjectMapper = Jackson2ObjectMapperBuilder.json().featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT}).build();
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter());
        messageConverters.add(new ResourceHttpMessageConverter());
        messageConverters.add(new SourceHttpMessageConverter());
        messageConverters.add(new AllEncompassingFormHttpMessageConverter());
        messageConverters.add(new MappingJackson2HttpMessageConverter(emptyArrayAsNullObjectMapper));
        this.restTemplate = new RestTemplate(messageConverters);
        if (requestFactory != null) {
            this.restTemplate.setRequestFactory(requestFactory);
        }
    }

    @Override
    public String getContext() {
        return Optional.ofNullable(this.context).orElse(DEFAULT_CONTEXT);
    }

    @Override
    public Post createPost(Map<String, Object> postFields, PostStatus status) throws PostCreateException {
        ImmutableMap post = new ImmutableMap.Builder().putAll(postFields).put((Object)"status", (Object)status.value).build();
        try {
            return (Post)this.doExchange1("/posts", HttpMethod.POST, Post.class, Client.forExpand(new Object[0]), null, post, MediaType.APPLICATION_JSON).getBody();
        }
        catch (HttpClientErrorException e) {
            throw new PostCreateException(e);
        }
    }

    @Override
    public Post createPost(Post post, PostStatus status) throws PostCreateException {
        return this.createPost(this.fieldsFrom(post), status);
    }

    @Override
    public Post getPost(Long id) throws PostNotFoundException {
        return this.getPost(id, VIEW);
    }

    @Override
    public Post getPost(Long id, String context) throws PostNotFoundException {
        try {
            return (Post)this.doExchange1("/posts/{id}", HttpMethod.GET, Post.class, Client.forExpand(id), (Map<String, Object>)ImmutableMap.of((Object)CONTEXT_, (Object)context), null).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new PostNotFoundException((HttpStatusCodeException)e);
            }
            throw e;
        }
    }

    @Override
    public Post updatePost(Post post) {
        ResponseEntity<Post> exchange = this.doExchange1("/posts/{id}", HttpMethod.PUT, Post.class, Client.forExpand(post.getId()), (Map<String, Object>)ImmutableMap.of(), this.fieldsFrom(post));
        return (Post)exchange.getBody();
    }

    @Override
    public Post updatePostField(Long postId, String field, Object value) {
        return (Post)this.doExchange1("/posts/{id}", HttpMethod.PUT, Post.class, Client.forExpand(postId), null, ImmutableMap.of((Object)field, (Object)value)).getBody();
    }

    @Override
    public Post deletePost(Post post) {
        ResponseEntity<Post> exchange = this.doExchange1("/posts/{id}", HttpMethod.DELETE, Post.class, Client.forExpand(post.getId()), null, null);
        Preconditions.checkArgument((boolean)exchange.getStatusCode().is2xxSuccessful());
        return (Post)exchange.getBody();
    }

    @Override
    public <T> PagedResponse<T> search(SearchRequest<T> search) {
        URI uri = search.usingClient(this).build().toUri();
        return this.getPagedResponse(uri, search.getClazz());
    }

    @Override
    public Media createMedia(Media media, Resource resource) throws WpApiParsedException {
        Objects.requireNonNull(resource.getFilename(), "The resource used to create a media item does not provide a filename. Please supply a Resource that overrides getFilename().");
        try {
            LinkedMultiValueMap uploadMap = new LinkedMultiValueMap();
            BiConsumer<String, Object> p = (arg_0, arg_1) -> Client.lambda$createMedia$3((MultiValueMap)uploadMap, arg_0, arg_1);
            p.accept("title", FieldExtractor.extractField(Media::getTitle, media).orElse(null));
            p.accept("post", media.getPost());
            p.accept("alt_text", media.getAltText());
            p.accept("caption", media.getCaption());
            p.accept("description", media.getDescription());
            uploadMap.add((Object)"file", (Object)resource);
            return CustomRenderableParser.parseMedia((String)this.doExchange1("/media", HttpMethod.POST, String.class, Client.forExpand(new Object[0]), null, uploadMap).getBody());
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            throw WpApiParsedException.of((HttpStatusCodeException)e);
        }
    }

    @Override
    public Post setPostFeaturedMedia(Long postId, Media media) {
        Preconditions.checkArgument((boolean)"image".equals(media.getMediaType()), (Object)"Can not set non-image media type as a featured image on a post.");
        return this.updatePostField(postId, "featured_media", media.getId());
    }

    @Override
    public List<Media> getPostMedias(Long postId) {
        Media[] medias = CustomRenderableParser.parse((String)this.doExchange1("/media", HttpMethod.GET, String.class, Client.forExpand(new Object[0]), (Map<String, Object>)ImmutableMap.of((Object)"parent", (Object)postId, (Object)CONTEXT_, (Object)"edit"), null).getBody(), Media[].class);
        return Arrays.asList(medias);
    }

    @Override
    public List<Media> getMedia() {
        ArrayList<Media> collected = new ArrayList<Media>();
        PagedResponse<Media> pagedResponse = this.getPagedResponse("/media", Media.class, new String[0]);
        collected.addAll(pagedResponse.getList());
        while (pagedResponse.hasNext()) {
            pagedResponse = this.traverse(pagedResponse, PagedResponse.NEXT);
            collected.addAll(pagedResponse.getList());
        }
        return collected;
    }

    @Override
    public Media getMedia(Long id) {
        return this.getMedia(id, null);
    }

    @Override
    public Media getMedia(Long id, @Nullable String context) {
        ImmutableMap queryParams = ImmutableMap.of((Object)CONTEXT_, (Object)Optional.ofNullable(context).orElse("edit"));
        return CustomRenderableParser.parse(this.doExchange1("/media/{mediaId}", HttpMethod.GET, String.class, Client.forExpand(id), (Map<String, Object>)queryParams, null), Media.class);
    }

    @Override
    public Media updateMedia(Media media) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        BiConsumer<String, Object> p = (key, value) -> Optional.ofNullable(value).ifPresent(v -> builder.put(key, v));
        p.accept("title", FieldExtractor.extractField(Media::getTitle, media).orElse(null));
        p.accept("post", media.getPost());
        p.accept("alt_text", media.getAltText());
        p.accept("caption", media.getCaption());
        p.accept("description", media.getDescription());
        return CustomRenderableParser.parse(this.doExchange1("/media/{mediaId}", HttpMethod.POST, String.class, Client.forExpand(media.getId()), null, builder.build()), Media.class);
    }

    @Override
    public boolean deleteMedia(Media media, boolean force) {
        ResponseEntity<String> exchange = this.doExchange1("/media/{mediaId}", HttpMethod.DELETE, String.class, Client.forExpand(media.getId()), (Map<String, Object>)ImmutableMap.of((Object)FORCE, (Object)force), null);
        return exchange.getStatusCode().is2xxSuccessful();
    }

    @Override
    public boolean deleteMedia(Media media) {
        ResponseEntity<String> exchange = this.doExchange1("/media/{mediaId}", HttpMethod.DELETE, String.class, Client.forExpand(media.getId()), null, null);
        return exchange.getStatusCode().is2xxSuccessful();
    }

    @Override
    public PostMeta createMeta(Long postId, String key, String value) {
        ImmutableMap body = ImmutableMap.of((Object)META_KEY, (Object)key, (Object)META_VALUE, (Object)value);
        ResponseEntity<PostMeta> exchange = this.doExchange1("/posts/{postId}/meta", HttpMethod.POST, PostMeta.class, Client.forExpand(postId), null, body, MediaType.APPLICATION_JSON);
        return (PostMeta)exchange.getBody();
    }

    @Override
    public List<PostMeta> getPostMetas(Long postId) {
        ResponseEntity<PostMeta[]> exchange = this.doExchange1("/posts/{postId}/meta", HttpMethod.GET, PostMeta[].class, Client.forExpand(postId), null, null);
        return Arrays.asList((Object[])exchange.getBody());
    }

    @Override
    public PostMeta getPostMeta(Long postId, Long metaId) {
        ResponseEntity<PostMeta> exchange = this.doExchange1("/posts/{postId}/meta/{metaId}", HttpMethod.GET, PostMeta.class, Client.forExpand(postId, metaId), null, null);
        return (PostMeta)exchange.getBody();
    }

    @Override
    public PostMeta updatePostMetaValue(Long postId, Long metaId, String value) {
        return this.updatePostMeta(postId, metaId, null, value);
    }

    @Override
    public PostMeta updatePostMeta(Long postId, Long metaId, String key, String value) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        BiConsumer<String, Object> biConsumer = (key1, value1) -> Optional.ofNullable(value1).ifPresent(v -> builder.put(key1, v));
        biConsumer.accept(META_KEY, key);
        biConsumer.accept(META_VALUE, value);
        ResponseEntity<PostMeta> exchange = this.doExchange1("/posts/{postId}/meta/{metaId}", HttpMethod.POST, PostMeta.class, Client.forExpand(postId, metaId), null, builder.build());
        return (PostMeta)exchange.getBody();
    }

    @Override
    public boolean deletePostMeta(Long postId, Long metaId) {
        return this.deletePostMeta(postId, metaId, null);
    }

    @Override
    public boolean deletePostMeta(Long postId, Long metaId, Boolean force) {
        if (this.supportsMetaDeleteViaPostMethod.apply(postId, metaId).booleanValue()) {
            ResponseEntity<Map> result = this.doExchange1("/posts/{postId}/meta/{metaId}/delete", HttpMethod.POST, Map.class, Client.forExpand(postId, metaId), (Map<String, Object>)(Objects.isNull(force) ? null : ImmutableMap.of((Object)FORCE, (Object)force)), null);
            return result.getStatusCode().is2xxSuccessful() && "Deleted meta".equals(((Map)result.getBody()).get("message"));
        }
        ResponseEntity<Map> exchange = this.doExchange1("/posts/{postId}/meta/{metaId}", HttpMethod.DELETE, Map.class, Client.forExpand(postId, metaId), (Map<String, Object>)(Objects.isNull(force) ? null : ImmutableMap.of((Object)FORCE, (Object)force)), null);
        Preconditions.checkArgument((boolean)exchange.getStatusCode().is2xxSuccessful(), (Object)String.format("Expected success on post meta delete request: /posts/%s/meta/%s", postId, metaId));
        return exchange.getStatusCode().is2xxSuccessful();
    }

    @Override
    public List<Taxonomy> getTaxonomies() {
        ResponseEntity<Map> exchange = this.doExchange1("/taxonomies", HttpMethod.GET, Map.class, Client.forExpand(new Object[0]), null, null);
        Map body = (Map)exchange.getBody();
        ArrayList<Taxonomy> toReturn = new ArrayList<Taxonomy>();
        body.forEach((key, obj) -> {
            try {
                Taxonomy target = new Taxonomy();
                Map source = (Map)obj;
                BeanUtils.populate((Object)target, (Map)source);
                toReturn.add(target);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Error ", (Throwable)e);
            }
        });
        return toReturn;
    }

    @Override
    public Taxonomy getTaxonomy(String slug) {
        return (Taxonomy)this.doExchange1("/taxonomies/{slug}", HttpMethod.GET, Taxonomy.class, Client.forExpand(slug), null, null).getBody();
    }

    @Override
    public List<Term> getTerms(String taxonomy) {
        ArrayList<Term> collected = new ArrayList<Term>();
        PagedResponse<Term> pagedResponse = this.getPagedResponse("/terms/{taxonomySlug}", Term.class, taxonomy);
        collected.addAll(pagedResponse.getList());
        while (pagedResponse.hasNext()) {
            pagedResponse = this.traverse(pagedResponse, PagedResponse.NEXT);
            collected.addAll(pagedResponse.getList());
        }
        return collected;
    }

    @Override
    public Term getTerm(String taxonomy, Long id) throws TermNotFoundException {
        try {
            return (Term)this.doExchange1("/terms/{taxonomySlug}/{termId}", HttpMethod.GET, Term.class, Client.forExpand(taxonomy, id), null, null).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new TermNotFoundException(e);
            }
            throw e;
        }
    }

    @Override
    public Term updateTerm(String taxonomy, Term term) {
        return (Term)this.doExchange1("/terms/{taxonomySlug}/{termId}", HttpMethod.POST, Term.class, Client.forExpand(taxonomy, term.getId()), null, term.asMap()).getBody();
    }

    @Override
    public Term deleteTerm(String taxonomy, Term term) throws TermNotFoundException {
        try {
            return (Term)this.doExchange1("/terms/{taxonomySlug}/{termId}", HttpMethod.DELETE, Term.class, Client.forExpand(taxonomy, term.getId()), null, null).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new TermNotFoundException(e);
            }
            throw e;
        }
    }

    @Override
    public List<Term> deleteTerms(String taxonomy, Term ... terms) {
        ArrayList<Term> deletedTerms = new ArrayList<Term>(terms.length);
        for (Term term : terms) {
            try {
                deletedTerms.add(this.deleteTerm(taxonomy, term));
            }
            catch (TermNotFoundException e) {
                LOG.error("Error ", (Throwable)e);
            }
        }
        return deletedTerms;
    }

    @Override
    public Term createTag(Term tagTerm) throws WpApiParsedException {
        try {
            return (Term)this.doExchange1("/tags", HttpMethod.POST, Term.class, Client.forExpand(new Object[0]), tagTerm.asMap(), null).getBody();
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            WpApiParsedException exception = WpApiParsedException.of((HttpStatusCodeException)e);
            LOG.error("Could not create tag '{}'. {} ", new Object[]{tagTerm.getName(), exception.getMessage(), exception});
            throw exception;
        }
    }

    @Override
    public List<Term> getTags() {
        return this.getAllTermsForEndpoint("/tags", new String[0]);
    }

    @Override
    public Term getTag(Long id) throws TermNotFoundException {
        try {
            return (Term)this.doExchange1("/tags/{tagId}", HttpMethod.GET, Term.class, Client.forExpand(id), null, null).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new TermNotFoundException(e);
            }
            throw e;
        }
    }

    @Override
    public Term deleteTag(Term tagTerm) throws TermNotFoundException {
        return this.deleteTag(tagTerm, false);
    }

    @Override
    public Term deleteTag(Term tagTerm, boolean force) throws TermNotFoundException {
        try {
            ImmutableMap queryParams = force ? ImmutableMap.of((Object)FORCE, (Object)true) : null;
            ResponseEntity<String> tResponseEntity = this.doExchange1("/tags/{tagId}", HttpMethod.DELETE, String.class, Client.forExpand(tagTerm.getId()), (Map<String, Object>)queryParams, null);
            DeleteResponse<Term> termDeleteResponse = CustomRenderableParser.parseDeleteResponse(tResponseEntity, Term.class);
            Term previous = termDeleteResponse.getPrevious();
            LOG.debug("Deleted term @{}/'{}' of taxonomy '{}': {}", new Object[]{previous.getId(), previous.getName(), previous.getTaxonomySlug(), termDeleteResponse.getDeleted()});
            return previous;
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new TermNotFoundException(e);
            }
            throw e;
        }
    }

    @Override
    public Term createPostTag(Post post, Term tag) throws WpApiParsedException {
        Term termToUse = Objects.nonNull(tag.getId()) ? tag : this.createTag(tag);
        ArrayList<Term> postTags = new ArrayList<Term>(this.getPostTags(post));
        postTags.add(termToUse);
        List tagIds = postTags.stream().map(Term::getId).collect(Collectors.toList());
        this.updatePostField(post.getId(), "tags", tagIds);
        return termToUse;
    }

    @Override
    public List<Term> getPostTags(Post post) {
        return this.getAllTermsForEndpoint("/tags?post={postId}", post.getId().toString());
    }

    @Override
    public Term deletePostTag(Post post, Term tagTerm, boolean force) throws TermNotFoundException {
        try {
            ArrayList<Term> postTags = new ArrayList<Term>(this.getPostTags(post));
            Optional<Term> found = postTags.stream().filter(term -> Objects.equals(term.getId(), tagTerm.getId())).findFirst();
            if (found.isPresent()) {
                postTags.remove(found.get());
                this.updatePostField(post.getId(), "tags", termIds.apply(postTags));
                return tagTerm;
            }
            throw new RuntimeException("Expected to find term in post's term list.");
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new TermNotFoundException(e);
            }
            throw e;
        }
    }

    @Override
    public Term getPostTag(Post post, Term tagTerm) throws TermNotFoundException {
        try {
            return (Term)this.doExchange1("/posts/{postId}/{taxonomy}/{termId}", HttpMethod.GET, Term.class, Client.forExpand(post.getId(), "tags", tagTerm.getId()), null, null).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new TermNotFoundException(e);
            }
            throw e;
        }
    }

    @Override
    public Term updateTag(Term tag) {
        return (Term)this.doExchange1("/tags/{tagId}", HttpMethod.POST, Term.class, Client.forExpand(tag.getId()), null, tag.asMap()).getBody();
    }

    @Override
    public Term getCategory(Long id) {
        return (Term)this.doExchange1("/categories/{categoryId}", HttpMethod.GET, Term.class, Client.forExpand(id), null, null).getBody();
    }

    @Override
    public List<Term> getCategories() {
        return this.getAllTermsForEndpoint("/categories", new String[0]);
    }

    private List<Term> getAllTermsForEndpoint(String endpoint, String ... expandParams) {
        ArrayList<Term> collected = new ArrayList<Term>();
        PagedResponse<Term> pagedResponse = this.getPagedResponse(endpoint, Term.class, expandParams);
        collected.addAll(pagedResponse.getList());
        while (pagedResponse.hasNext()) {
            pagedResponse = this.traverse(pagedResponse, PagedResponse.NEXT);
            collected.addAll(pagedResponse.getList());
        }
        return collected;
    }

    @Override
    public Term createCategory(Term categoryTerm) {
        return (Term)this.doExchange1("/categories", HttpMethod.POST, Term.class, Client.forExpand(new Object[0]), null, categoryTerm.asMap(), MediaType.APPLICATION_JSON).getBody();
    }

    @Override
    public Term deleteCategory(Term categoryTerm) throws TermNotFoundException {
        return this.deleteCategory(categoryTerm, false);
    }

    @Override
    public Term deleteCategory(Term categoryTerm, boolean force) throws TermNotFoundException {
        try {
            ImmutableMap queryParams = force ? ImmutableMap.of((Object)FORCE, (Object)true) : null;
            return (Term)this.doExchange1("/categories/{categoryId}", HttpMethod.DELETE, Term.class, Client.forExpand(categoryTerm.getId()), (Map<String, Object>)queryParams, null).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new TermNotFoundException(e);
            }
            throw e;
        }
    }

    @Override
    public List<Term> deleteCategories(Term ... terms) {
        return this.deleteCategories(false, terms);
    }

    @Override
    public List<Term> deleteCategories(boolean force, Term ... terms) {
        ArrayList<Term> deletedTerms = new ArrayList<Term>(terms.length);
        for (Term term : terms) {
            try {
                deletedTerms.add(this.deleteCategory(term, force));
            }
            catch (TermNotFoundException e) {
                LOG.error("Error ", (Throwable)e);
            }
        }
        return deletedTerms;
    }

    @Override
    public Page createPage(Page page, PostStatus status) {
        Map<String, Object> map = page.asMap();
        ImmutableMap pageFields = new ImmutableMap.Builder().putAll(map).put((Object)"status", (Object)status.value).build();
        return (Page)this.doExchange1("/pages", HttpMethod.POST, Page.class, Client.forExpand(new Object[0]), null, pageFields).getBody();
    }

    @Override
    public Page getPage(Long pageId) throws PageNotFoundException {
        try {
            return this.getPage(pageId, VIEW);
        }
        catch (HttpClientErrorException e) {
            throw new PageNotFoundException((HttpStatusCodeException)e);
        }
    }

    @Override
    public Page getPage(Long pageId, String context) {
        return (Page)this.doExchange1("/pages/{pageId}", HttpMethod.GET, Page.class, Client.forExpand(pageId), (Map<String, Object>)ImmutableMap.of((Object)CONTEXT_, (Object)context), null).getBody();
    }

    @Override
    public Page updatePage(Page page) {
        return (Page)this.doExchange1("/pages/{pageId}", HttpMethod.POST, Page.class, Client.forExpand(page.getId()), null, page.asMap()).getBody();
    }

    @Override
    public Page deletePage(Page page) {
        return (Page)this.doExchange1("/pages/{pageId}", HttpMethod.DELETE, Page.class, Client.forExpand(page.getId()), null, null).getBody();
    }

    @Override
    public Page deletePage(Page page, boolean force) {
        return (Page)this.doExchange1("/pages/{pageId}", HttpMethod.DELETE, Page.class, Client.forExpand(page.getId()), (Map<String, Object>)ImmutableMap.of((Object)FORCE, (Object)force), null).getBody();
    }

    @Override
    public List<User> getUsers() {
        return this.getUsers(VIEW);
    }

    @Override
    public List<User> getUsers(String contextType) {
        ArrayList<User> collected = new ArrayList<User>();
        PagedResponse<User> usersResponse = this.getPagedResponse("/users?context={context}", User.class, contextType);
        collected.addAll(usersResponse.getList());
        while (usersResponse.hasNext()) {
            usersResponse = this.traverse(usersResponse, PagedResponse.NEXT);
            collected.addAll(usersResponse.getList());
        }
        return collected;
    }

    @Override
    public User createUser(User user, String username, String password) throws WpApiParsedException {
        MultiValueMap userAsMap = (MultiValueMap)userMap.apply(user);
        userAsMap.add((Object)"username", (Object)username);
        userAsMap.add((Object)"password", (Object)password);
        try {
            return (User)this.doExchange1("/users", HttpMethod.POST, User.class, Client.forExpand(new Object[0]), null, userAsMap).getBody();
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            try {
                ParsedRestException restException = ParsedRestException.of((HttpStatusCodeException)e);
                switch (restException.getCode()) {
                    case "rest_invalid_param": {
                        throw new InvalidParameterException(restException);
                    }
                    case "existing_user_login": {
                        throw new UsernameAlreadyExistsException(restException);
                    }
                    case "existing_user_email": {
                        throw new UserEmailAlreadyExistsException(restException);
                    }
                }
            }
            catch (RuntimeException rte) {
                LOG.info("error parsing {}", (Object)e.getResponseBodyAsString(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public User getUser(long userId) throws UserNotFoundException {
        return this.getUser(userId, null);
    }

    @Override
    public User getUser(long userId, String context) throws UserNotFoundException {
        ImmutableMap params = context == null ? null : ImmutableMap.of((Object)CONTEXT_, (Object)context);
        try {
            return (User)this.doExchange1("/users/{userId}", HttpMethod.GET, User.class, Client.forExpand(userId), (Map<String, Object>)params, null).getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().is4xxClientError() && e.getStatusCode().value() == 404) {
                throw new UserNotFoundException((HttpStatusCodeException)e);
            }
            throw e;
        }
    }

    @Override
    public User deleteUser(User user) {
        return this.deleteUser(user, null);
    }

    @Override
    public User deleteUser(User user, Long reassign) {
        try {
            return (User)this.doExchange1("/users/{userId}", HttpMethod.DELETE, User.class, Client.forExpand(user.getId()), (Map<String, Object>)ImmutableMap.of((Object)FORCE, (Object)true, (Object)REASSIGN, (Object)(Objects.nonNull(reassign) ? reassign : 1L)), null).getBody();
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            WpApiParsedException of = WpApiParsedException.of((HttpStatusCodeException)e);
            LOG.error("Error Deleting user {}", (Object)user.getId(), (Object)of);
            throw new RuntimeException(of);
        }
    }

    @Override
    public User updateUser(User user) {
        return (User)this.doExchange1("/users/{userId}", HttpMethod.POST, User.class, Client.forExpand(user.getId()), null, userMap.apply(user)).getBody();
    }

    @Override
    public <T> PagedResponse<T> getPagedResponse(String context, Class<T> typeRef, String ... expandParams) {
        URI uri = Request.of(context).usingClient(this).buildAndExpand((Object[])expandParams).toUri();
        return this.getPagedResponse(uri, typeRef);
    }

    @Override
    public <T> PagedResponse<T> getPagedResponse(URI uri, Class<T> typeRef) {
        try {
            ResponseEntity<String> exchange = this.doExchange0(HttpMethod.GET, uri, String.class, null, null);
            String body1 = (String)exchange.getBody();
            Object[] parse = (Object[])CustomRenderableParser.parse(body1, Class.forName("[L" + typeRef.getName() + ";"));
            HttpHeaders headers = exchange.getHeaders();
            List<Link> links = this.parseLinks(headers);
            List<Object> body = Arrays.asList(parse);
            return PagedResponse.Builder.aPagedResponse(typeRef).withPages(headers).withPosts(body).withSelf(uri.toASCIIString()).withNext(this.link(links, this.next)).withPrevious(this.link(links, this.previous)).build();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> PagedResponse<T> traverse(PagedResponse<T> response, Function<PagedResponse<?>, String> direction) {
        URI uri = response.getUri(direction);
        return this.getPagedResponse(uri, response.getClazz());
    }

    public List<Link> parseLinks(HttpHeaders headers) {
        Optional<List> linkHeader = Optional.ofNullable(headers.get((Object)"Link"));
        return linkHeader.map(Collection::stream).map(Stream::findFirst).map(rawResponse -> {
            String[] links = ((String)rawResponse.get()).split(", ");
            return Arrays.stream(links).map(link -> {
                String[] linkData = link.split("; ");
                String href = linkData[0].replace("<", "").replace(">", "");
                String rel = linkData[1].substring(4).replace("\"", "");
                return Link.of(this.fixQuery(href), rel);
            }).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    private String fixQuery(String href) {
        UriComponents build = UriComponentsBuilder.fromHttpUrl((String)href).build();
        MultiValueMap queryParams = build.getQueryParams();
        LinkedMultiValueMap queryParamsFixed = new LinkedMultiValueMap();
        queryParams.forEach((arg_0, arg_1) -> Client.lambda$fixQuery$14((MultiValueMap)queryParamsFixed, arg_0, arg_1));
        return UriComponentsBuilder.fromPath((String)build.getPath()).scheme(build.getScheme()).queryParams((MultiValueMap)queryParamsFixed).fragment(build.getFragment()).port(build.getPort()).host(build.getHost()).build().toUriString();
    }

    @VisibleForTesting
    protected Map<String, Object> fieldsFrom(Post post) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        BiConsumer<String, Object> biConsumer = (key, value) -> Optional.ofNullable(value).ifPresent(v -> builder.put(key, v));
        List<String> processableFields = Arrays.asList("author", "categories", "comment_status", "content", "date", "featured_media", "format", "excerpt", "modified_gmt", "ping_status", "sticky", "tags", "title", "type");
        Arrays.stream(post.getClass().getDeclaredFields()).filter(field -> ((JsonProperty[])field.getAnnotationsByType(JsonProperty.class)).length > 0).map(field -> Tuple2.of(field, ((JsonProperty[])field.getAnnotationsByType(JsonProperty.class))[0])).filter(fieldTuple -> processableFields.contains(((JsonProperty)fieldTuple.b).value())).forEach(field -> {
            try {
                ReflectionUtils.makeAccessible((Field)((Field)field.a));
                Object theField = ((Field)field.a).get(post);
                if (Objects.nonNull(theField)) {
                    Object value = theField instanceof RenderableField ? ((RenderableField)theField).getRendered() : theField;
                    biConsumer.accept(((JsonProperty)field.b).value(), value);
                }
            }
            catch (IllegalAccessException e) {
                LOG.error("Error populating post fields builder.", (Throwable)e);
            }
        });
        return builder.build();
    }

    private <T, B> ResponseEntity<T> doExchange0(HttpMethod method, URI uri, Class<T> typeRef, B body, @Nullable MediaType mediaType) {
        Tuple2<String, String> authTuple = AuthUtil.authTuple(this.username, this.password);
        RequestEntity.BodyBuilder builder = (RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.method((HttpMethod)method, (URI)uri).header((String)authTuple.a, new String[]{(String)authTuple.b})).header((String)this.userAgentTuple.a, new String[]{(String)this.userAgentTuple.b});
        Optional.ofNullable(mediaType).ifPresent(arg_0 -> ((RequestEntity.BodyBuilder)builder).contentType(arg_0));
        RequestEntity entity = builder.body(body);
        this.debugRequest(entity);
        ResponseEntity exchange = this.restTemplate.exchange(entity, typeRef);
        this.debugHeaders(exchange.getHeaders());
        return exchange;
    }

    private <T, B> ResponseEntity<T> doExchange0(HttpMethod method, UriComponents uriComponents, Class<T> typeRef, B body, @Nullable MediaType mediaType) {
        return this.doExchange0(method, uriComponents.toUri(), typeRef, body, mediaType);
    }

    @Override
    public <T, B> ResponseEntity<T> doCustomExchange(String context, HttpMethod method, Class<T> typeRef, Object[] buildAndExpand, Map<String, Object> queryParams, B body, @Nullable MediaType mediaType) {
        return this.doExchange1(context, method, typeRef, buildAndExpand, queryParams, body, mediaType);
    }

    private <T, B> ResponseEntity<T> doExchange1(String context, HttpMethod method, Class<T> typeRef, Object[] buildAndExpand, Map<String, Object> queryParams, B body) {
        return this.doExchange1(context, method, typeRef, buildAndExpand, queryParams, body, null);
    }

    private <T, B> ResponseEntity<T> doExchange1(String context, HttpMethod method, Class<T> typeRef, Object[] buildAndExpand, Map<String, Object> queryParams, B body, @Nullable MediaType mediaType) {
        UriComponentsBuilder builder = Request.of(context).usingClient(this);
        Optional.ofNullable(queryParams).ifPresent(params -> params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1})));
        return this.doExchange0(method, builder.buildAndExpand(buildAndExpand), typeRef, body, mediaType);
    }

    private Optional<String> link(List<Link> links, Predicate<? super Link> linkPredicate) {
        return links.stream().filter(linkPredicate).map(Link::getHref).findFirst();
    }

    private void debugRequest(RequestEntity<?> entity) {
        if (this.debug) {
            LOG.debug("Request Entity: {}", entity);
        }
    }

    private void debugHeaders(HttpHeaders headers) {
        if (this.debug) {
            LOG.debug("Response Headers:");
            headers.forEach((key, value) -> LOG.debug("{} -> {}", key, value));
        }
    }

    static Object[] forExpand(Object ... values) {
        return values;
    }

    private static /* synthetic */ void lambda$fixQuery$14(MultiValueMap queryParamsFixed, String key, List values) {
        List cfr_ignored_0 = (List)queryParamsFixed.put((Object)URLDecoder.decode(key), values.stream().map(URLDecoder::decode).collect(Collectors.toList()));
    }

    private static /* synthetic */ void lambda$createMedia$3(MultiValueMap uploadMap, String index, Object value) {
        Optional.ofNullable(value).ifPresent(v -> uploadMap.add((Object)index, v));
    }
}

