/*
 * Decompiled with CFR 0.152.
 */
package com.afrozaar.wordpress.wpapi.v2.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringBooleanMapDeserializer
extends JsonDeserializer<Map<String, Boolean>> {
    private static final Logger LOG = LoggerFactory.getLogger(StringBooleanMapDeserializer.class);

    public Map<String, Boolean> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        LinkedHashMap<String, Boolean> data = new LinkedHashMap<String, Boolean>();
        String key = null;
        Boolean value = null;
        while (!p.nextToken().equals((Object)JsonToken.END_OBJECT)) {
            if (p.getCurrentToken().equals((Object)JsonToken.FIELD_NAME)) {
                key = p.getCurrentName();
            }
            if (p.getCurrentToken().equals((Object)JsonToken.VALUE_STRING)) {
                String valueAsString;
                String string = valueAsString = p.getValueAsString() != null && !p.getValueAsString().trim().isEmpty() ? p.getValueAsString() : "";
                if (Arrays.asList("0", "no", "false").contains(valueAsString)) {
                    value = false;
                } else if (Arrays.asList("1", "yes", "true").contains(valueAsString)) {
                    value = true;
                } else {
                    LOG.warn("Could not parse boolean value from [{}]. Supported values are: Truthy(1, yes, true) and Falsy(0, no, false).", (Object)valueAsString);
                }
            }
            if (p.getCurrentToken().equals((Object)JsonToken.VALUE_TRUE)) {
                value = Boolean.TRUE;
            }
            if (p.getCurrentToken().equals((Object)JsonToken.VALUE_FALSE)) {
                value = Boolean.FALSE;
            }
            if (key == null || value == null) continue;
            data.put(key, value);
            key = null;
            value = null;
        }
        return data;
    }
}

