/*
 * Decompiled with CFR 0.152.
 */
package com.afrozaar.wordpress.wpapi.v2.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.web.client.HttpStatusCodeException;

public class ParsedRestException {
    private static final String FIELD_CODE = "code";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_ADDITIONAL_ERRORS = "additional_errors";
    private static ObjectMapper mapper;
    private final String code;
    private final String errorMessage;
    private final Object data;
    private final HttpStatusCodeException cause;
    private final Collection<RestException> additionalErrors;
    private static final Function<Object, Collection<RestException>> ADDITIONAL_ERROR_PARSER;

    private ParsedRestException(HttpStatusCodeException cause, String code, String errorMessage, Object data, Collection<RestException> additionalErrors) {
        this.cause = cause;
        this.code = code;
        this.errorMessage = errorMessage;
        this.data = data;
        this.additionalErrors = additionalErrors;
    }

    public static ParsedRestException of(HttpStatusCodeException cause) {
        try {
            Map exceptionMap = (Map)ParsedRestException.getMapper().readValue(cause.getResponseBodyAsByteArray(), Map.class);
            String errorMessage = (String)exceptionMap.get(FIELD_MESSAGE);
            String code = (String)exceptionMap.get(FIELD_CODE);
            Object data = exceptionMap.get(FIELD_DATA);
            return new ParsedRestException(cause, code, errorMessage, data, ADDITIONAL_ERROR_PARSER.apply(exceptionMap));
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create ParsedRestException.", e);
        }
    }

    public String getCode() {
        return this.code;
    }

    public Object getData() {
        return this.data;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public HttpStatusCodeException getCause() {
        return this.cause;
    }

    public Collection<RestException> getAdditionalErrors() {
        return this.additionalErrors;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ParsedRestException{");
        sb.append("code='").append(this.code).append('\'');
        sb.append(", errorMessage='").append(this.errorMessage).append('\'');
        sb.append(", data=").append(this.data);
        sb.append(", additionalErrors=").append(this.getAdditionalErrors());
        sb.append('}');
        return sb.toString();
    }

    private static ObjectMapper getMapper() {
        return mapper == null ? (mapper = new ObjectMapper()) : mapper;
    }

    static {
        ADDITIONAL_ERROR_PARSER = exceptionMap -> {
            Map em = (Map)exceptionMap;
            return Optional.ofNullable(em.get(FIELD_ADDITIONAL_ERRORS)).map(additionalErrors -> ((ArrayList)additionalErrors).stream().map(RestException::fromRaw).collect(Collectors.toList())).orElse(Collections.emptyList());
        };
    }

    static class RestException {
        private final String code;
        private final String message;
        private final Object data;

        public static RestException fromRaw(Object mapObject) {
            Map errorMap = (Map)mapObject;
            String code = (String)errorMap.get(ParsedRestException.FIELD_CODE);
            String message = (String)errorMap.get(ParsedRestException.FIELD_MESSAGE);
            Object data = errorMap.get(ParsedRestException.FIELD_DATA);
            return new RestException(code, message, data);
        }

        RestException(String code, String message, Object data) {
            this.code = code;
            this.message = message;
            this.data = data;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getData() {
            return this.data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("RestException{");
            sb.append("code='").append(this.code).append('\'');
            sb.append(", message='").append(this.message).append('\'');
            sb.append(", data=").append(this.data);
            sb.append('}');
            return sb.toString();
        }
    }
}

