/*
 * Decompiled with CFR 0.152.
 */
package com.afrozaar.wordpress.wpapi.v2.model.builder;

import com.afrozaar.wordpress.wpapi.v2.model.Content;
import com.afrozaar.wordpress.wpapi.v2.model.Excerpt;
import com.afrozaar.wordpress.wpapi.v2.model.Guid;
import com.afrozaar.wordpress.wpapi.v2.model.Links;
import com.afrozaar.wordpress.wpapi.v2.model.Post;
import com.afrozaar.wordpress.wpapi.v2.model.Term;
import com.afrozaar.wordpress.wpapi.v2.model.Title;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class PostBuilder {
    private Long author;
    private Long id;
    private Title title;
    private Links Links;
    private String slug;
    private String link;
    private Content content;
    private Long featuredMedia;
    private String format;
    private Boolean sticky;
    private String commentStatus;
    private Guid guid;
    private Excerpt excerpt;
    private String date;
    private String modifiedGmt;
    private String type;
    private String pingStatus;
    private List<Long> categoryIds;
    private List<Long> tagIds;

    private PostBuilder() {
    }

    public static PostBuilder aPost() {
        return new PostBuilder();
    }

    public PostBuilder withAuthor(Long author) {
        this.author = author;
        return this;
    }

    public PostBuilder withId(Long id) {
        this.id = id;
        return this;
    }

    public PostBuilder withTitle(Title title) {
        this.title = title;
        return this;
    }

    public PostBuilder withLinks(Links Links2) {
        this.Links = Links2;
        return this;
    }

    public PostBuilder withSlug(String slug) {
        this.slug = slug;
        return this;
    }

    public PostBuilder withLink(String link) {
        this.link = link;
        return this;
    }

    public PostBuilder withContent(Content content) {
        this.content = content;
        return this;
    }

    public PostBuilder withFeaturedMedia(Long featuredMedia) {
        this.featuredMedia = featuredMedia;
        return this;
    }

    public PostBuilder withFormat(String format) {
        this.format = format;
        return this;
    }

    public PostBuilder withSticky(Boolean sticky) {
        this.sticky = sticky;
        return this;
    }

    public PostBuilder withCommentStatus(String commentStatus) {
        this.commentStatus = commentStatus;
        return this;
    }

    public PostBuilder withGuid(Guid guid) {
        this.guid = guid;
        return this;
    }

    public PostBuilder withExcerpt(Excerpt excerpt) {
        this.excerpt = excerpt;
        return this;
    }

    public PostBuilder withDate(String date) {
        this.date = date;
        return this;
    }

    public PostBuilder withModifiedGmt(String modifiedGmt) {
        this.modifiedGmt = modifiedGmt;
        return this;
    }

    public PostBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public PostBuilder withPingStatus(String pingStatus) {
        this.pingStatus = pingStatus;
        return this;
    }

    public PostBuilder withCategories(List<Long> categoryIds) {
        this.categoryIds = categoryIds;
        return this;
    }

    public PostBuilder withTags(List<Long> tagIds) {
        this.tagIds = tagIds;
        return this;
    }

    public PostBuilder withCategories(Term ... terms) {
        return this.withCategories(Arrays.stream(terms).map(Term::getId).collect(Collectors.toList()));
    }

    public PostBuilder withTags(Term ... tags) {
        return this.withTags(Arrays.stream(tags).map(Term::getId).collect(Collectors.toList()));
    }

    public PostBuilder but() {
        return PostBuilder.aPost().withAuthor(this.author).withId(this.id).withTitle(this.title).withLinks(this.Links).withSlug(this.slug).withLink(this.link).withContent(this.content).withFeaturedMedia(this.featuredMedia).withFormat(this.format).withSticky(this.sticky).withCommentStatus(this.commentStatus).withGuid(this.guid).withExcerpt(this.excerpt).withDate(this.date).withModifiedGmt(this.modifiedGmt).withType(this.type).withPingStatus(this.pingStatus).withCategories(this.categoryIds).withTags(this.tagIds);
    }

    public Post build() {
        Post post = new Post();
        post.setAuthor(this.author);
        post.setId(this.id);
        post.setTitle(this.title);
        post.setLinks(this.Links);
        post.setSlug(this.slug);
        post.setLink(this.link);
        post.setContent(this.content);
        post.setFeaturedMedia(this.featuredMedia);
        post.setFormat(this.format);
        post.setSticky(this.sticky);
        post.setCommentStatus(this.commentStatus);
        post.setGuid(this.guid);
        post.setExcerpt(this.excerpt);
        post.setDate(this.date);
        post.setModifiedGmt(this.modifiedGmt);
        post.setType(this.type);
        post.setPingStatus(this.pingStatus);
        post.setCategoryIds(this.categoryIds);
        post.setTagIds(this.tagIds);
        return post;
    }
}

