/*
 * Decompiled with CFR 0.152.
 */
package com.afrozaar.wordpress.wpapi.v2.request;

import com.afrozaar.wordpress.wpapi.v2.request.Request;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SearchRequest<T>
extends Request {
    private final Class<T> clazz;

    public SearchRequest(String uri, Map<String, List<String>> params, Class<T> clazz) {
        super(uri, params);
        this.clazz = clazz;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public static class Builder<BT> {
        ImmutableMap.Builder<String, List<String>> paramBuilder = new ImmutableMap.Builder();
        String uri = "/posts";
        final Class<BT> clazz;

        private Builder(Class<BT> clazz) {
            this.clazz = clazz;
        }

        public static <BT> Builder<BT> aSearchRequest(Class<BT> clazz) {
            return new Builder<BT>(clazz);
        }

        public Builder<BT> withContext(String context) {
            return this.withParam("context", context);
        }

        public Builder<BT> withOrderBy(String orderBy) {
            return this.withParam("orderby", orderBy);
        }

        public Builder<BT> withOrderAsc() {
            return this.withOrder("asc");
        }

        public Builder<BT> withOrderDesc() {
            return this.withOrder("desc");
        }

        private Builder<BT> withOrder(String order) {
            return this.withParam("order", order);
        }

        public Builder<BT> withFilter(String key, String ... values) {
            return this.withParam(String.format("filter[%s]", key), values);
        }

        public Builder<BT> withParam(String key, String ... values) {
            this.paramBuilder.put((Object)key, Arrays.asList(values));
            return this;
        }

        public Builder<BT> withParams(Map<String, List<String>> params) {
            this.paramBuilder.putAll(params);
            return this;
        }

        public Builder<BT> withPagination(int pageSize, int pageNumber) {
            this.withParam("page", String.valueOf(pageNumber));
            this.withParam("per_page", String.valueOf(pageSize));
            return this;
        }

        public Builder<BT> withUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder<BT> but() {
            return Builder.aSearchRequest(this.clazz).withParams((Map<String, List<String>>)this.paramBuilder.build()).withUri(this.uri);
        }

        public SearchRequest<BT> build() {
            return new SearchRequest<BT>(this.uri, (Map<String, List<String>>)this.paramBuilder.build(), this.clazz);
        }
    }
}

