/*
 * Decompiled with CFR 0.152.
 */
package com.afrozaar.wordpress.wpapi.v2.response;

import com.afrozaar.wordpress.wpapi.v2.model.DeleteResponse;
import com.afrozaar.wordpress.wpapi.v2.model.Media;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;

public final class CustomRenderableParser {
    private static final Logger LOG = LoggerFactory.getLogger(CustomRenderableParser.class);
    public static final String FIELD_PREVIOUS = "previous";
    public static final String FIELD_DELETED = "deleted";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final Set<String> modifiableFields = new HashSet<String>(Arrays.asList("description", "caption"));
    private static final String RENDERED = "rendered";
    private static final String RAW = "raw";
    private static final Function<Iterator<Map.Entry<String, JsonNode>>, Stream<Map.Entry<String, JsonNode>>> streamIterator = iterator -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    private static final Function<JsonNode, Stream<String>> findRenderableFields = jsonNode -> streamIterator.apply(jsonNode.fields()).filter(entry -> ((JsonNode)entry.getValue()).fields().hasNext()).filter(entry -> streamIterator.apply(((JsonNode)entry.getValue()).fields()).filter(field -> RAW.equals(field.getKey()) || RENDERED.equals(field.getKey())).count() > 0L).map(Map.Entry::getKey);
    private static final Consumer<JsonNode> transformNode = node -> findRenderableFields.apply((JsonNode)node).filter(modifiableFields::contains).forEach(renderableField -> {
        Optional<JsonNode> raw1 = Optional.ofNullable(node.get(renderableField).get(RAW));
        if (raw1.isPresent()) {
            JsonNode jsonNode2 = raw1.get();
            ((ObjectNode)node).put(renderableField, jsonNode2.asText());
        } else {
            Optional.ofNullable(node.get(renderableField).get(RENDERED)).map(jsonNode -> jsonNode.asText().replaceAll("<[^>]*>", "")).map(strippedText -> {
                LOG.warn("Raw field for parent '{}' not available. Using regex-stripped value: {}", renderableField, strippedText);
                return strippedText;
            }).ifPresent(strippedText -> ((ObjectNode)node).put(renderableField, strippedText));
        }
    });

    private CustomRenderableParser() {
    }

    public static Media parseMedia(String stringResponse) throws HttpClientErrorException {
        return CustomRenderableParser.parse(stringResponse, Media.class);
    }

    public static <T> T parse(ResponseEntity<String> response, Class<T> clazz) {
        return CustomRenderableParser.parse((String)response.getBody(), clazz);
    }

    public static <T> T parse(String response, Class<T> clazz) {
        LOG.debug("Parsing response for {}", (Object)clazz.getCanonicalName());
        LOG.trace("Type parameters: {}", Arrays.asList(clazz.getTypeParameters()));
        LOG.trace("Response String: {}", (Object)response);
        try {
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(response, JsonNode.class);
            return CustomRenderableParser.parseNode(jsonNode, clazz);
        }
        catch (IOException e) {
            LOG.error("Error ", (Throwable)e);
            throw new HttpClientErrorException(HttpStatus.I_AM_A_TEAPOT, "There was an error parsing the response body.", response.getBytes(), StandardCharsets.UTF_8);
        }
    }

    public static <T> DeleteResponse<T> parseDeleteResponse(ResponseEntity<String> response, Class<T> clazz) {
        return CustomRenderableParser.parseDeleteResponse((String)response.getBody(), clazz);
    }

    public static <T> DeleteResponse<T> parseDeleteResponse(String response, Class<T> clazz) {
        LOG.trace("parsing delete response for '{}' from {}", (Object)clazz.getCanonicalName(), (Object)response);
        Function<JsonNode, DeleteResponse> resolveFor4_7 = node -> DeleteResponse.of(node.get(FIELD_DELETED).asBoolean(), CustomRenderableParser.parseNode(node.get(FIELD_PREVIOUS), clazz));
        Function<JsonNode, DeleteResponse> resolveFor4_6 = node -> DeleteResponse.of(true, CustomRenderableParser.parseNode(node, clazz));
        try {
            JsonNode rootNode = (JsonNode)objectMapper.readValue(response, JsonNode.class);
            return Optional.ofNullable(rootNode.get(FIELD_DELETED)).map(jsonNode -> resolveFor4_7).orElse(resolveFor4_6).apply(rootNode);
        }
        catch (IOException e) {
            LOG.error("Error ", (Throwable)e);
            throw new HttpClientErrorException(HttpStatus.I_AM_A_TEAPOT, "There was an error reading the response body.", response.getBytes(), StandardCharsets.UTF_8);
        }
    }

    private static <T> T parseNode(JsonNode jsonNode, Class<T> clazz) {
        LOG.trace("{} isArray: {}", (Object)clazz.getCanonicalName(), (Object)clazz.isArray());
        if (clazz.isArray()) {
            jsonNode.iterator().forEachRemaining(transformNode);
        } else {
            transformNode.accept(jsonNode);
        }
        return (T)objectMapper.convertValue((Object)jsonNode, clazz);
    }
}

