/*
 * Decompiled with CFR 0.152.
 */
package com.afrozaar.wordpress.wpapi.v2.response;

import com.afrozaar.wordpress.wpapi.v2.request.Request;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class PagedResponse<T> {
    final Class<T> clazz;
    public static final Function<PagedResponse<?>, String> NEXT = response -> response.getNext().get();
    public static final Function<PagedResponse<?>, String> PREV = response -> response.getPrevious().get();
    private static final Logger LOG = LoggerFactory.getLogger(PagedResponse.class);
    final String self;
    final String next;
    final String previous;
    final int pages;
    final List<T> list;

    public PagedResponse(Class<T> clazz, String self, String next, String previous, int pages, List<T> list) {
        this.clazz = clazz;
        this.self = self;
        this.next = next;
        this.previous = previous;
        this.pages = pages;
        this.list = list;
    }

    public boolean hasNext() {
        return Objects.nonNull(this.next);
    }

    public Optional<String> getNext() {
        return Optional.ofNullable(this.next);
    }

    public boolean hasPrevious() {
        return Objects.nonNull(this.previous);
    }

    public Optional<String> getPrevious() {
        return Optional.ofNullable(this.previous);
    }

    public String getSelf() {
        return this.self;
    }

    public List<T> getList() {
        return this.list;
    }

    public void debug() {
        LOG.trace("response.self      = {}", (Object)this.self);
        LOG.trace("response.prev      = {}", (Object)this.previous);
        LOG.trace("response.next      = {}", (Object)this.next);
        LOG.trace("response.pages     = {}", (Object)this.pages);
        LOG.trace("response.list.size = {}", (Object)this.list.size());
    }

    public URI getUri(Function<PagedResponse<?>, String> direction) {
        return Request.fromLink(direction.apply(this));
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public static class Builder<BT> {
        private String next;
        private String self;
        private String previous;
        private List<BT> posts;
        private int pages;
        private Class<BT> t1;

        private Builder(Class<BT> t1) {
            this.t1 = t1;
        }

        public static <BT> Builder<BT> aPagedResponse(Class<BT> t) {
            return new Builder<BT>(t);
        }

        public Builder<BT> withNext(Optional<String> next) {
            next.ifPresent(n -> {
                this.next = n;
            });
            return this;
        }

        public Builder<BT> withSelf(String self) {
            this.self = self;
            return this;
        }

        public Builder<BT> withPrevious(Optional<String> previous) {
            previous.ifPresent(p -> {
                this.previous = p;
            });
            return this;
        }

        public Builder<BT> withPosts(List<BT> posts) {
            this.posts = posts;
            return this;
        }

        public PagedResponse<BT> build() {
            return new PagedResponse<BT>(this.t1, this.self, this.next, this.previous, this.pages, this.posts);
        }

        public Builder<BT> withPages(int pages) {
            this.pages = pages;
            return this;
        }

        public Builder<BT> withPages(HttpHeaders headers) {
            headers.get((Object)"X-WP-TotalPages").stream().findFirst().ifPresent(pages -> this.withPages(Integer.valueOf(pages)));
            return this;
        }
    }
}

