/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.endpoint;

import com.aftership.sdk.endpoint.StringMap;
import com.aftership.sdk.exception.ErrorType;
import com.aftership.sdk.exception.SdkException;
import com.aftership.sdk.model.AftershipResponse;
import com.aftership.sdk.model.tracking.SlugTrackingNumber;
import com.aftership.sdk.request.ApiRequest;
import com.aftership.sdk.utils.StrUtils;
import com.aftership.sdk.utils.UrlUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AfterShipEndpoint {
    protected final ApiRequest request;

    public AfterShipEndpoint(ApiRequest request) {
        this.request = request;
    }

    protected void checkTrackingId(String id) throws SdkException {
        if (StrUtils.isBlank(id)) {
            throw new SdkException(ErrorType.ConstructorError, "ConstructorError: Required tracking id");
        }
    }

    protected void checkSlugTrackingNumber(SlugTrackingNumber slugTrackingNumber) throws SdkException {
        this.checkNullParam(slugTrackingNumber);
        this.checkTrackingSlug(slugTrackingNumber.getSlug());
        this.checkTrackingNumber(slugTrackingNumber.getTrackingNumber());
    }

    protected void checkTrackingSlug(String slug) throws SdkException {
        if (StrUtils.isBlank(slug)) {
            throw new SdkException(ErrorType.ConstructorError, "ConstructorError: Required tracking slug");
        }
    }

    protected void checkTrackingNumber(String trackingNumber) throws SdkException {
        if (StrUtils.isBlank(trackingNumber)) {
            throw new SdkException(ErrorType.ConstructorError, "ConstructorError: Required tracking number");
        }
    }

    protected void checkNullParam(Object param) throws SdkException {
        if (param == null) {
            throw new SdkException(ErrorType.ConstructorError, "ConstructorError: Parameters cannot be null");
        }
    }

    protected void checkEmptyCollection(Collection<?> c) throws SdkException {
        if (c == null || c.isEmpty()) {
            throw new SdkException(ErrorType.ConstructorError, "ConstructorError: Parameters cannot be null");
        }
    }

    protected <T> T extractData(AftershipResponse<T> response) {
        return response.getData();
    }

    protected Map<String, String> mergeMap(StringMap ... items) {
        if (items.length == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> query = new HashMap<String, String>();
        for (StringMap item : items) {
            if (item == null) continue;
            query.putAll(item.toMap());
        }
        return query;
    }

    protected Map<String, String> takeMap(StringMap item) {
        if (item == null) {
            return new HashMap<String, String>(0);
        }
        return item.toMap();
    }

    protected String buildTrackingPath(String id, String slug, String trackingNumber, String rootPath, String action) throws SdkException {
        if (StrUtils.isBlank(rootPath)) {
            throw new SdkException(ErrorType.ConstructorError, "ConstructorError: Required tracking path");
        }
        String trackingUrl = rootPath;
        if (StrUtils.isNotBlank(id)) {
            trackingUrl = MessageFormat.format("{0}/{1}", rootPath, UrlUtils.encode(id));
        } else if (StrUtils.isNotBlank(slug) && StrUtils.isNotBlank(trackingNumber)) {
            trackingUrl = MessageFormat.format("{0}/{1}/{2}", rootPath, UrlUtils.encode(slug), UrlUtils.encode(trackingNumber));
        }
        if (StrUtils.isNotBlank(action)) {
            trackingUrl = MessageFormat.format("{0}/{1}", trackingUrl, UrlUtils.encode(action));
        }
        return trackingUrl;
    }
}

