/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.endpoint.impl;

import com.aftership.sdk.endpoint.AfterShipEndpoint;
import com.aftership.sdk.endpoint.CourierEndpoint;
import com.aftership.sdk.exception.ApiException;
import com.aftership.sdk.exception.RequestException;
import com.aftership.sdk.exception.SdkException;
import com.aftership.sdk.model.AftershipResponse;
import com.aftership.sdk.model.courier.CourierDetectList;
import com.aftership.sdk.model.courier.CourierDetectRequest;
import com.aftership.sdk.model.courier.CourierDetectTracking;
import com.aftership.sdk.model.courier.CourierList;
import com.aftership.sdk.request.ApiRequest;
import com.aftership.sdk.request.HttpMethod;

public class CourierImpl
extends AfterShipEndpoint
implements CourierEndpoint {
    public CourierImpl(ApiRequest request) {
        super(request);
    }

    @Override
    public CourierList listCouriers() throws RequestException, ApiException {
        AftershipResponse<CourierList> response = this.request.makeRequest(HttpMethod.GET, "/couriers", null, null, CourierList.class);
        return this.extractData(response);
    }

    @Override
    public CourierList listAllCouriers() throws RequestException, ApiException {
        AftershipResponse<CourierList> response = this.request.makeRequest(HttpMethod.GET, "/couriers/all", null, null, CourierList.class);
        return this.extractData(response);
    }

    @Override
    public CourierDetectList detectCouriers(CourierDetectTracking detectTracking) throws SdkException, RequestException, ApiException {
        this.checkNullParam(detectTracking);
        this.checkTrackingNumber(detectTracking.getTrackingNumber());
        AftershipResponse<CourierDetectList> response = this.request.makeRequest(HttpMethod.POST, "/couriers/detect", null, new CourierDetectRequest(detectTracking), CourierDetectList.class);
        return this.extractData(response);
    }
}

