/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.endpoint.impl;

import com.aftership.sdk.endpoint.AfterShipEndpoint;
import com.aftership.sdk.endpoint.NotificationEndpoint;
import com.aftership.sdk.exception.ApiException;
import com.aftership.sdk.exception.RequestException;
import com.aftership.sdk.exception.SdkException;
import com.aftership.sdk.model.AftershipResponse;
import com.aftership.sdk.model.notification.Notification;
import com.aftership.sdk.model.notification.NotificationWrapper;
import com.aftership.sdk.model.tracking.SlugTrackingNumber;
import com.aftership.sdk.request.ApiRequest;
import com.aftership.sdk.request.HttpMethod;

public class NotificationImpl
extends AfterShipEndpoint
implements NotificationEndpoint {
    public NotificationImpl(ApiRequest request) {
        super(request);
    }

    @Override
    public Notification getNotification(String id) throws SdkException, RequestException, ApiException {
        this.checkTrackingId(id);
        String path = this.buildTrackingPath(id, null, null, "/notifications", null);
        AftershipResponse<NotificationWrapper> response = this.request.makeRequest(HttpMethod.GET, path, null, null, NotificationWrapper.class);
        return this.extractData(response).getNotification();
    }

    @Override
    public Notification getNotification(SlugTrackingNumber identifier) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/notifications", null);
        AftershipResponse<NotificationWrapper> response = this.request.makeRequest(HttpMethod.GET, path, null, null, NotificationWrapper.class);
        return this.extractData(response).getNotification();
    }

    @Override
    public Notification addNotification(String id, Notification notification) throws SdkException, RequestException, ApiException {
        this.checkTrackingId(id);
        String path = this.buildTrackingPath(id, null, null, "/notifications", "add");
        AftershipResponse<NotificationWrapper> response = this.request.makeRequest(HttpMethod.POST, path, null, new NotificationWrapper(notification), NotificationWrapper.class);
        return this.extractData(response).getNotification();
    }

    @Override
    public Notification addNotification(SlugTrackingNumber identifier, Notification notification) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/notifications", "add");
        AftershipResponse<NotificationWrapper> response = this.request.makeRequest(HttpMethod.POST, path, null, new NotificationWrapper(notification), NotificationWrapper.class);
        return this.extractData(response).getNotification();
    }

    @Override
    public Notification removeNotification(String id, Notification notification) throws SdkException, RequestException, ApiException {
        this.checkTrackingId(id);
        String path = this.buildTrackingPath(id, null, null, "/notifications", "remove");
        AftershipResponse<NotificationWrapper> response = this.request.makeRequest(HttpMethod.POST, path, null, new NotificationWrapper(notification), NotificationWrapper.class);
        return this.extractData(response).getNotification();
    }

    @Override
    public Notification removeNotification(SlugTrackingNumber identifier, Notification notification) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/notifications", "remove");
        AftershipResponse<NotificationWrapper> response = this.request.makeRequest(HttpMethod.POST, path, null, new NotificationWrapper(notification), NotificationWrapper.class);
        return this.extractData(response).getNotification();
    }
}

