/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.exception;

import com.aftership.sdk.utils.JsonUtils;
import com.aftership.sdk.utils.StrUtils;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AftershipException
extends Exception {
    private static final int CODE_TOO_MANY_REQUESTS = 429;
    public static final String DEBUG_DATA_KEY_REQUEST_CONFIG = "requestConfig";
    public static final String DEBUG_DATA_KEY_REQUEST_HEADERS = "requestHeaders";
    public static final String DEBUG_DATA_KEY_REQUEST_DATA = "requestData";
    public static final String DEBUG_DATA_KEY_RESPONSE_BODY = "responseBody";
    private String type;
    private String message;
    private Integer code;
    private Map<String, Object> data;

    public AftershipException(String type, String message) {
        this(type, message, null);
    }

    public AftershipException(String type, Throwable cause, Map<String, Object> data) {
        this(type, null, null, cause, data);
    }

    public AftershipException(String type, String message, Map<String, Object> data) {
        this(type, message, null, data);
    }

    public AftershipException(String type, String message, Integer code, Map<String, Object> data) {
        this(type, message, code, null, data);
    }

    public AftershipException(String type, String message, Integer code, Throwable cause, Map<String, Object> data) {
        super(message, cause);
        this.type = type;
        this.message = message;
        this.code = code;
        this.data = data;
    }

    @Override
    public String getMessage() {
        StringBuilder additionalInfo = new StringBuilder();
        if (StrUtils.isNotBlank(this.type)) {
            additionalInfo.append("; type: ").append(this.type);
        }
        if (this.code != null) {
            additionalInfo.append("; code: ").append(this.code);
        }
        if (this.data != null) {
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                additionalInfo.append(MessageFormat.format("; DEBUG_DATA::{0}: {1}", entry.getKey(), entry.getValue()));
            }
        }
        this.maskAfterShipApiKey(additionalInfo);
        return super.getMessage() + additionalInfo;
    }

    private void maskAfterShipApiKey(StringBuilder additionalInfo) {
        Pattern p = Pattern.compile("aftership-api-key=([-\\w]+)");
        Matcher m = p.matcher(additionalInfo);
        additionalInfo.replace(0, additionalInfo.length(), m.replaceAll("aftership-api-key=******"));
    }

    public boolean isTooManyRequests() {
        return this.getCode() != null && this.getCode() == 429;
    }

    public boolean isApiError() {
        return this.getCode() != null && this.getCode() > 0;
    }

    public void printMessage() {
        this.printMessage(System.out::print);
    }

    public void printMessage(Consumer<String> consumer) {
        consumer.accept(this.prettyMessage());
    }

    private String prettyMessage() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(4);
        map.put("type", this.getType());
        map.put("message", this.message);
        map.put("code", this.getCode());
        map.put("data", this.getData().toString());
        return JsonUtils.getGson().toJson(map);
    }

    public String getType() {
        return this.type;
    }

    public Integer getCode() {
        return this.code;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

