/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.utils;

import com.aftership.sdk.utils.StrUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Map;

public final class UrlUtils {
    public static final String UTF8 = "UTF-8";

    public static String encode(String value) {
        return UrlUtils.encode(value, UTF8);
    }

    public static String encode(String value, String charset) {
        if (StrUtils.isBlank(value)) {
            return "";
        }
        if (StrUtils.isBlank(charset)) {
            charset = UTF8;
        }
        try {
            return URLEncoder.encode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String decode(String value) {
        return UrlUtils.decode(value, UTF8);
    }

    public static String decode(String value, String charset) {
        if (StrUtils.isBlank(value)) {
            return "";
        }
        if (StrUtils.isBlank(charset)) {
            charset = UTF8;
        }
        try {
            return URLDecoder.decode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String fillPathWithQuery(String path, Map<String, String> query) {
        StringBuilder builder = new StringBuilder(path);
        if (query != null && query.size() > 0) {
            if (!path.endsWith("?")) {
                builder.append("?");
            }
            for (Map.Entry<String, String> entry : query.entrySet()) {
                if (!StrUtils.isNotBlank(entry.getValue())) continue;
                builder.append(MessageFormat.format("{0}={1}", entry.getKey(), UrlUtils.encode(entry.getValue())));
                builder.append("&");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

