/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk;

import com.aftership.sdk.auth.AbstractSigner;
import com.aftership.sdk.auth.AuthenticationType;
import com.aftership.sdk.auth.HMACSigner;
import com.aftership.sdk.endpoint.CheckpointEndpoint;
import com.aftership.sdk.endpoint.CourierEndpoint;
import com.aftership.sdk.endpoint.EstimatedDeliveryDateEndpoint;
import com.aftership.sdk.endpoint.NotificationEndpoint;
import com.aftership.sdk.endpoint.TrackingEndpoint;
import com.aftership.sdk.endpoint.impl.CheckpointImpl;
import com.aftership.sdk.endpoint.impl.CourierImpl;
import com.aftership.sdk.endpoint.impl.EstimatedDeliveryDateImpl;
import com.aftership.sdk.endpoint.impl.NotificationImpl;
import com.aftership.sdk.endpoint.impl.TrackingImpl;
import com.aftership.sdk.enums.Versions;
import com.aftership.sdk.model.AftershipOption;
import com.aftership.sdk.model.RateLimit;
import com.aftership.sdk.model.RetryOption;
import com.aftership.sdk.request.ApiRequestImpl;
import com.aftership.sdk.request.retry.RetryCondition;
import com.aftership.sdk.request.retry.RetryInterceptor;
import com.aftership.sdk.utils.StrUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class AfterShip {
    private static final String DEFAULT_VERSION_ENDPOINT = "https://api.aftership.com/tracking/%s";
    private static final String DEFAULT_USER_AGENT = "aftership-sdk-java";
    private static final String DEFAULT_VERSION = Versions.V2023_10.getValue();
    private final OkHttpClient client;
    private final String apiKey;
    private final String apiSecret;
    private final AbstractSigner signer;
    private final AuthenticationType authenticationType;
    private final String endpoint;
    private final String version;
    private final String userAgentPrefix;
    private RateLimit rateLimit;
    private final CourierEndpoint courierEndpoint;
    private final TrackingEndpoint trackingEndpoint;
    private final CheckpointEndpoint checkpointEndpoint;
    private final NotificationEndpoint notificationEndpoint;
    private final EstimatedDeliveryDateEndpoint estimatedDeliveryDateEndpoint;

    public AfterShip(String apiKey) {
        this(apiKey, null);
    }

    public AfterShip(String apiKey, AftershipOption options) {
        this(apiKey, null, null, options);
    }

    public AfterShip(String apiKey, AuthenticationType type, String apiSecret) {
        this(apiKey, type, apiSecret, null);
    }

    public AfterShip(String apiKey, AuthenticationType type, String apiSecret, AftershipOption options) {
        if (StrUtils.isBlank(apiKey)) {
            throw new IllegalArgumentException("ConstructorError: API key is null");
        }
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.authenticationType = type;
        this.signer = new HMACSigner(this.apiSecret);
        this.client = this.createClient(options);
        if (options != null) {
            String _version;
            this.version = _version = options.getVersion() != null ? options.getVersion().getValue() : DEFAULT_VERSION;
            this.endpoint = StrUtils.isNotBlank(options.getEndpoint()) ? options.getEndpoint() : String.format(DEFAULT_VERSION_ENDPOINT, _version);
            this.userAgentPrefix = StrUtils.isNotBlank(options.getUserAgentPrefix()) ? options.getUserAgentPrefix() : DEFAULT_USER_AGENT;
        } else {
            this.version = DEFAULT_VERSION;
            this.endpoint = String.format(DEFAULT_VERSION_ENDPOINT, this.version);
            this.userAgentPrefix = DEFAULT_USER_AGENT;
        }
        this.rateLimit = new RateLimit(null, null, null);
        ApiRequestImpl request = new ApiRequestImpl(this);
        this.courierEndpoint = new CourierImpl(request);
        this.trackingEndpoint = new TrackingImpl(request);
        this.checkpointEndpoint = new CheckpointImpl(request);
        this.notificationEndpoint = new NotificationImpl(request);
        this.estimatedDeliveryDateEndpoint = new EstimatedDeliveryDateImpl(request);
    }

    private OkHttpClient createClient(AftershipOption options) {
        RetryOption retryOption;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().callTimeout(this.getCallTimeout(options), TimeUnit.MILLISECONDS).connectTimeout(this.getConnectTimeout(options), TimeUnit.MILLISECONDS).readTimeout(this.getReadTimeout(options), TimeUnit.MILLISECONDS).writeTimeout(this.getWriteTimeout(options), TimeUnit.MILLISECONDS);
        if (!Objects.isNull(options) && !Objects.isNull(retryOption = options.getRetryOption())) {
            RetryInterceptor retryInterceptor = new RetryInterceptor(this.getRetryDelay(retryOption), this.getRetryMaxDelay(retryOption), this.getRetryCount(retryOption), this.getRetryConditions(retryOption));
            builder.addInterceptor((Interceptor)retryInterceptor);
        }
        return builder.build();
    }

    private long getCallTimeout(AftershipOption options) {
        if (options == null) {
            return 20000L;
        }
        return options.getCallTimeout() >= 0L ? options.getCallTimeout() : 20000L;
    }

    private long getConnectTimeout(AftershipOption options) {
        if (options == null) {
            return 20000L;
        }
        return options.getConnectTimeout() >= 0L ? options.getConnectTimeout() : 20000L;
    }

    private long getReadTimeout(AftershipOption options) {
        if (options == null) {
            return 20000L;
        }
        return options.getReadTimeout() >= 0L ? options.getReadTimeout() : 20000L;
    }

    private long getWriteTimeout(AftershipOption options) {
        if (options == null) {
            return 20000L;
        }
        return options.getWriteTimeout() >= 0L ? options.getWriteTimeout() : 20000L;
    }

    private List<RetryCondition> getRetryConditions(RetryOption retryOption) {
        List<RetryCondition> defaultRetryConditions = Arrays.asList((response, exception) -> exception != null || response != null && response.code() >= 500);
        if (retryOption == null) {
            return defaultRetryConditions;
        }
        return retryOption.getRetryConditions() != null && retryOption.getRetryConditions().size() > 0 ? retryOption.getRetryConditions() : defaultRetryConditions;
    }

    private long getRetryMaxDelay(RetryOption retryOption) {
        return retryOption.getRetryMaxDelay() > 0L ? retryOption.getRetryMaxDelay() : 18000L;
    }

    private long getRetryDelay(RetryOption retryOption) {
        return retryOption.getRetryDelay() > 0L ? retryOption.getRetryDelay() : 500L;
    }

    private int getRetryCount(RetryOption retryOption) {
        return retryOption.getRetryCount() > 0 ? retryOption.getRetryCount() : 10;
    }

    public void shutdown() throws IOException {
        if (this.client != null) {
            this.client.dispatcher().executorService().shutdown();
            this.client.connectionPool().evictAll();
            Cache cache = this.client.cache();
            if (cache != null) {
                cache.close();
            }
        }
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public AbstractSigner getSigner() {
        return this.signer;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUserAgentPrefix() {
        return this.userAgentPrefix;
    }

    public RateLimit getRateLimit() {
        return this.rateLimit;
    }

    public CourierEndpoint getCourierEndpoint() {
        return this.courierEndpoint;
    }

    public TrackingEndpoint getTrackingEndpoint() {
        return this.trackingEndpoint;
    }

    public CheckpointEndpoint getCheckpointEndpoint() {
        return this.checkpointEndpoint;
    }

    public NotificationEndpoint getNotificationEndpoint() {
        return this.notificationEndpoint;
    }

    public EstimatedDeliveryDateEndpoint getEstimatedDeliveryDateEndpoint() {
        return this.estimatedDeliveryDateEndpoint;
    }

    public void setRateLimit(RateLimit rateLimit) {
        this.rateLimit = rateLimit;
    }
}

