/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.auth;

import com.aftership.sdk.auth.SignHeader;
import com.aftership.sdk.auth.SignatureContent;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractSigner {
    private String secret;

    protected AbstractSigner(String secret) {
        this.secret = secret;
    }

    protected abstract SignHeader getHeader(String var1);

    public SignHeader sign(SignatureContent content) {
        String signString;
        try {
            URL url = new URL(content.getUrlStr());
            signString = this.getSignString(content.getMethod(), content.getBody(), content.getContentType(), content.getDate(), this.getCanonicalizedAmHeaders(content.getHeaders()), this.getCanonicalizedResource(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this.getHeader(signString);
    }

    private String getSignString(String method, String body, String contentType, String date, String canonicalizedAmHeaders, String canonicalizedResource) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(method);
        buffer.append("\n");
        if (body == null) {
            body = "";
        }
        if (!body.equals("")) {
            body = this.getMD5Str(body).toUpperCase();
        } else {
            contentType = "";
        }
        buffer.append(body).append("\n");
        buffer.append(contentType).append("\n");
        buffer.append(date).append("\n");
        buffer.append(canonicalizedAmHeaders).append("\n");
        buffer.append(canonicalizedResource);
        return buffer.toString();
    }

    private String getCanonicalizedAmHeaders(Map<String, String> headers) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(headers.keySet());
        StringBuilder buffer = new StringBuilder();
        sortedHeaders.sort(String.CASE_INSENSITIVE_ORDER);
        for (String key : sortedHeaders) {
            String newKey = key.toLowerCase();
            if (!newKey.startsWith("as-")) continue;
            String value = headers.get(key);
            buffer.append(newKey);
            buffer.append(":");
            if (value != null) {
                buffer.append(value);
            }
            buffer.append("\n");
        }
        return buffer.toString().trim();
    }

    private String getCanonicalizedResource(URL url) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(url.getPath());
        String query = url.getQuery();
        if (query == null) {
            return buffer.toString();
        }
        Object[] params = query.split("&");
        Arrays.sort(params);
        String queryStr = String.join((CharSequence)"&", (CharSequence[])params);
        buffer.append("?");
        buffer.append(queryStr);
        return buffer.toString();
    }

    private String getMD5Str(String str) {
        String result = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] digest = md5.digest(str.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            result = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSigner)) {
            return false;
        }
        AbstractSigner other = (AbstractSigner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSigner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractSigner(secret=" + this.getSecret() + ")";
    }
}

