/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.endpoint.impl;

import com.aftership.sdk.endpoint.AfterShipEndpoint;
import com.aftership.sdk.endpoint.TrackingEndpoint;
import com.aftership.sdk.exception.ApiException;
import com.aftership.sdk.exception.RequestException;
import com.aftership.sdk.exception.SdkException;
import com.aftership.sdk.model.AftershipResponse;
import com.aftership.sdk.model.tracking.CompletedStatus;
import com.aftership.sdk.model.tracking.GetTrackingParams;
import com.aftership.sdk.model.tracking.GetTrackingsParams;
import com.aftership.sdk.model.tracking.NewTracking;
import com.aftership.sdk.model.tracking.NewTrackingRequest;
import com.aftership.sdk.model.tracking.PagedTrackings;
import com.aftership.sdk.model.tracking.SingleTracking;
import com.aftership.sdk.model.tracking.SlugTrackingNumber;
import com.aftership.sdk.model.tracking.Tracking;
import com.aftership.sdk.model.tracking.UpdateTracking;
import com.aftership.sdk.model.tracking.UpdateTrackingRequest;
import com.aftership.sdk.request.ApiRequest;
import com.aftership.sdk.request.HttpMethod;

public class TrackingImpl
extends AfterShipEndpoint
implements TrackingEndpoint {
    public TrackingImpl(ApiRequest request) {
        super(request);
    }

    @Override
    public Tracking createTracking(NewTracking newTracking) throws SdkException, RequestException, ApiException {
        this.checkNullParam(newTracking);
        this.checkTrackingNumber(newTracking.getTrackingNumber());
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.POST, "/trackings", null, new NewTrackingRequest(newTracking), SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking deleteTracking(String id) throws SdkException, RequestException, ApiException {
        this.checkTrackingSlug(id);
        String path = this.buildTrackingPath(id, null, null, "/trackings", null);
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.DELETE, path, null, null, SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking deleteTracking(SlugTrackingNumber identifier) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/trackings", null);
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.DELETE, path, this.takeMap(identifier.getOptionalParams()), null, SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking getTracking(String id, GetTrackingParams optionalParams) throws SdkException, RequestException, ApiException {
        this.checkTrackingId(id);
        String path = this.buildTrackingPath(id, null, null, "/trackings", null);
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.GET, path, this.mergeMap(optionalParams), null, SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking getTracking(SlugTrackingNumber identifier, GetTrackingParams optionalParams) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/trackings", null);
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.GET, path, this.mergeMap(optionalParams, identifier.getOptionalParams()), null, SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public PagedTrackings getTrackings(GetTrackingsParams params) throws SdkException, RequestException, ApiException {
        String path = this.buildTrackingPath(null, null, null, "/trackings", null);
        AftershipResponse<PagedTrackings> response = this.request.makeRequest(HttpMethod.GET, path, params.toMap(), null, PagedTrackings.class);
        return this.extractData(response);
    }

    @Override
    public Tracking updateTracking(String id, UpdateTracking update) throws SdkException, RequestException, ApiException {
        this.checkTrackingId(id);
        String path = this.buildTrackingPath(id, null, null, "/trackings", null);
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.PUT, path, null, new UpdateTrackingRequest(update), SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking updateTracking(SlugTrackingNumber identifier, UpdateTracking update) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/trackings", null);
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.PUT, path, this.mergeMap(identifier.getOptionalParams()), new UpdateTrackingRequest(update), SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking reTrack(String id) throws SdkException, RequestException, ApiException {
        this.checkTrackingId(id);
        String path = this.buildTrackingPath(id, null, null, "/trackings", "retrack");
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.POST, path, null, new Object(), SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking reTrack(SlugTrackingNumber identifier) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/trackings", "retrack");
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.POST, path, this.mergeMap(identifier.getOptionalParams()), new Object(), SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking markAsCompleted(String id, CompletedStatus status) throws SdkException, RequestException, ApiException {
        this.checkTrackingId(id);
        String path = this.buildTrackingPath(id, null, null, "/trackings", "mark-as-completed");
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.POST, path, null, status, SingleTracking.class);
        return this.extractData(response).getTracking();
    }

    @Override
    public Tracking markAsCompleted(SlugTrackingNumber identifier, CompletedStatus status) throws SdkException, RequestException, ApiException {
        this.checkSlugTrackingNumber(identifier);
        String path = this.buildTrackingPath(null, identifier.getSlug(), identifier.getTrackingNumber(), "/trackings", "mark-as-completed");
        AftershipResponse<SingleTracking> response = this.request.makeRequest(HttpMethod.POST, path, this.mergeMap(identifier.getOptionalParams()), status, SingleTracking.class);
        return this.extractData(response).getTracking();
    }
}

