/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.request;

import com.aftership.sdk.AfterShip;
import com.aftership.sdk.auth.AuthenticationType;
import com.aftership.sdk.auth.SignHeader;
import com.aftership.sdk.auth.SignatureContent;
import com.aftership.sdk.exception.ApiException;
import com.aftership.sdk.exception.ErrorType;
import com.aftership.sdk.exception.RequestException;
import com.aftership.sdk.model.AftershipResponse;
import com.aftership.sdk.model.Meta;
import com.aftership.sdk.model.RateLimit;
import com.aftership.sdk.request.ApiRequest;
import com.aftership.sdk.request.BodyParser;
import com.aftership.sdk.request.HttpMethod;
import com.aftership.sdk.utils.Define;
import com.aftership.sdk.utils.JsonUtils;
import com.aftership.sdk.utils.StrUtils;
import com.aftership.sdk.utils.UrlUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ApiRequestImpl
implements ApiRequest {
    private static final String RATE_LIMIT_RESET = "x-ratelimit-reset";
    private static final String RATE_LIMIT_LIMIT = "x-ratelimit-limit";
    private static final String RATE_LIMIT_REMAINING = "x-ratelimit-remaining";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final AfterShip app;

    public ApiRequestImpl(AfterShip app) {
        this.app = app;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, R> AftershipResponse<R> makeRequest(HttpMethod method, String path, Map<String, String> queryParams, T requestData, Class<R> responseType) throws RequestException, ApiException {
        AuthenticationType authenticationType;
        if (StrUtils.isBlank(path)) {
            throw new IllegalArgumentException("ConstructorError: The path is empty");
        }
        if (responseType == null) {
            throw new IllegalArgumentException("ConstructorError: ResponseType is null");
        }
        String url = this.buildUrl(path, queryParams);
        final String requestId = StrUtils.uuid4();
        HashMap<String, String> requestHeaders = new HashMap<String, String>(){
            {
                this.put("Content-Type", JSON.toString());
                this.put("request-id", requestId);
                this.put("aftership-agent", "java-sdk-3.0.0");
            }
        };
        RequestBody requestBody = null;
        String reqBodyStr = "";
        if (requestData != null) {
            reqBodyStr = JsonUtils.getGson().toJson(requestData);
            requestBody = RequestBody.create((String)reqBodyStr, (MediaType)JSON);
        }
        if ((authenticationType = this.app.getAuthenticationType()) == AuthenticationType.AES) {
            requestHeaders.put("as-api-key", this.app.getApiKey());
            SimpleDateFormat sdf3 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            sdf3.setTimeZone(TimeZone.getTimeZone("GMT"));
            String date = sdf3.format(new Date());
            SignHeader signHeader = this.app.getSigner().sign(SignatureContent.builder().contentType(JSON.toString()).body(reqBodyStr).date(date).method(method.getName()).headers((Map<String, String>)requestHeaders).urlStr(url).build());
            if (signHeader.getSignature() == null) {
                throw new RequestException(ErrorType.ConstructorError, "ConstructorError: signature error", this.entryRequestConfig(method, path), this.entryRequestHeaders((Map<String, String>)requestHeaders), this.entryRequestData(requestData));
            }
            requestHeaders.put("date", date);
            requestHeaders.put(signHeader.getHeader(), signHeader.getSignature());
        } else {
            requestHeaders.put("as-api-key", this.app.getApiKey());
        }
        Request request = new Request.Builder().url(url).method(method.getName(), requestBody).headers(Headers.of((Map)requestHeaders)).build();
        Call call = this.app.getClient().newCall(request);
        try (Response response = call.execute();){
            String bodyString;
            this.setRateLimiting(this.app, response);
            String message = response.message();
            String string = bodyString = response.body() == null ? null : response.body().string();
            if (!response.isSuccessful()) {
                throw new ApiException(this.app.getRateLimit(), BodyParser.processMeta(bodyString), this.entryRequestConfig(method, path), this.entryRequestHeaders((Map<String, String>)requestHeaders), this.entryRequestData(requestData), this.entryResponseBody(message, bodyString));
            }
            if (StrUtils.isBlank(bodyString) || "{}".equals(bodyString)) {
                throw new RequestException(ErrorType.HandlerError, "HandlerError: return body json string is empty", this.entryRequestConfig(method, path), this.entryRequestHeaders((Map<String, String>)requestHeaders), this.entryRequestData(requestData));
            }
            JsonElement jsonElement = JsonParser.parseString((String)bodyString);
            if (!jsonElement.isJsonObject()) {
                throw new RequestException(ErrorType.HandlerError, "HandlerError: return response body is not a json object.", this.entryRequestConfig(method, path), this.entryRequestHeaders((Map<String, String>)requestHeaders), this.entryRequestData(requestData), this.entryResponseBody(message, bodyString));
            }
            AftershipResponse<R> result = this.processResponse(jsonElement, responseType);
            if (result.getMeta() == null) {
                throw new RequestException(ErrorType.HandlerError, "HandlerError: return meta is Null", this.entryRequestConfig(method, path), this.entryRequestHeaders((Map<String, String>)requestHeaders), this.entryRequestData(requestData), this.entryResponseBody(message, bodyString));
            }
            if (!ApiRequestImpl.isSuccessful(result.getMeta().getCode())) {
                throw new ApiException(this.app.getRateLimit(), result.getMeta(), this.entryRequestConfig(method, path), this.entryRequestHeaders((Map<String, String>)requestHeaders), this.entryRequestData(requestData), this.entryResponseBody(message, bodyString));
            }
            AftershipResponse<R> aftershipResponse = result;
            return aftershipResponse;
        }
        catch (ApiException | RequestException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new RequestException(ErrorType.HandlerError, t, this.entryRequestConfig(method, path), this.entryRequestHeaders((Map<String, String>)requestHeaders), this.entryRequestData(requestData));
        }
    }

    private <T> AftershipResponse<T> processResponse(JsonElement jsonElement, Class<T> responseType) {
        T body;
        AftershipResponse<T> responseEntity = new AftershipResponse<T>();
        Meta meta = BodyParser.processMeta(jsonElement.getAsJsonObject());
        if (meta != null) {
            responseEntity.setMeta(meta);
        }
        if ((body = BodyParser.processData(jsonElement.getAsJsonObject(), responseType)) != null) {
            responseEntity.setData(body);
        }
        return responseEntity;
    }

    private void setRateLimiting(AfterShip app, Response response) {
        if (response == null) {
            return;
        }
        RateLimit rateLimit = new RateLimit();
        if (StrUtils.isNotBlank(response.header(RATE_LIMIT_RESET))) {
            rateLimit.setReset(Long.parseLong(Objects.requireNonNull(response.header(RATE_LIMIT_RESET))));
        }
        if (StrUtils.isNotBlank(response.header(RATE_LIMIT_LIMIT))) {
            rateLimit.setLimit(Integer.parseInt(Objects.requireNonNull(response.header(RATE_LIMIT_LIMIT))));
        }
        if (StrUtils.isNotBlank(response.header(RATE_LIMIT_REMAINING))) {
            rateLimit.setRemaining(Integer.parseInt(Objects.requireNonNull(response.header(RATE_LIMIT_REMAINING))));
        }
        app.setRateLimit(rateLimit);
    }

    private AbstractMap.SimpleEntry<String, Object> entryRequestConfig(final HttpMethod method, final String path) {
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("method", method.getName());
                this.put("path", path);
            }
        };
        return new AbstractMap.SimpleEntry<String, Object>("requestConfig", map);
    }

    private AbstractMap.SimpleEntry<String, Object> entryRequestHeaders(Map<String, String> requestHeaders) {
        return new AbstractMap.SimpleEntry<String, Object>("requestHeaders", requestHeaders);
    }

    private <T> AbstractMap.SimpleEntry<String, Object> entryRequestData(T requestData) {
        return new AbstractMap.SimpleEntry<String, Object>("requestData", requestData);
    }

    private AbstractMap.SimpleEntry<String, Object> entryResponseBody(String message, String bodyString) {
        String tag = "responseBody";
        if (StrUtils.isNotBlank(message)) {
            return new AbstractMap.SimpleEntry<String, Object>(tag, null);
        }
        return new AbstractMap.SimpleEntry<String, Object>(tag, bodyString);
    }

    private String buildUrl(String path, Map<String, String> query) {
        String url = this.app.getEndpoint() + path;
        if (query != null && query.size() > 0) {
            url = UrlUtils.fillPathWithQuery(url, query);
        }
        return url;
    }

    private static boolean isSuccessful(int code) {
        for (int i : Define.SUCCESSFUL_CODE_RANGE) {
            if (i != code) continue;
            return true;
        }
        return false;
    }

    public static <T> T requireResponseBodyNonNull(T obj) throws RequestException {
        if (obj == null) {
            throw new RequestException(ErrorType.HandlerError, "HandlerError: return response body object is null", new Map.Entry[0]);
        }
        return obj;
    }
}

